/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutException;
import org.apache.ignite.spi.communication.tcp.AttributeNames;
import org.apache.ignite.spi.communication.tcp.internal.HandshakeException;

public class CommunicationTcpUtils {
    public static final IgniteRunnable NOOP = () -> {};
    private static final boolean THROUBLESHOOTING_LOG_ENABLED = IgniteSystemProperties.getBoolean("IGNITE_TROUBLESHOOTING_LOGGER");

    public static boolean usePairedConnections(ClusterNode node, String attributeName) {
        Boolean attr = (Boolean)node.attribute(attributeName);
        return attr != null && attr != false;
    }

    public static void writeMessageType(OutputStream os, short type) throws IOException {
        os.write((byte)(type & 0xFF));
        os.write((byte)(type >> 8 & 0xFF));
    }

    public static Collection<InetSocketAddress> nodeAddresses(ClusterNode node, boolean filterReachableAddrs, AttributeNames attrs, Supplier<ClusterNode> localNode) throws IgniteCheckedException {
        LinkedHashSet<InetSocketAddress> addrs;
        boolean isExtAddrsExist;
        Collection rmtAddrs0 = (Collection)node.attribute(attrs.addresses());
        Collection rmtHostNames0 = (Collection)node.attribute(attrs.hostNames());
        Integer boundPort = (Integer)node.attribute(attrs.port());
        Collection extAddrs = (Collection)node.attribute(attrs.externalizableAttributes());
        boolean isRmtAddrsExist = !F.isEmpty(rmtAddrs0) && boundPort != null;
        boolean bl = isExtAddrsExist = !F.isEmpty(extAddrs);
        if (!isRmtAddrsExist && !isExtAddrsExist) {
            throw new IgniteCheckedException("Failed to send message to the destination node. Node doesn't have any TCP communication addresses or mapped external addresses. Check configuration and make sure that you use the same communication SPI on all nodes. Remote node id: " + node.id());
        }
        if (isRmtAddrsExist) {
            ArrayList<InetSocketAddress> addrs0 = new ArrayList<InetSocketAddress>(U.toSocketAddresses(rmtAddrs0, rmtHostNames0, boundPort));
            boolean sameHost = U.sameMacs(localNode.get(), node);
            addrs0.sort(U.inetAddressesComparator(sameHost));
            addrs = new LinkedHashSet<InetSocketAddress>(addrs0);
        } else {
            addrs = new LinkedHashSet<InetSocketAddress>();
        }
        if (isExtAddrsExist) {
            addrs.addAll(extAddrs);
        }
        if (filterReachableAddrs) {
            HashSet<InetAddress> allInetAddrs = U.newHashSet(addrs.size());
            for (InetSocketAddress addr : addrs) {
                if (addr.isUnresolved()) continue;
                allInetAddrs.add(addr.getAddress());
            }
            List<InetAddress> reachableInetAddrs = U.filterReachable(allInetAddrs);
            if (reachableInetAddrs.size() < allInetAddrs.size()) {
                LinkedHashSet addrs0 = U.newLinkedHashSet(addrs.size());
                ArrayList<InetSocketAddress> unreachableInetAddr = new ArrayList<InetSocketAddress>(allInetAddrs.size() - reachableInetAddrs.size());
                for (InetSocketAddress addr : addrs) {
                    if (reachableInetAddrs.contains(addr.getAddress())) {
                        addrs0.add(addr);
                        continue;
                    }
                    unreachableInetAddr.add(addr);
                }
                addrs0.addAll(unreachableInetAddr);
                addrs = addrs0;
            }
        }
        return addrs;
    }

    public static IgniteSpiOperationTimeoutException handshakeTimeoutException() {
        return new IgniteSpiOperationTimeoutException("Failed to perform handshake due to timeout (consider increasing 'connectionTimeout' configuration property).");
    }

    public static boolean isRecoverableException(Throwable errs) {
        return X.hasCause(errs, IOException.class, HandshakeException.class, IgniteSpiOperationTimeoutException.class);
    }

    public static void failNode(ClusterNode nodeToFail, IgniteSpiContext spiCtx, Throwable err, IgniteLogger log) {
        assert (nodeToFail.isClient());
        String logMsg = "TcpCommunicationSpi failed to establish connection to node, node will be dropped from cluster [rmtNode=" + nodeToFail + ']';
        if (THROUBLESHOOTING_LOG_ENABLED) {
            U.error(log, logMsg, err);
        } else {
            U.warn(log, logMsg);
        }
        spiCtx.failNode(nodeToFail.id(), "TcpCommunicationSpi failed to establish connection to node [rmtNode=" + nodeToFail + ", err=" + err + ", connectErrs=" + X.getSuppressedList(err) + ']');
    }
}

