/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOV2;
import org.apache.ignite.internal.util.GridStringBuilder;

public class PagePartitionMetaIOV3
extends PagePartitionMetaIOV2 {
    private static final int ENCRYPT_PAGE_IDX_OFF = 161;
    protected static final int ENCRYPT_PAGE_MAX_OFF = 165;

    public PagePartitionMetaIOV3(int ver) {
        super(ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setEncryptedPageIndex(pageAddr, 0);
        this.setEncryptedPageCount(pageAddr, 0);
    }

    @Override
    public int getEncryptedPageIndex(long pageAddr) {
        return PageUtils.getInt(pageAddr, 161);
    }

    @Override
    public boolean setEncryptedPageIndex(long pageAddr, int pageIdx) {
        if (this.getEncryptedPageIndex(pageAddr) == pageIdx) {
            return false;
        }
        PageUtils.putLong(pageAddr, 161, pageIdx);
        return true;
    }

    @Override
    public int getEncryptedPageCount(long pageAddr) {
        return PageUtils.getInt(pageAddr, 165);
    }

    @Override
    public boolean setEncryptedPageCount(long pageAddr, int pagesCnt) {
        if (this.getEncryptedPageCount(pageAddr) == pagesCnt) {
            return false;
        }
        PageUtils.putInt(pageAddr, 165, pagesCnt);
        return true;
    }

    @Override
    protected void printFields(long pageAddr, GridStringBuilder sb) {
        super.printFields(pageAddr, sb);
        sb.a(",\n\tencryptedPageIndex=").a(this.getEncryptedPageIndex(pageAddr)).a(",\n\tencryptedPageCount=").a(this.getEncryptedPageCount(pageAddr));
    }

    @Override
    public void upgradePage(long pageAddr) {
        assert (PageIO.getType(pageAddr) == this.getType());
        int ver = PageIO.getVersion(pageAddr);
        assert (ver < this.getVersion());
        if (ver < 2) {
            super.upgradePage(pageAddr);
        }
        PageIO.setVersion(pageAddr, this.getVersion());
        this.setEncryptedPageIndex(pageAddr, 0);
        this.setEncryptedPageCount(pageAddr, 0);
    }
}

