/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.Collection;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.mxbean.DataStorageMetricsMXBean;
import org.jetbrains.annotations.Nullable;

public class DataStorageMetricsImpl
implements DataStorageMetricsMXBean {
    public static final String DATASTORAGE_METRIC_PREFIX = "io.datastorage";
    private final HitRateMetric walLoggingRate;
    private final HitRateMetric walWritingRate;
    private final HitRateMetric walFsyncTimeDuration;
    private final HitRateMetric walFsyncTimeNum;
    private final HitRateMetric walBuffPollSpinsNum;
    private final AtomicLongMetric lastCpBeforeLockDuration;
    private final AtomicLongMetric lastCpLockWaitDuration;
    private final AtomicLongMetric lastCpListenersExecuteDuration;
    private final AtomicLongMetric lastCpMarkDuration;
    private final AtomicLongMetric lastCpLockHoldDuration;
    private final AtomicLongMetric lastCpPagesWriteDuration;
    private final AtomicLongMetric lastCpDuration;
    private final AtomicLongMetric lastCpStart;
    private final AtomicLongMetric lastCpFsyncDuration;
    private final AtomicLongMetric lastCpWalRecordFsyncDuration;
    private final AtomicLongMetric lastCpWriteEntryDuration;
    private final AtomicLongMetric lastCpSplitAndSortPagesDuration;
    private final AtomicLongMetric lastCpTotalPages;
    private final AtomicLongMetric lastCpDataPages;
    private final AtomicLongMetric lastCpCowPages;
    private volatile long rateTimeInterval;
    private volatile int subInts;
    private volatile boolean metricsEnabled;
    @Nullable
    private volatile IgniteWriteAheadLogManager wal;
    private volatile IgniteOutClosure<Long> walSizeProvider;
    private final AtomicLongMetric lastWalSegmentRollOverTime;
    private final AtomicLongMetric totalCheckpointTime;
    private volatile Collection<DataRegionMetrics> regionMetrics;
    private final AtomicLongMetric storageSize;
    private final AtomicLongMetric sparseStorageSize;
    private final HistogramMetricImpl cpBeforeLockHistogram;
    private final HistogramMetricImpl cpLockWaitHistogram;
    private final HistogramMetricImpl cpListenersExecuteHistogram;
    private final HistogramMetricImpl cpMarkHistogram;
    private final HistogramMetricImpl cpLockHoldHistogram;
    private final HistogramMetricImpl cpPagesWriteHistogram;
    private final HistogramMetricImpl cpFsyncHistogram;
    private final HistogramMetricImpl cpWalRecordFsyncHistogram;
    private final HistogramMetricImpl cpWriteEntryHistogram;
    private final HistogramMetricImpl cpSplitAndSortPagesHistogram;
    private final HistogramMetricImpl cpHistogram;
    private final LongAdderMetric walWrittenBytes;
    private final LongAdderMetric walCompressedBytes;

    public DataStorageMetricsImpl(GridMetricManager mmgr, boolean metricsEnabled, long rateTimeInterval, int subInts) {
        this.metricsEnabled = metricsEnabled;
        this.rateTimeInterval = rateTimeInterval;
        this.subInts = subInts;
        MetricRegistry mreg = mmgr.registry(DATASTORAGE_METRIC_PREFIX);
        this.walLoggingRate = mreg.hitRateMetric("WalLoggingRate", "Average number of WAL records per second written during the last time interval.", rateTimeInterval, subInts);
        this.walWritingRate = mreg.hitRateMetric("WalWritingRate", "Average number of bytes per second written during the last time interval.", rateTimeInterval, subInts);
        this.walFsyncTimeDuration = mreg.hitRateMetric("WalFsyncTimeDuration", "Total duration of fsync", rateTimeInterval, subInts);
        this.walFsyncTimeNum = mreg.hitRateMetric("WalFsyncTimeNum", "Total count of fsync", rateTimeInterval, subInts);
        this.walBuffPollSpinsNum = mreg.hitRateMetric("WalBuffPollSpinsRate", "WAL buffer poll spins number over the last time interval.", rateTimeInterval, subInts);
        this.lastCpBeforeLockDuration = mreg.longMetric("LastCheckpointBeforeLockDuration", "Duration of the checkpoint action before taken write lock in milliseconds.");
        this.lastCpLockWaitDuration = mreg.longMetric("LastCheckpointLockWaitDuration", "Duration of the checkpoint lock wait in milliseconds.");
        this.lastCpListenersExecuteDuration = mreg.longMetric("LastCheckpointListenersExecuteDuration", "Duration of the checkpoint execution listeners under write lock in milliseconds.");
        this.lastCpMarkDuration = mreg.longMetric("LastCheckpointMarkDuration", "Duration of the checkpoint mark in milliseconds.");
        this.lastCpLockHoldDuration = mreg.longMetric("LastCheckpointLockHoldDuration", "Duration of the checkpoint lock hold in milliseconds.");
        this.lastCpPagesWriteDuration = mreg.longMetric("LastCheckpointPagesWriteDuration", "Duration of the checkpoint pages write in milliseconds.");
        this.lastCpDuration = mreg.longMetric("LastCheckpointDuration", "Duration of the last checkpoint in milliseconds.");
        this.lastCpStart = mreg.longMetric("LastCheckpointStart", "Start timestamp of the last checkpoint.");
        this.lastCpFsyncDuration = mreg.longMetric("LastCheckpointFsyncDuration", "Duration of the sync phase of the last checkpoint in milliseconds.");
        this.lastCpWalRecordFsyncDuration = mreg.longMetric("LastCheckpointWalRecordFsyncDuration", "Duration of the WAL fsync after logging CheckpointRecord on the start of the last checkpoint in milliseconds.");
        this.lastCpWriteEntryDuration = mreg.longMetric("LastCheckpointWriteEntryDuration", "Duration of entry buffer writing to file of the last checkpoint in milliseconds.");
        this.lastCpSplitAndSortPagesDuration = mreg.longMetric("LastCheckpointSplitAndSortPagesDuration", "Duration of splitting and sorting checkpoint pages of the last checkpoint in milliseconds.");
        this.lastCpTotalPages = mreg.longMetric("LastCheckpointTotalPagesNumber", "Total number of pages written during the last checkpoint.");
        this.lastCpDataPages = mreg.longMetric("LastCheckpointDataPagesNumber", "Total number of data pages written during the last checkpoint.");
        this.lastCpCowPages = mreg.longMetric("LastCheckpointCopiedOnWritePagesNumber", "Number of pages copied to a temporary checkpoint buffer during the last checkpoint.");
        this.lastWalSegmentRollOverTime = mreg.longMetric("WalLastRollOverTime", "Time of the last WAL segment rollover.");
        this.totalCheckpointTime = mreg.longMetric("CheckpointTotalTime", "Total duration of checkpoint");
        this.storageSize = mreg.longMetric("StorageSize", "Storage space allocated, in bytes.");
        this.sparseStorageSize = mreg.longMetric("SparseStorageSize", "Storage space allocated adjusted for possible sparsity, in bytes.");
        mreg.register("WalArchiveSegments", this::getWalArchiveSegments, "Current number of WAL segments in the WAL archive.");
        mreg.register("WalTotalSize", this::getWalTotalSize, "Total size in bytes for storage wal files.");
        long[] cpBounds = new long[]{100L, 500L, 1000L, 5000L, 30000L};
        this.cpBeforeLockHistogram = mreg.histogram("CheckpointBeforeLockHistogram", cpBounds, "Histogram of checkpoint action before taken write lock duration in milliseconds.");
        this.cpLockWaitHistogram = mreg.histogram("CheckpointLockWaitHistogram", cpBounds, "Histogram of checkpoint lock wait duration in milliseconds.");
        this.cpListenersExecuteHistogram = mreg.histogram("CheckpointListenersExecuteHistogram", cpBounds, "Histogram of checkpoint execution listeners under write lock duration in milliseconds.");
        this.cpMarkHistogram = mreg.histogram("CheckpointMarkHistogram", cpBounds, "Histogram of checkpoint mark duration in milliseconds.");
        this.cpLockHoldHistogram = mreg.histogram("CheckpointLockHoldHistogram", cpBounds, "Histogram of checkpoint lock hold duration in milliseconds.");
        this.cpPagesWriteHistogram = mreg.histogram("CheckpointPagesWriteHistogram", cpBounds, "Histogram of checkpoint pages write duration in milliseconds.");
        this.cpFsyncHistogram = mreg.histogram("CheckpointFsyncHistogram", cpBounds, "Histogram of checkpoint fsync duration in milliseconds.");
        this.cpWalRecordFsyncHistogram = mreg.histogram("CheckpointWalRecordFsyncHistogram", cpBounds, "Histogram of the WAL fsync after logging CheckpointRecord on begin of checkpoint duration in milliseconds.");
        this.cpWriteEntryHistogram = mreg.histogram("CheckpointWriteEntryHistogram", cpBounds, "Histogram of entry buffer writing to file duration in milliseconds.");
        this.cpSplitAndSortPagesHistogram = mreg.histogram("CheckpointSplitAndSortPagesHistogram", cpBounds, "Histogram of splitting and sorting checkpoint pages duration in milliseconds.");
        this.cpHistogram = mreg.histogram("CheckpointHistogram", cpBounds, "Histogram of checkpoint duration in milliseconds.");
        this.walWrittenBytes = mreg.longAdderMetric("WalWrittenBytes", "Total number of logged bytes into the WAL.");
        this.walCompressedBytes = mreg.longAdderMetric("WalCompressedBytes", "Total size of the compressed segments in bytes.");
    }

    @Override
    public float getWalLoggingRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.walLoggingRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getWalWritingRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.walWritingRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public int getWalArchiveSegments() {
        if (!this.metricsEnabled) {
            return 0;
        }
        IgniteWriteAheadLogManager walMgr = this.wal;
        return walMgr == null ? 0 : walMgr.walArchiveSegments();
    }

    @Override
    public float getWalFsyncTimeAverage() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        long numRate = this.walFsyncTimeNum.value();
        if (numRate == 0L) {
            return 0.0f;
        }
        return (float)this.walFsyncTimeDuration.value() / (float)numRate;
    }

    @Override
    public long getWalBuffPollSpinsRate() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.walBuffPollSpinsNum.value();
    }

    @Override
    public long getLastCheckpointDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpDuration.value();
    }

    @Override
    public long getLastCheckpointStarted() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpStart.value();
    }

    @Override
    public long getLastCheckpointLockWaitDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpLockWaitDuration.value();
    }

    @Override
    public long getLastCheckpointMarkDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpMarkDuration.value();
    }

    @Override
    public long getLastCheckpointPagesWriteDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpPagesWriteDuration.value();
    }

    @Override
    public long getLastCheckpointFsyncDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpFsyncDuration.value();
    }

    @Override
    public long getLastCheckpointTotalPagesNumber() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpTotalPages.value();
    }

    @Override
    public long getLastCheckpointDataPagesNumber() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpDataPages.value();
    }

    @Override
    public long getLastCheckpointCopiedOnWritePagesNumber() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpCowPages.value();
    }

    @Override
    public void enableMetrics() {
        this.metricsEnabled = true;
    }

    @Override
    public void disableMetrics() {
        this.metricsEnabled = false;
    }

    @Override
    public void rateTimeInterval(long rateTimeInterval) {
        this.rateTimeInterval = rateTimeInterval;
        this.resetRates();
    }

    @Override
    public void subIntervals(int subInts) {
        this.subInts = subInts;
        this.resetRates();
    }

    @Override
    public long getWalTotalSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        IgniteOutClosure<Long> walSize = this.walSizeProvider;
        return walSize != null ? walSize.apply() : 0L;
    }

    @Override
    public long getWalLastRollOverTime() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastWalSegmentRollOverTime.value();
    }

    @Override
    public long getCheckpointTotalTime() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.totalCheckpointTime.value();
    }

    @Override
    public long getDirtyPages() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long dirtyPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            dirtyPages += rm.getDirtyPages();
        }
        return dirtyPages;
    }

    @Override
    public long getPagesRead() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long readPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            readPages += rm.getPagesRead();
        }
        return readPages;
    }

    @Override
    public long getPagesWritten() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long writtenPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            writtenPages += rm.getPagesWritten();
        }
        return writtenPages;
    }

    @Override
    public long getPagesReplaced() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long replacedPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            replacedPages += rm.getPagesReplaced();
        }
        return replacedPages;
    }

    @Override
    public long getOffHeapSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long offHeapSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            offHeapSize += rm.getOffHeapSize();
        }
        return offHeapSize;
    }

    @Override
    public long getOffheapUsedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long offHeapUsedSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            offHeapUsedSize += rm.getOffheapUsedSize();
        }
        return offHeapUsedSize;
    }

    @Override
    public long getTotalAllocatedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long totalAllocatedSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            totalAllocatedSize += rm.getTotalAllocatedSize();
        }
        return totalAllocatedSize;
    }

    @Override
    public long getUsedCheckpointBufferPages() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long usedCheckpointBufferPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            usedCheckpointBufferPages += rm.getUsedCheckpointBufferPages();
        }
        return usedCheckpointBufferPages;
    }

    @Override
    public long getUsedCheckpointBufferSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long usedCheckpointBufferSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            usedCheckpointBufferSize += rm.getUsedCheckpointBufferSize();
        }
        return usedCheckpointBufferSize;
    }

    @Override
    public long getCheckpointBufferSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long checkpointBufferSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            checkpointBufferSize += rm.getCheckpointBufferSize();
        }
        return checkpointBufferSize;
    }

    public void wal(IgniteWriteAheadLogManager wal) {
        this.wal = wal;
    }

    public void setWalSizeProvider(IgniteOutClosure<Long> walSizeProvider) {
        this.walSizeProvider = walSizeProvider;
    }

    public void onWallRollOver() {
        this.lastWalSegmentRollOverTime.value(U.currentTimeMillis());
    }

    public void regionMetrics(Collection<DataRegionMetrics> regionMetrics) {
        this.regionMetrics = regionMetrics;
    }

    public boolean metricsEnabled() {
        return this.metricsEnabled;
    }

    @Override
    public long getStorageSize() {
        return this.storageSize.value();
    }

    @Override
    public long getSparseStorageSize() {
        return this.sparseStorageSize.value();
    }

    public void onCheckpoint(long beforeLockDuration, long lockWaitDuration, long listenersExecuteDuration, long markDuration, long lockHoldDuration, long pagesWriteDuration, long fsyncDuration, long walRecordFsyncDuration, long writeEntryDuration, long splitAndSortPagesDuration, long duration, long start, long totalPages, long dataPages, long cowPages) {
        if (this.metricsEnabled) {
            this.lastCpBeforeLockDuration.value(beforeLockDuration);
            this.lastCpLockWaitDuration.value(lockWaitDuration);
            this.lastCpListenersExecuteDuration.value(listenersExecuteDuration);
            this.lastCpMarkDuration.value(markDuration);
            this.lastCpLockHoldDuration.value(lockHoldDuration);
            this.lastCpPagesWriteDuration.value(pagesWriteDuration);
            this.lastCpFsyncDuration.value(fsyncDuration);
            this.lastCpWalRecordFsyncDuration.value(walRecordFsyncDuration);
            this.lastCpWriteEntryDuration.value(writeEntryDuration);
            this.lastCpSplitAndSortPagesDuration.value(splitAndSortPagesDuration);
            this.lastCpDuration.value(duration);
            this.lastCpStart.value(start);
            this.lastCpTotalPages.value(totalPages);
            this.lastCpDataPages.value(dataPages);
            this.lastCpCowPages.value(cowPages);
            this.totalCheckpointTime.add(duration);
            this.cpBeforeLockHistogram.value(beforeLockDuration);
            this.cpLockWaitHistogram.value(lockWaitDuration);
            this.cpListenersExecuteHistogram.value(listenersExecuteDuration);
            this.cpMarkHistogram.value(markDuration);
            this.cpLockHoldHistogram.value(lockHoldDuration);
            this.cpPagesWriteHistogram.value(pagesWriteDuration);
            this.cpFsyncHistogram.value(fsyncDuration);
            this.cpWalRecordFsyncHistogram.value(walRecordFsyncDuration);
            this.cpWriteEntryHistogram.value(writeEntryDuration);
            this.cpSplitAndSortPagesHistogram.value(splitAndSortPagesDuration);
            this.cpHistogram.value(duration);
        }
    }

    public void onStorageSizeChanged(long storageSize, long sparseStorageSize) {
        if (this.metricsEnabled) {
            this.storageSize.value(storageSize);
            this.sparseStorageSize.value(sparseStorageSize);
        }
    }

    public void onWalRecordLogged(long size) {
        this.walLoggingRate.increment();
        this.walWrittenBytes.add(size);
    }

    public void onWalBytesWritten(int size) {
        this.walWritingRate.add(size);
    }

    public void onFsync(long nanoTime) {
        long microseconds = nanoTime / 1000L;
        this.walFsyncTimeDuration.add(microseconds);
        this.walFsyncTimeNum.increment();
    }

    public void onBuffPollSpin(int num) {
        this.walBuffPollSpinsNum.add(num);
    }

    private void resetRates() {
        this.walLoggingRate.reset(this.rateTimeInterval, this.subInts);
        this.walWritingRate.reset(this.rateTimeInterval, this.subInts);
        this.walBuffPollSpinsNum.reset(this.rateTimeInterval, this.subInts);
        this.walFsyncTimeDuration.reset(this.rateTimeInterval, this.subInts);
        this.walFsyncTimeNum.reset(this.rateTimeInterval, this.subInts);
    }

    @Override
    public long getWalWrittenBytes() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.walWrittenBytes.value();
    }

    @Override
    public long getWalCompressedBytes() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.walCompressedBytes.value();
    }

    public void onWalSegmentCompressed(long size) {
        this.walCompressedBytes.add(size);
    }
}

