/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.LongIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class LongInlineIndexKeyType
extends NullableInlineIndexKeyType<LongIndexKey> {
    public LongInlineIndexKeyType() {
        super(5, (short)8);
    }

    @Override
    protected int put0(long pageAddr, int off, LongIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        PageUtils.putLong(pageAddr, off + 1, (Long)key.key());
        return this.keySize + 1;
    }

    @Override
    protected LongIndexKey get0(long pageAddr, int off) {
        long key = PageUtils.getLong(pageAddr, off + 1);
        return new LongIndexKey(key);
    }

    @Override
    public int compare0(long pageAddr, int off, LongIndexKey key) {
        long val1 = PageUtils.getLong(pageAddr, off + 1);
        return Integer.signum(Long.compare(val1, (Long)key.key()));
    }

    @Override
    protected int inlineSize0(LongIndexKey key) {
        return this.keySize + 1;
    }
}

