/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import java.util.Arrays;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.BytesIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.SignedBytesIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.util.GridUnsafe;

public class BytesInlineIndexKeyType
extends NullableInlineIndexKeyType<BytesIndexKey> {
    private final boolean compareBinaryUnsigned;

    public BytesInlineIndexKeyType() {
        this(12);
    }

    public BytesInlineIndexKeyType(int type) {
        this(type, true);
    }

    public BytesInlineIndexKeyType(boolean compareBinaryUnsigned) {
        this(12, compareBinaryUnsigned);
    }

    public BytesInlineIndexKeyType(int type, boolean compareBinaryUnsigned) {
        super(type, (short)-1);
        this.compareBinaryUnsigned = compareBinaryUnsigned;
    }

    @Override
    public int compare0(long pageAddr, int off, BytesIndexKey bytes) {
        int i;
        long addr = pageAddr + (long)off + 1L;
        int len1 = PageUtils.getShort(pageAddr, off + 1) & Short.MAX_VALUE;
        addr += 2L;
        byte[] arr = (byte[])bytes.key();
        int len2 = arr.length;
        int len = Math.min(len1, len2);
        if (this.compareBinaryUnsigned) {
            for (i = 0; i < len; ++i) {
                int b2;
                int b1 = GridUnsafe.getByte(addr + (long)i) & 0xFF;
                if (b1 == (b2 = arr[i] & 0xFF)) continue;
                return Integer.signum(b1 - b2);
            }
        } else {
            for (i = 0; i < len; ++i) {
                byte b2;
                byte b1 = GridUnsafe.getByte(addr + (long)i);
                if (b1 == (b2 = arr[i])) continue;
                return Integer.signum(b1 - b2);
            }
        }
        int res = Integer.signum(len1 - len2);
        if (this.isValueFull(pageAddr, off)) {
            return res;
        }
        if (res >= 0) {
            return 1;
        }
        return -2;
    }

    @Override
    protected int put0(long pageAddr, int off, BytesIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        byte[] val = (byte[])key.key();
        if (val.length + 3 <= maxSize) {
            short size = (short)val.length;
            PageUtils.putShort(pageAddr, off + 1, size);
            PageUtils.putBytes(pageAddr, off + 3, val);
            return size + 3;
        }
        short size = (short)(maxSize - 3 | 0x8000);
        PageUtils.putShort(pageAddr, off + 1, size);
        PageUtils.putBytes(pageAddr, off + 3, Arrays.copyOfRange(val, 0, maxSize - 3));
        return maxSize;
    }

    @Override
    protected BytesIndexKey get0(long pageAddr, int off) {
        byte[] arr = this.readBytes(pageAddr, off);
        return this.compareBinaryUnsigned ? new BytesIndexKey(arr) : new SignedBytesIndexKey(arr);
    }

    @Override
    protected int inlineSize0(BytesIndexKey val) {
        byte[] arr = (byte[])val.key();
        return arr.length + 3;
    }

    public boolean compareBinaryUnsigned() {
        return this.compareBinaryUnsigned;
    }

    private boolean isValueFull(long pageAddr, int off) {
        return (PageUtils.getShort(pageAddr, off + 1) & 0x8000) == 0;
    }
}

