/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.standard;

import java.util.stream.Stream;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.util.generators.DataStreamGenerator;
import org.apache.ignite.ml.util.generators.primitives.scalar.UniformRandomProducer;

public class RegressionDataStream
implements DataStreamGenerator {
    private final IgniteFunction<Vector, Double> function;
    private final double minXVal;
    private final double maxXVal;
    private final int vectorSize;
    private long seed;

    private RegressionDataStream(int vectorSize, IgniteFunction<Vector, Double> function, double minXVal, double maxXVal, long seed) {
        A.ensure((vectorSize > 0 ? 1 : 0) != 0, (String)"vectorSize > 0");
        A.ensure((minXVal <= maxXVal ? 1 : 0) != 0, (String)"minXValue <= maxXValue");
        this.function = function;
        this.minXVal = minXVal;
        this.maxXVal = maxXVal;
        this.seed = seed;
        this.vectorSize = vectorSize;
    }

    public RegressionDataStream(int vectorSize, IgniteFunction<Vector, Double> function, double minXVal, double maxXVal) {
        this(vectorSize, function, minXVal, maxXVal, System.currentTimeMillis());
    }

    @Override
    public Stream<LabeledVector<Double>> labeled() {
        this.seed *= 2L;
        return new UniformRandomProducer(this.minXVal, this.maxXVal, this.seed).vectorize(this.vectorSize).asDataStream().labeled(this.function);
    }

    public static RegressionDataStream twoDimensional(IgniteFunction<Double, Double> function, double minXVal, double maxXVal) {
        return RegressionDataStream.twoDimensional(function, minXVal, maxXVal, System.currentTimeMillis());
    }

    public static RegressionDataStream twoDimensional(IgniteFunction<Double, Double> function, double minXVal, double maxXVal, long seed) {
        return new RegressionDataStream(1, v -> (Double)function.apply(v.get(0)), minXVal, maxXVal, seed);
    }
}

