/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.inference.json.JSONModelMixIn;
import org.apache.ignite.ml.inference.json.JSONWritable;
import org.apache.ignite.ml.inference.json.JacksonHelper;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.tree.DecisionTreeNode;
import org.apache.ignite.ml.tree.DecisionTreeTrainer;

public class DecisionTreeModel
implements IgniteModel<Vector, Double>,
JSONWritable {
    private DecisionTreeNode rootNode;

    public DecisionTreeModel(DecisionTreeNode rootNode) {
        this.rootNode = rootNode;
    }

    private DecisionTreeModel() {
    }

    public DecisionTreeNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public Double predict(Vector features) {
        return (Double)this.rootNode.predict(features);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean pretty) {
        return DecisionTreeTrainer.printTree(this.rootNode, pretty);
    }

    @Override
    public void toJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.addMixIn(DecisionTreeModel.class, JSONModelMixIn.class);
        ObjectWriter writer = mapper.writerFor(DecisionTreeModel.class).withAttribute((Object)"formatVersion", (Object)"1").withAttribute((Object)"timestamp", (Object)System.currentTimeMillis()).withAttribute((Object)"uid", (Object)("dt_" + UUID.randomUUID().toString())).withAttribute((Object)"modelClass", (Object)DecisionTreeModel.class.getSimpleName());
        try {
            File file = new File(path.toAbsolutePath().toString());
            writer.writeValue(file, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static DecisionTreeModel fromJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JacksonHelper.readAndValidateBasicJsonModelProperties(path, mapper, DecisionTreeModel.class.getSimpleName());
            DecisionTreeModel mdl = (DecisionTreeModel)mapper.readValue(new File(path.toAbsolutePath().toString()), DecisionTreeModel.class);
            return mdl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

