/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.io.Serializable;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.BinaryClassificationPointwiseMetricStatsAggregator;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetric;

public class Precision<L extends Serializable>
extends BinaryClassificationMetric<L> {
    private static final long serialVersionUID = 2112795951652050170L;
    private Double precision = Double.NaN;

    public Precision(L truthLabel, L falseLabel) {
        super(truthLabel, falseLabel);
    }

    public Precision() {
    }

    public Precision<L> initBy(BinaryClassificationPointwiseMetricStatsAggregator<L> aggr) {
        this.precision = (double)aggr.getTruePositive() / (double)(aggr.getTruePositive() + aggr.getFalsePositive());
        return this;
    }

    @Override
    public double value() {
        return this.precision;
    }

    @Override
    public MetricName name() {
        return MetricName.PRECISION;
    }
}

