/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.normalization;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public final class NormalizationPreprocessor<K, V>
implements Preprocessor<K, V>,
DeployableObject {
    private static final long serialVersionUID = 6873438115778921295L;
    private int p;
    private final Preprocessor<K, V> basePreprocessor;

    public NormalizationPreprocessor(int p, Preprocessor<K, V> basePreprocessor) {
        this.p = p;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public LabeledVector apply(K k, V v) {
        LabeledVector res = (LabeledVector)this.basePreprocessor.apply(k, v);
        double pNorm = Math.pow(this.foldMap((Vector)res.features(), Functions.PLUS, Functions.pow(this.p), 0.0), 1.0 / (double)this.p);
        if (pNorm == 0.0) {
            pNorm = 1.0;
        }
        for (int i = 0; i < res.size(); ++i) {
            res.set(i, res.get(i) / pNorm);
        }
        return res;
    }

    private double foldMap(Vector vec, IgniteBiFunction<Double, Double, Double> foldFun, IgniteDoubleFunction<Double> mapFun, double zero) {
        for (int i = 0; i < vec.size(); ++i) {
            zero = (Double)foldFun.apply(zero, (Double)mapFun.apply(vec.get(i)));
        }
        return zero;
    }

    public double p() {
        return this.p;
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.singletonList(this.basePreprocessor);
    }
}

