/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.List;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.node.VisorNodePingTaskArg;
import org.apache.ignite.internal.visor.node.VisorNodePingTaskResult;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class VisorNodePingTask
extends VisorOneNodeTask<VisorNodePingTaskArg, VisorNodePingTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorNodePingJob job(VisorNodePingTaskArg arg) {
        return new VisorNodePingJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected VisorNodePingTaskResult reduce0(List<ComputeJobResult> results) {
        try {
            return (VisorNodePingTaskResult)super.reduce0(results);
        }
        catch (ClusterTopologyException ignored) {
            return new VisorNodePingTaskResult(false, -1L, -1L);
        }
    }

    private static class VisorNodePingJob
    extends VisorJob<VisorNodePingTaskArg, VisorNodePingTaskResult> {
        private static final long serialVersionUID = 0L;

        protected VisorNodePingJob(VisorNodePingTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorNodePingTaskResult run(VisorNodePingTaskArg arg) {
            long start = System.currentTimeMillis();
            return new VisorNodePingTaskResult(this.ignite.cluster().pingNode(arg.getNodeId()), start, System.currentTimeMillis());
        }

        public String toString() {
            return S.toString(VisorNodePingJob.class, this);
        }
    }
}

