/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObjectInput;
import org.apache.ignite.internal.visor.VisorDataTransferObjectOutput;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class VisorGridDiscoveryEvent
extends VisorGridEvent {
    private static final long serialVersionUID = 0L;
    private UUID evtNodeId;
    private String addr;
    private boolean isDaemon;
    private long topVer;

    public VisorGridDiscoveryEvent() {
    }

    public VisorGridDiscoveryEvent(int typeId, IgniteUuid id, String name, UUID nid, long ts, @Nullable String msg, String shortDisplay, UUID evtNodeId, String addr, boolean isDaemon, long topVer) {
        super(typeId, id, name, nid, ts, msg, shortDisplay);
        this.evtNodeId = evtNodeId;
        this.addr = addr;
        this.isDaemon = isDaemon;
        this.topVer = topVer;
    }

    public UUID getEventNodeId() {
        return this.evtNodeId;
    }

    public String getAddress() {
        return this.addr;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public long getTopologyVersion() {
        return this.topVer;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        try (VisorDataTransferObjectOutput dtout = new VisorDataTransferObjectOutput(out);){
            dtout.writeByte(super.getProtocolVersion());
            super.writeExternalData(dtout);
        }
        U.writeUuid(out, this.evtNodeId);
        U.writeString(out, this.addr);
        out.writeBoolean(this.isDaemon);
        out.writeLong(this.topVer);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        try (VisorDataTransferObjectInput dtin = new VisorDataTransferObjectInput(in);){
            super.readExternalData(dtin.readByte(), dtin);
        }
        this.evtNodeId = U.readUuid(in);
        this.addr = U.readString(in);
        this.isDaemon = in.readBoolean();
        this.topVer = in.readLong();
    }

    @Override
    public String toString() {
        return S.toString(VisorGridDiscoveryEvent.class, this);
    }
}

