/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class PartitionKeyV2
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int grpId;
    private volatile String grpName;
    private int partId;

    public PartitionKeyV2(int grpId, int partId, String grpName) {
        this.grpId = grpId;
        this.partId = partId;
        this.grpName = grpName;
    }

    public PartitionKeyV2() {
    }

    public int groupId() {
        return this.grpId;
    }

    public int partitionId() {
        return this.partId;
    }

    public String groupName() {
        return this.grpName;
    }

    public void groupName(String grpName) {
        this.grpName = grpName;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.grpId);
        U.writeString(out, this.grpName);
        out.writeInt(this.partId);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.grpId = in.readInt();
        this.grpName = U.readString(in);
        this.partId = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionKeyV2 key = (PartitionKeyV2)o;
        return this.grpId == key.grpId && this.partId == key.partId;
    }

    public int hashCode() {
        int res = this.grpId;
        res = 31 * res + this.partId;
        return res;
    }

    public String toString() {
        return S.toString(PartitionKeyV2.class, this);
    }
}

