/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.jdbc;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCacheQueryJdbcTask
extends ComputeTaskAdapter<byte[], byte[]> {
    private static final long serialVersionUID = 0L;
    private static final Marshaller MARSHALLER = new JdkMarshaller();
    private static final int RMV_DELAY = 600000;
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    @IgniteInstanceResource
    private Ignite ignite;

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, byte[] arg) {
        try {
            assert (arg != null);
            Map args = (Map)U.unmarshal(MARSHALLER, arg, null);
            boolean first = true;
            UUID nodeId = (UUID)args.remove("confNodeId");
            if (nodeId == null) {
                nodeId = (UUID)args.remove("nodeId");
                boolean bl = first = nodeId == null;
            }
            if (nodeId != null) {
                for (ClusterNode n : subgrid) {
                    if (!n.id().equals(nodeId)) continue;
                    return F.asMap(new JdbcDriverJob(args, first), n);
                }
                throw new IgniteException("Node doesn't exist or left the grid: " + nodeId);
            }
            String cache = (String)args.get("cache");
            Map<? extends ComputeJob, ClusterNode> node = null;
            if (cache == null) {
                boolean start = this.ignite.configuration().isClientMode();
                IgniteCacheProxy<?, ?> cache0 = ((IgniteKernal)this.ignite).context().cache().getOrStartPublicCache(start, false);
                if (cache0 != null) {
                    node = this.mapToNode(subgrid, args, first, cache0.getName());
                }
            } else {
                node = this.mapToNode(subgrid, args, first, cache);
            }
            if (node != null) {
                return node;
            }
            throw new IgniteException("Can't find node with cache: " + cache);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Nullable
    private Map<? extends ComputeJob, ClusterNode> mapToNode(List<ClusterNode> subgrid, Map<String, Object> args, boolean first, String cache) {
        GridDiscoveryManager discoMgr = ((IgniteKernal)this.ignite).context().discovery();
        for (ClusterNode n : subgrid) {
            if (!discoMgr.cacheAffinityNode(n, cache)) continue;
            args.put("cache", cache);
            return F.asMap(new JdbcDriverJob(args, first), n);
        }
        return null;
    }

    @Override
    public byte[] reduce(List<ComputeJobResult> results) throws IgniteException {
        try {
            byte[] bytes;
            byte status;
            ComputeJobResult res = F.first(results);
            if (res.getException() == null) {
                status = 0;
                bytes = U.marshal(MARSHALLER, res.getData());
            } else {
                status = 1;
                bytes = U.marshal(MARSHALLER, (Object)new SQLException(res.getException().getMessage()));
            }
            byte[] packet = new byte[bytes.length + 1];
            packet[0] = status;
            U.arrayCopy(bytes, 0, packet, 1, bytes.length);
            return packet;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        return ComputeJobResultPolicy.WAIT;
    }

    private static final class Cursor
    implements Iterable<List<?>> {
        final QueryCursor<List<?>> cursor;
        final Iterator<List<?>> iter;
        final int totalCnt;
        final long lastAccessTime;

        private Cursor(QueryCursor<List<?>> cursor, Iterator<List<?>> iter, int totalCnt, long lastAccessTime) {
            this.cursor = cursor;
            this.iter = iter;
            this.totalCnt = totalCnt;
            this.lastAccessTime = lastAccessTime;
        }

        @Override
        public Iterator<List<?>> iterator() {
            return this.iter;
        }
    }

    private static class JdbcDriverJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        private final Map<String, Object> args;
        private final boolean first;
        @IgniteInstanceResource
        private Ignite ignite;
        @LoggerResource
        private IgniteLogger log;

        JdbcDriverJob(Map<String, Object> args, boolean first) {
            assert (args != null);
            assert (args.size() == (first ? 6 : 3));
            this.args = args;
            this.first = first;
        }

        @Override
        public Object execute() {
            String cacheName = (String)this.argument("cache");
            String sql = (String)this.argument("sql");
            Long timeout = (Long)this.argument("timeout");
            List args = (List)this.argument("args");
            UUID futId = (UUID)this.argument("futId");
            int pageSize = (Integer)this.argument("pageSize");
            int maxRows = (Integer)this.argument("maxRows");
            assert (maxRows >= 0) : maxRows;
            Cursor c = null;
            ArrayList<String> tbls = null;
            ArrayList<String> cols = null;
            ArrayList<String> types = null;
            if (this.first) {
                assert (sql != null);
                assert (timeout != null);
                assert (args != null);
                assert (futId == null);
                IgniteCache cache = this.ignite.cache(cacheName);
                if (cache == null && cacheName == null) {
                    try {
                        boolean start = this.ignite.configuration().isClientMode();
                        cache = ((IgniteKernal)this.ignite).context().cache().getOrStartPublicCache(start, false);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                }
                if (cache == null) {
                    throw new IgniteException(new SQLException("Cache not found [cacheName=" + cacheName + ']'));
                }
                SqlFieldsQuery qry = new SqlFieldsQuery(sql).setArgs(args.toArray());
                qry.setPageSize(pageSize);
                FieldsQueryCursor<List<?>> cursor = cache.withKeepBinary().query(qry);
                List<GridQueryFieldMetadata> meta = ((QueryCursorImpl)cursor).fieldsMeta();
                assert (meta != null);
                tbls = new ArrayList<String>(meta.size());
                cols = new ArrayList<String>(meta.size());
                types = new ArrayList<String>(meta.size());
                for (GridQueryFieldMetadata desc : meta) {
                    tbls.add(desc.typeName());
                    cols.add(desc.fieldName().toUpperCase());
                    types.add(desc.fieldTypeName());
                }
                futId = UUID.randomUUID();
                c = new Cursor(cursor, cursor.iterator(), 0, U.currentTimeMillis());
            }
            assert (futId != null);
            ConcurrentMap<UUID, Cursor> m = this.ignite.cluster().nodeLocalMap();
            if (c == null) {
                c = (Cursor)m.get(futId);
            }
            if (c == null) {
                throw new IgniteException("Cursor was removed due to long inactivity.");
            }
            ArrayList rows = new ArrayList();
            int totalCnt = c.totalCnt;
            boolean finished = true;
            for (List<?> row : c) {
                ArrayList row0 = new ArrayList(row.size());
                for (Object val : row) {
                    row0.add(JdbcDriverJob.sqlType(val) ? val : val.toString());
                }
                rows.add(row0);
                if (++totalCnt == maxRows) break;
                if (rows.size() != pageSize) continue;
                finished = false;
                break;
            }
            if (!finished) {
                if (this.first) {
                    m.put(futId, c);
                    this.scheduleRemoval(futId, 600000L);
                } else if (!m.replace(futId, c, new Cursor(c.cursor, c.iter, totalCnt, U.currentTimeMillis()))) assert (!m.containsKey(futId)) : "Concurrent cursor modification.";
            } else if (this.first) {
                c.cursor.close();
            } else {
                this.remove(futId, c);
            }
            return this.first ? F.asList(new Object[]{this.ignite.cluster().localNode().id(), futId, tbls, cols, types, rows, finished}) : F.asList(new Object[]{rows, finished});
        }

        private boolean remove(UUID futId, Cursor c) {
            if (this.ignite.cluster().nodeLocalMap().remove(futId, c)) {
                c.cursor.close();
                return true;
            }
            return false;
        }

        private void scheduleRemoval(final UUID id, long delay) {
            SCHEDULER.schedule(new CAX(){

                @Override
                public void applyx() {
                    Cursor c;
                    while ((c = (Cursor)ignite.cluster().nodeLocalMap().get(id)) != null) {
                        long untouchedTime = U.currentTimeMillis() - c.lastAccessTime;
                        if (untouchedTime < 600000L) {
                            this.scheduleRemoval(id, 600000L - untouchedTime);
                            break;
                        }
                        if (!this.remove(id, c)) continue;
                        break;
                    }
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private static boolean sqlType(Object obj) {
            return obj == null || obj instanceof BigDecimal || obj instanceof Boolean || obj instanceof Byte || obj instanceof byte[] || obj instanceof Date || obj instanceof Double || obj instanceof Float || obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof String || obj instanceof URL;
        }

        private <T> T argument(String key) {
            return (T)this.args.get(key);
        }
    }
}

