/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageBPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastoragePageIOUtils;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRowStore;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;

public class MetastorageLeafIO
extends BPlusLeafIO<MetastorageRow>
implements MetastorageBPlusIO {
    MetastorageLeafIO(int ver) {
        super(23, ver, 74);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, MetastorageRow row) {
        MetastorageLeafIO.setVersion(pageAddr, 2);
        MetastoragePageIOUtils.storeByOffset(this, pageAddr, off, row);
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BPlusIO<MetastorageRow> srcIo, long srcPageAddr, int srcIdx) {
        MetastorageLeafIO.setVersion(dstPageAddr, 2);
        MetastoragePageIOUtils.store(this, dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
    }

    @Override
    public MetastorageRow getLookupRow(BPlusTree<MetastorageRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        assert (tree instanceof MetastorageTree);
        return this.getDataRow(pageAddr, idx, ((MetastorageTree)tree).rowStore());
    }

    @Override
    public long getLink(long pageAddr, int idx) {
        return MetastoragePageIOUtils.getLink(this, pageAddr, idx);
    }

    @Override
    public short getKeySize(long pageAddr, int idx) {
        return MetastoragePageIOUtils.getKeySize(this, pageAddr, idx);
    }

    @Override
    public String getKey(long pageAddr, int idx, MetastorageRowStore rowStore) throws IgniteCheckedException {
        return MetastoragePageIOUtils.getKey(this, pageAddr, idx, rowStore);
    }

    @Override
    public MetastorageDataRow getDataRow(long pageAddr, int idx, MetastorageRowStore rowStore) throws IgniteCheckedException {
        return MetastoragePageIOUtils.getDataRow(this, pageAddr, idx, rowStore);
    }
}

