/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.freelist;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.freelist.AbstractFreeList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheFreeList
extends AbstractFreeList<CacheDataRow> {
    public CacheFreeList(int cacheGrpId, String name, DataRegion dataRegion, IgniteWriteAheadLogManager wal, long metaPageId, boolean initNew, PageLockListener lockLsnr, GridKernalContext ctx, AtomicLong pageListCacheLimit, byte pageFlag) throws IgniteCheckedException {
        super(cacheGrpId, name, dataRegion, null, wal, metaPageId, initNew, lockLsnr, ctx, pageListCacheLimit, pageFlag);
    }

    @Override
    public void insertDataRow(CacheDataRow row, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        super.insertDataRow(row, statHolder);
        assert (row.key().partition() == PageIdUtils.partId(row.link())) : "Constructed a link with invalid partition ID [partId=" + row.key().partition() + ", link=" + U.hexLong(row.link()) + ']';
    }

    @Override
    public String toString() {
        return "FreeList [name=" + this.name + ']';
    }
}

