/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupEmptyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridDistributedCacheAdapter<K, V>
extends GridCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;

    protected GridDistributedCacheAdapter() {
    }

    protected GridDistributedCacheAdapter(GridCacheContext<K, V> ctx) {
        super(ctx);
    }

    protected GridDistributedCacheAdapter(GridCacheContext<K, V> ctx, GridCacheConcurrentMap map) {
        super(ctx, map);
    }

    @Override
    public IgniteInternalFuture<Boolean> txLockAsync(Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx tx, boolean isRead, boolean retval, TransactionIsolation isolation, boolean isInvalidate, long createTtl, long accessTtl) {
        assert (tx != null);
        return this.lockAllAsync(keys, timeout, tx, isInvalidate, isRead, retval, isolation, createTtl, accessTtl);
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(Collection<? extends K> keys, long timeout) {
        GridNearTxLocal tx = this.ctx.tm().userTx();
        return this.lockAllAsync(this.ctx.cacheKeysView(keys), timeout, tx, false, false, true, null, -1L, -1L);
    }

    protected abstract IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> var1, long var2, @Nullable IgniteTxLocalEx var4, boolean var5, boolean var6, boolean var7, @Nullable TransactionIsolation var8, long var9, long var11);

    public void removeVersionedEntry(KeyCacheObject key, GridCacheVersion ver) {
        GridCacheEntryEx entry = this.peekEx(key);
        if (entry == null) {
            return;
        }
        if (entry.markObsoleteVersion(ver)) {
            this.removeEntry(entry);
        }
    }

    @Override
    public void removeAll() throws IgniteCheckedException {
        block3: {
            try {
                boolean retry;
                AffinityTopologyVersion topVer;
                CacheOperationContext opCtx = this.ctx.operationContextPerCall();
                boolean skipStore = opCtx != null && opCtx.skipStore();
                boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
                do {
                    retry = false;
                    topVer = this.ctx.affinity().affinityTopologyVersion();
                    Collection<ClusterNode> nodes = this.ctx.grid().cluster().forDataNodes(this.name()).nodes();
                    if (nodes.isEmpty()) continue;
                    this.ctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
                    boolean bl = retry = (Boolean)this.ctx.kernalContext().task().execute(new RemoveAllTask(this.ctx.name(), topVer, skipStore, keepBinary), null).get() == false;
                } while (this.ctx.affinity().affinityTopologyVersion().compareTo(topVer) != 0 || retry);
            }
            catch (ClusterGroupEmptyCheckedException ignore) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("All remote nodes left while cache remove [cacheName=" + this.name() + "]");
            }
        }
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        GridFutureAdapter<Void> opFut = new GridFutureAdapter<Void>();
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        this.removeAllAsync(opFut, topVer, opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary());
        return opFut;
    }

    private void removeAllAsync(final GridFutureAdapter<Void> opFut, final AffinityTopologyVersion topVer, final boolean skipStore, final boolean keepBinary) {
        Collection<ClusterNode> nodes = this.ctx.grid().cluster().forDataNodes(this.name()).nodes();
        if (!nodes.isEmpty()) {
            this.ctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture<Boolean> rmvAll = this.ctx.kernalContext().task().execute(new RemoveAllTask(this.ctx.name(), topVer, skipStore, keepBinary), null);
            rmvAll.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                @Override
                public void apply(IgniteInternalFuture<Boolean> fut) {
                    try {
                        boolean retry = fut.get() == false;
                        AffinityTopologyVersion topVer0 = GridDistributedCacheAdapter.this.ctx.affinity().affinityTopologyVersion();
                        if (topVer0.equals(topVer) && !retry) {
                            opFut.onDone();
                        } else {
                            GridDistributedCacheAdapter.this.removeAllAsync(opFut, topVer0, skipStore, keepBinary);
                        }
                    }
                    catch (ClusterGroupEmptyCheckedException ignore) {
                        if (GridDistributedCacheAdapter.this.log.isDebugEnabled()) {
                            GridDistributedCacheAdapter.this.log.debug("All remote nodes left while cache remove [cacheName=" + GridDistributedCacheAdapter.this.name() + "]");
                        }
                        opFut.onDone();
                    }
                    catch (IgniteCheckedException e) {
                        opFut.onDone(e);
                    }
                    catch (Error e) {
                        opFut.onDone(e);
                        throw e;
                    }
                }
            });
        } else {
            opFut.onDone();
        }
    }

    @Override
    public long localSizeLong(CachePeekMode[] peekModes) throws IgniteCheckedException {
        GridCacheAdapter.PeekModes modes = GridDistributedCacheAdapter.parsePeekModes(peekModes, true);
        long size = 0L;
        if (modes.near) {
            size += (long)this.nearSize();
        }
        if (modes.primary || modes.backup) {
            AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
            IgniteCacheOffheapManager offheap = this.ctx.offheap();
            if (modes.offheap) {
                size += offheap.cacheEntriesCount(this.ctx.cacheId(), modes.primary, modes.backup, topVer);
            } else if (modes.heap) {
                for (GridDhtLocalPartition locPart : this.ctx.topology().currentLocalPartitions()) {
                    if ((!modes.primary || !locPart.primary(topVer)) && (!modes.backup || !locPart.backup(topVer))) continue;
                    size += (long)locPart.publicSize(this.ctx.cacheId());
                }
            }
        }
        return size;
    }

    @Override
    public long localSizeLong(int part, CachePeekMode[] peekModes) throws IgniteCheckedException {
        GridCacheAdapter.PeekModes modes = GridDistributedCacheAdapter.parsePeekModes(peekModes, true);
        long size = 0L;
        if (modes.near) {
            size += (long)this.nearSize();
        }
        if (modes.offheap) {
            AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
            IgniteCacheOffheapManager offheap = this.ctx.offheap();
            if (this.ctx.affinity().primaryByPartition(this.ctx.localNode(), part, topVer) && modes.primary || this.ctx.affinity().backupByPartition(this.ctx.localNode(), part, topVer) && modes.backup) {
                size += offheap.cacheEntriesCount(this.ctx.cacheId(), part);
            }
        }
        return size;
    }

    @Override
    public String toString() {
        return S.toString(GridDistributedCacheAdapter.class, this, "super", (Object)super.toString());
    }

    @GridInternal
    public static class GlobalRemoveAllJob<K, V>
    extends GridCacheAdapter.TopologyVersionAwareJob {
        private static final long serialVersionUID = 0L;
        private final boolean skipStore;
        private final boolean keepBinary;
        private transient GridFutureAdapter<Boolean> locFut;

        private GlobalRemoveAllJob(String cacheName, @NotNull AffinityTopologyVersion topVer, boolean skipStore, boolean keepBinary) {
            super(cacheName, topVer);
            this.skipStore = skipStore;
            this.keepBinary = keepBinary;
        }

        /*
         * Exception decompiling
         */
        @Override
        @Nullable
        public Object localExecute(@Nullable IgniteInternalCache cache0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 34[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean completeWithResult(boolean b) {
            this.locFut.onDone(b);
            return b;
        }

        private /* synthetic */ void lambda$localExecute$18f4acd3$1(IgniteInternalFuture lastFut, IgniteInternalFuture fut) {
            if (lastFut.error() != null) {
                this.locFut.onDone(lastFut.error());
            } else {
                try {
                    this.completeWithResult((Boolean)fut.get());
                }
                catch (IgniteCheckedException igniteCheckedException) {
                    // empty catch block
                }
            }
            this.jobCtx.callcc();
        }
    }

    @GridInternal
    private static class RemoveAllTask
    extends ComputeTaskAdapter<Object, Boolean> {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        private final AffinityTopologyVersion topVer;
        private final boolean skipStore;
        private final boolean keepBinary;

        public RemoveAllTask(String cacheName, AffinityTopologyVersion topVer, boolean skipStore, boolean keepBinary) {
            this.cacheName = cacheName;
            this.topVer = topVer;
            this.skipStore = skipStore;
            this.keepBinary = keepBinary;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) throws IgniteException {
            HashMap jobs = new HashMap();
            for (ClusterNode node : subgrid) {
                jobs.put(new GlobalRemoveAllJob(this.cacheName, this.topVer, this.skipStore, this.keepBinary), node);
            }
            return jobs;
        }

        @Override
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
            IgniteException e = res.getException();
            if (e != null) {
                if (e instanceof ClusterTopologyException) {
                    return ComputeJobResultPolicy.WAIT;
                }
                throw new IgniteException("Remote job threw exception.", e);
            }
            return ComputeJobResultPolicy.WAIT;
        }

        @Override
        @Nullable
        public Boolean reduce(List<ComputeJobResult> results) throws IgniteException {
            for (ComputeJobResult locRes : results) {
                if (locRes == null || locRes.getException() == null && ((Boolean)locRes.getData()).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }
}

