/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.UUID;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.BaselineTopologyHistoryItem;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class StateChangeRequest {
    private final ChangeGlobalStateMessage msg;
    private final BaselineTopologyHistoryItem prevBltHistItem;
    private ClusterState prevState;
    private final AffinityTopologyVersion topVer;

    public StateChangeRequest(ChangeGlobalStateMessage msg, BaselineTopologyHistoryItem bltHistItem, ClusterState prevState, AffinityTopologyVersion topVer) {
        this.msg = msg;
        this.prevBltHistItem = bltHistItem;
        this.prevState = prevState;
        this.topVer = topVer;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public IgniteUuid id() {
        return this.msg.id();
    }

    public UUID requestId() {
        return this.msg.requestId();
    }

    @Deprecated
    public boolean activate() {
        return this.msg.activate();
    }

    public ClusterState state() {
        return this.msg.state();
    }

    public ClusterState prevState() {
        return this.prevState;
    }

    public boolean activeChanged() {
        return this.prevState.active() != this.msg.state().active();
    }

    @Nullable
    public BaselineTopologyHistoryItem prevBaselineTopologyHistoryItem() {
        return this.prevBltHistItem;
    }

    @Nullable
    public BaselineTopology baselineTopology() {
        return this.msg.baselineTopology();
    }

    public UUID initiatorNodeId() {
        return this.msg.initiatorNodeId();
    }

    public String toString() {
        return S.toString(StateChangeRequest.class, this);
    }
}

