/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.store.GridCacheWriteBehindStore;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.LongGauge;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.collection.ImmutableIntSet;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheMetricsImpl
implements CacheMetrics {
    private static final int REBALANCE_RATE_INTERVAL = IgniteSystemProperties.getInteger("IGNITE_REBALANCE_STATISTICS_TIME_INTERVAL", 60000);
    private static final CachePeekMode[] ONHEAP_PEEK_MODES = new CachePeekMode[]{CachePeekMode.ONHEAP, CachePeekMode.PRIMARY, CachePeekMode.BACKUP, CachePeekMode.NEAR};
    private static final long NANOS_IN_MICROSECOND = 1000L;
    public static final String CACHE_METRICS = "cache";
    public static final long[] HISTOGRAM_BUCKETS = new long[]{TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS.convert(250L, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS.convert(1000L, TimeUnit.MILLISECONDS)};
    private final AtomicLongMetric reads;
    private final AtomicLongMetric entryProcessorPuts;
    private final AtomicLongMetric entryProcessorRemovals;
    private final AtomicLongMetric entryProcessorReadOnlyInvocations;
    private final AtomicLongMetric entryProcessorInvokeTimeNanos;
    private final AtomicLongMetric entryProcessorMinInvocationTime;
    private final AtomicLongMetric entryProcessorMaxInvocationTime;
    private final AtomicLongMetric entryProcessorHits;
    private final AtomicLongMetric entryProcessorMisses;
    private final AtomicLongMetric writes;
    private final AtomicLongMetric hits;
    private final AtomicLongMetric misses;
    private final AtomicLongMetric txCommits;
    private final AtomicLongMetric txRollbacks;
    private final AtomicLongMetric evictCnt;
    private final AtomicLongMetric rmCnt;
    private final AtomicLongMetric putTimeTotal;
    private final AtomicLongMetric getTimeTotal;
    private final AtomicLongMetric rmvTimeTotal;
    private final AtomicLongMetric commitTimeTotal;
    private final AtomicLongMetric rollbackTimeTotal;
    private final AtomicLongMetric offHeapGets;
    private final AtomicLongMetric offHeapPuts;
    private final AtomicLongMetric offHeapRemoves;
    private final AtomicLongMetric offHeapEvicts;
    private final AtomicLongMetric offHeapHits;
    private final AtomicLongMetric offHeapMisses;
    private final AtomicLongMetric rebalancedKeys;
    private final AtomicLongMetric totalRebalancedBytes;
    private final AtomicLongMetric rebalanceStartTime;
    private final AtomicLongMetric estimatedRebalancingKeys;
    private final HitRateMetric rebalancingKeysRate;
    private final HitRateMetric rebalancingBytesRate;
    private final AtomicLongMetric rebalanceClearingPartitions;
    private final AtomicLongMetric evictingPartitions;
    private final HistogramMetricImpl getTime;
    private final HistogramMetricImpl putTime;
    private final HistogramMetricImpl rmvTime;
    private final HistogramMetricImpl commitTime;
    private final HistogramMetricImpl rollbackTime;
    @GridToStringExclude
    private transient CacheMetricsImpl delegate;
    private GridCacheContext<?, ?> cctx;
    private GridCacheContext<?, ?> dhtCtx;
    private GridCacheWriteBehindStore store;
    private volatile Supplier<List<Map.Entry<GridCacheMapEntry, Integer>>> txKeyCollisionInfo;
    private final LongGauge offHeapEntriesCnt;
    private final LongGauge offHeapPrimaryEntriesCnt;
    private final LongGauge offHeapBackupEntriesCnt;
    private final LongGauge heapEntriesCnt;
    private final LongGauge cacheSize;
    private final LongAdderMetric idxRebuildKeyProcessed;

    public CacheMetricsImpl(GridCacheContext<?, ?> cctx) {
        this(cctx, false);
    }

    public CacheMetricsImpl(GridCacheContext<?, ?> cctx, boolean isNear) {
        assert (cctx != null);
        this.cctx = cctx;
        if (cctx.isNear()) {
            this.dhtCtx = cctx.near().dht().context();
        }
        if (cctx.store().store() instanceof GridCacheWriteBehindStore) {
            this.store = (GridCacheWriteBehindStore)cctx.store().store();
        }
        this.delegate = null;
        MetricRegistry mreg = cctx.kernalContext().metric().registry(MetricUtils.cacheMetricsRegistryName(cctx.name(), isNear));
        this.reads = mreg.longMetric("CacheGets", "The total number of gets to the cache.");
        this.entryProcessorPuts = mreg.longMetric("EntryProcessorPuts", "The total number of cache invocations, caused update.");
        this.entryProcessorRemovals = mreg.longMetric("EntryProcessorRemovals", "The total number of cache invocations, caused removals.");
        this.entryProcessorReadOnlyInvocations = mreg.longMetric("EntryProcessorReadOnlyInvocations", "The total number of cache invocations, caused no updates.");
        this.entryProcessorInvokeTimeNanos = mreg.longMetric("EntryProcessorInvokeTimeNanos", "The total time of cache invocations, in nanoseconds.");
        this.entryProcessorMinInvocationTime = mreg.longMetric("EntryProcessorMinInvocationTime", "So far, the minimum time to execute cache invokes.");
        this.entryProcessorMaxInvocationTime = mreg.longMetric("EntryProcessorMaxInvocationTime", "So far, the maximum time to execute cache invokes.");
        this.entryProcessorHits = mreg.longMetric("EntryProcessorHits", "The total number of invocations on keys, which exist in cache.");
        this.entryProcessorMisses = mreg.longMetric("EntryProcessorMisses", "The total number of invocations on keys, which don't exist in cache.");
        this.writes = mreg.longMetric("CachePuts", "The total number of puts to the cache.");
        this.hits = mreg.longMetric("CacheHits", "The number of get requests that were satisfied by the cache.");
        this.misses = mreg.longMetric("CacheMisses", "A miss is a get request that is not satisfied.");
        this.txCommits = mreg.longMetric("CacheTxCommits", "Total number of transaction commits.");
        this.txRollbacks = mreg.longMetric("CacheTxRollbacks", "Total number of transaction rollbacks.");
        this.evictCnt = mreg.longMetric("CacheEvictions", "The total number of evictions from the cache.");
        this.rmCnt = mreg.longMetric("CacheRemovals", "The total number of removals from the cache.");
        this.putTimeTotal = mreg.longMetric("PutTimeTotal", "The total time of cache puts, in nanoseconds.");
        this.getTimeTotal = mreg.longMetric("GetTimeTotal", "The total time of cache gets, in nanoseconds.");
        this.rmvTimeTotal = mreg.longMetric("RemoveTimeTotal", "The total time of cache removal, in nanoseconds.");
        this.commitTimeTotal = mreg.longMetric("CommitTimeTotal", "The total time of commit, in nanoseconds.");
        this.rollbackTimeTotal = mreg.longMetric("RollbackTimeTotal", "The total time of rollback, in nanoseconds.");
        this.offHeapGets = mreg.longMetric("OffHeapGets", "The total number of get requests to the off-heap memory.");
        this.offHeapPuts = mreg.longMetric("OffHeapPuts", "The total number of put requests to the off-heap memory.");
        this.offHeapRemoves = mreg.longMetric("OffHeapRemovals", "The total number of removals from the off-heap memory.");
        this.offHeapEvicts = mreg.longMetric("OffHeapEvictions", "The total number of evictions from the off-heap memory.");
        this.offHeapHits = mreg.longMetric("OffHeapHits", "The number of get requests that were satisfied by the off-heap memory.");
        this.offHeapMisses = mreg.longMetric("OffHeapMisses", "A miss is a get request that is not satisfied by off-heap memory.");
        this.rebalancedKeys = mreg.longMetric("RebalancedKeys", "Number of already rebalanced keys.");
        this.totalRebalancedBytes = mreg.longMetric("TotalRebalancedBytes", "Number of already rebalanced bytes.");
        this.rebalanceStartTime = mreg.longMetric("RebalanceStartTime", "Rebalance start time");
        this.rebalanceStartTime.value(-1L);
        this.estimatedRebalancingKeys = mreg.longMetric("EstimatedRebalancingKeys", "Number estimated to rebalance keys.");
        this.rebalancingKeysRate = mreg.hitRateMetric("RebalancingKeysRate", "Estimated rebalancing speed in keys", REBALANCE_RATE_INTERVAL, 20);
        this.rebalancingBytesRate = mreg.hitRateMetric("RebalancingBytesRate", "Estimated rebalancing speed in bytes", REBALANCE_RATE_INTERVAL, 20);
        this.rebalanceClearingPartitions = mreg.longMetric("RebalanceClearingPartitionsLeft", "The number of partitions need to be cleared before actual rebalance start.");
        this.evictingPartitions = mreg.longMetric("EvictingPartitionsLeft", "The number of non-affinity partitions scheduled for eviction.");
        mreg.register("IsIndexRebuildInProgress", this::isIndexRebuildInProgress, "True if index rebuild is in progress.");
        this.getTime = mreg.histogram("GetTime", HISTOGRAM_BUCKETS, "Get time in nanoseconds.");
        this.putTime = mreg.histogram("PutTime", HISTOGRAM_BUCKETS, "Put time in nanoseconds.");
        this.rmvTime = mreg.histogram("RemoveTime", HISTOGRAM_BUCKETS, "Remove time in nanoseconds.");
        this.commitTime = mreg.histogram("CommitTime", HISTOGRAM_BUCKETS, "Commit time in nanoseconds.");
        this.rollbackTime = mreg.histogram("RollbackTime", HISTOGRAM_BUCKETS, "Rollback time in nanoseconds.");
        mreg.register("TxKeyCollisions", this::getTxKeyCollisions, String.class, "Tx key collisions. Show keys and collisions queue size. Due transactional payload some keys become hot. Metric shows corresponding keys.");
        this.offHeapEntriesCnt = mreg.register("OffHeapEntriesCount", () -> this.getEntriesStat().offHeapEntriesCount(), "Offheap entries count.");
        this.offHeapPrimaryEntriesCnt = mreg.register("OffHeapPrimaryEntriesCount", () -> this.getEntriesStat().offHeapPrimaryEntriesCount(), "Offheap primary entries count.");
        this.offHeapBackupEntriesCnt = mreg.register("OffHeapBackupEntriesCount", () -> this.getEntriesStat().offHeapBackupEntriesCount(), "Offheap backup entries count.");
        this.heapEntriesCnt = mreg.register("HeapEntriesCount", () -> this.getEntriesStat().heapEntriesCount(), "Onheap entries count.");
        this.cacheSize = mreg.register("CacheSize", () -> this.getEntriesStat().cacheSize(), "Local cache size.");
        this.idxRebuildKeyProcessed = mreg.longAdderMetric("IndexRebuildKeyProcessed", "Number of keys processed during the index rebuilding.");
    }

    public void delegate(CacheMetricsImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public String name() {
        return this.cctx.name();
    }

    @Override
    public long getOffHeapGets() {
        return this.offHeapGets.value();
    }

    @Override
    public long getOffHeapPuts() {
        return this.offHeapPuts.value();
    }

    @Override
    public long getOffHeapRemovals() {
        return this.offHeapRemoves.value();
    }

    @Override
    public long getOffHeapEvictions() {
        return this.offHeapEvicts.value();
    }

    @Override
    public long getOffHeapHits() {
        return this.offHeapHits.value();
    }

    @Override
    public float getOffHeapHitPercentage() {
        long hits0 = this.offHeapHits.value();
        long gets0 = this.offHeapGets.value();
        if (hits0 == 0L) {
            return 0.0f;
        }
        return (float)hits0 / (float)gets0 * 100.0f;
    }

    @Override
    public long getOffHeapMisses() {
        return this.offHeapMisses.value();
    }

    @Override
    public float getOffHeapMissPercentage() {
        long misses0 = this.offHeapMisses.value();
        long reads0 = this.offHeapGets.value();
        if (misses0 == 0L) {
            return 0.0f;
        }
        return (float)misses0 / (float)reads0 * 100.0f;
    }

    @Override
    public long getOffHeapEntriesCount() {
        return this.offHeapEntriesCnt.value();
    }

    @Override
    public long getHeapEntriesCount() {
        return this.heapEntriesCnt.value();
    }

    @Override
    public long getOffHeapPrimaryEntriesCount() {
        return this.offHeapPrimaryEntriesCnt.value();
    }

    @Override
    public long getOffHeapBackupEntriesCount() {
        return this.offHeapBackupEntriesCnt.value();
    }

    @Override
    public long getOffHeapAllocatedSize() {
        GridCacheAdapter<?, ?> cache = this.cctx.cache();
        return cache != null ? cache.offHeapAllocatedSize() : -1L;
    }

    @Override
    public int getSize() {
        return this.getEntriesStat().size();
    }

    @Override
    public long getCacheSize() {
        return this.cacheSize.value();
    }

    @Override
    public int getKeySize() {
        return this.getEntriesStat().keySize();
    }

    @Override
    public boolean isEmpty() {
        return this.getEntriesStat().isEmpty();
    }

    @Override
    public int getDhtEvictQueueCurrentSize() {
        return -1;
    }

    @Override
    public int getTxCommitQueueSize() {
        return 0;
    }

    @Override
    public int getTxThreadMapSize() {
        return this.cctx.tm().threadMapSize();
    }

    @Override
    public int getTxXidMapSize() {
        return this.cctx.tm().idMapSize();
    }

    @Override
    public int getTxPrepareQueueSize() {
        return 0;
    }

    @Override
    public int getTxStartVersionCountsSize() {
        return 0;
    }

    @Override
    public int getTxCommittedVersionsSize() {
        return this.cctx.tm().completedVersionsSize();
    }

    @Override
    public int getTxRolledbackVersionsSize() {
        return this.cctx.tm().completedVersionsSize();
    }

    @Override
    public int getTxDhtThreadMapSize() {
        return this.cctx.tm().threadMapSize();
    }

    @Override
    public int getTxDhtXidMapSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().idMapSize() : -1;
    }

    @Override
    public int getTxDhtCommitQueueSize() {
        return 0;
    }

    @Override
    public int getTxDhtPrepareQueueSize() {
        return 0;
    }

    @Override
    public int getTxDhtStartVersionCountsSize() {
        return 0;
    }

    @Override
    public int getTxDhtCommittedVersionsSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().completedVersionsSize() : -1;
    }

    @Override
    public int getTxDhtRolledbackVersionsSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().completedVersionsSize() : -1;
    }

    @Override
    public boolean isWriteBehindEnabled() {
        return this.store != null;
    }

    @Override
    public int getWriteBehindFlushSize() {
        return this.store != null ? this.store.getWriteBehindFlushSize() : -1;
    }

    @Override
    public int getWriteBehindFlushThreadCount() {
        return this.store != null ? this.store.getWriteBehindFlushThreadCount() : -1;
    }

    @Override
    public long getWriteBehindFlushFrequency() {
        return this.store != null ? this.store.getWriteBehindFlushFrequency() : -1L;
    }

    @Override
    public int getWriteBehindStoreBatchSize() {
        return this.store != null ? this.store.getWriteBehindStoreBatchSize() : -1;
    }

    @Override
    public int getWriteBehindTotalCriticalOverflowCount() {
        return this.store != null ? this.store.getWriteBehindTotalCriticalOverflowCount() : -1;
    }

    @Override
    public int getWriteBehindCriticalOverflowCount() {
        return this.store != null ? this.store.getWriteBehindCriticalOverflowCount() : -1;
    }

    @Override
    public int getWriteBehindErrorRetryCount() {
        return this.store != null ? this.store.getWriteBehindErrorRetryCount() : -1;
    }

    @Override
    public int getWriteBehindBufferSize() {
        return this.store != null ? this.store.getWriteBehindBufferSize() : -1;
    }

    @Override
    public float getAverageTxCommitTime() {
        long timeNanos = this.commitTimeTotal.value();
        long commitsCnt = this.txCommits.value();
        if (timeNanos == 0L || commitsCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)commitsCnt / 1000.0f;
    }

    @Override
    public float getAverageTxRollbackTime() {
        long timeNanos = this.rollbackTimeTotal.value();
        long rollbacksCnt = this.txRollbacks.value();
        if (timeNanos == 0L || rollbacksCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)rollbacksCnt / 1000.0f;
    }

    @Override
    public long getCacheTxCommits() {
        return this.txCommits.value();
    }

    @Override
    public long getCacheTxRollbacks() {
        return this.txRollbacks.value();
    }

    public void clear() {
        this.reads.reset();
        this.writes.reset();
        this.rmCnt.reset();
        this.hits.reset();
        this.misses.reset();
        this.evictCnt.reset();
        this.txCommits.reset();
        this.txRollbacks.reset();
        this.putTimeTotal.reset();
        this.rmvTimeTotal.reset();
        this.getTimeTotal.reset();
        this.commitTimeTotal.reset();
        this.rollbackTimeTotal.reset();
        this.entryProcessorPuts.reset();
        this.entryProcessorRemovals.reset();
        this.entryProcessorReadOnlyInvocations.reset();
        this.entryProcessorMisses.reset();
        this.entryProcessorHits.reset();
        this.entryProcessorInvokeTimeNanos.reset();
        this.entryProcessorMaxInvocationTime.reset();
        this.entryProcessorMinInvocationTime.reset();
        this.offHeapGets.reset();
        this.offHeapPuts.reset();
        this.offHeapRemoves.reset();
        this.offHeapHits.reset();
        this.offHeapMisses.reset();
        this.offHeapEvicts.reset();
        this.getTime.reset();
        this.putTime.reset();
        this.rmvTime.reset();
        this.commitTime.reset();
        this.rollbackTime.reset();
        this.clearRebalanceCounters();
        if (this.delegate != null) {
            this.delegate.clear();
        }
        this.txKeyCollisionInfo = null;
        this.idxRebuildKeyProcessed.reset();
    }

    @Override
    public long getCacheHits() {
        return this.hits.value();
    }

    @Override
    public float getCacheHitPercentage() {
        long hits0 = this.hits.value();
        long gets0 = this.reads.value();
        if (hits0 == 0L) {
            return 0.0f;
        }
        return (float)hits0 / (float)gets0 * 100.0f;
    }

    @Override
    public long getCacheMisses() {
        return this.misses.value();
    }

    @Override
    public float getCacheMissPercentage() {
        long misses0 = this.misses.value();
        long reads0 = this.reads.value();
        if (misses0 == 0L) {
            return 0.0f;
        }
        return (float)misses0 / (float)reads0 * 100.0f;
    }

    @Override
    public long getCacheGets() {
        return this.reads.value();
    }

    @Override
    public long getCachePuts() {
        return this.writes.value();
    }

    @Override
    public long getEntryProcessorPuts() {
        return this.entryProcessorPuts.value();
    }

    @Override
    public long getEntryProcessorRemovals() {
        return this.entryProcessorRemovals.value();
    }

    @Override
    public long getEntryProcessorReadOnlyInvocations() {
        return this.entryProcessorReadOnlyInvocations.value();
    }

    @Override
    public long getEntryProcessorInvocations() {
        return this.entryProcessorReadOnlyInvocations.value() + this.entryProcessorPuts.value() + this.entryProcessorRemovals.value();
    }

    @Override
    public long getEntryProcessorHits() {
        return this.entryProcessorHits.value();
    }

    @Override
    public float getEntryProcessorHitPercentage() {
        long hits = this.entryProcessorHits.value();
        long totalInvocations = this.getEntryProcessorInvocations();
        if (hits == 0L) {
            return 0.0f;
        }
        return (float)hits / (float)totalInvocations * 100.0f;
    }

    @Override
    public long getEntryProcessorMisses() {
        return this.entryProcessorMisses.value();
    }

    @Override
    public float getEntryProcessorMissPercentage() {
        long misses = this.entryProcessorMisses.value();
        long totalInvocations = this.getEntryProcessorInvocations();
        if (misses == 0L) {
            return 0.0f;
        }
        return (float)misses / (float)totalInvocations * 100.0f;
    }

    @Override
    public float getEntryProcessorAverageInvocationTime() {
        long totalInvokes = this.getEntryProcessorInvocations();
        long timeNanos = this.entryProcessorInvokeTimeNanos.value();
        if (timeNanos == 0L || totalInvokes == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)totalInvokes / 1000.0f;
    }

    @Override
    public float getEntryProcessorMinInvocationTime() {
        return 1.0f * (float)this.entryProcessorMinInvocationTime.value() / 1000.0f;
    }

    @Override
    public float getEntryProcessorMaxInvocationTime() {
        return 1.0f * (float)this.entryProcessorMaxInvocationTime.value() / 1000.0f;
    }

    @Override
    public long getCacheRemovals() {
        return this.rmCnt.value();
    }

    @Override
    public long getCacheEvictions() {
        return this.evictCnt.value();
    }

    @Override
    public float getAverageGetTime() {
        long timeNanos = this.getTimeTotal.value();
        long readsCnt = this.reads.value();
        if (timeNanos == 0L || readsCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)readsCnt / 1000.0f;
    }

    @Override
    public float getAveragePutTime() {
        long timeNanos = this.putTimeTotal.value();
        long putsCnt = this.writes.value();
        if (timeNanos == 0L || putsCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)putsCnt / 1000.0f;
    }

    @Override
    public float getAverageRemoveTime() {
        long timeNanos = this.rmvTimeTotal.value();
        long removesCnt = this.rmCnt.value();
        if (timeNanos == 0L || removesCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)removesCnt / 1000.0f;
    }

    public void onRead(boolean isHit) {
        this.reads.increment();
        if (isHit) {
            this.hits.increment();
        } else {
            this.misses.increment();
        }
        if (this.delegate != null) {
            this.delegate.onRead(isHit);
        }
    }

    public void keyCollisionsInfo(Supplier<List<Map.Entry<GridCacheMapEntry, Integer>>> coll) {
        this.txKeyCollisionInfo = coll;
        if (this.delegate != null) {
            this.delegate.keyCollisionsInfo(coll);
        }
    }

    @Nullable
    public Supplier<List<Map.Entry<GridCacheMapEntry, Integer>>> keyCollisionsInfo() {
        return this.txKeyCollisionInfo;
    }

    @Override
    public String getTxKeyCollisions() {
        List<Map.Entry<GridCacheMapEntry, Integer>> result;
        GridStringBuilder sb = null;
        Supplier<List<Map.Entry<GridCacheMapEntry, Integer>>> collInfo = this.keyCollisionsInfo();
        if (collInfo != null && !F.isEmpty(result = collInfo.get())) {
            sb = new SB();
            for (Map.Entry<GridCacheMapEntry, Integer> info : result) {
                if (sb.length() > 0) {
                    sb.a(U.nl());
                }
                sb.a("key=");
                sb.a(info.getKey().key());
                sb.a(", queueSize=");
                sb.a(info.getValue());
            }
        }
        return sb != null ? sb.toString() : "";
    }

    public void onInvokeUpdate(boolean isHit) {
        this.entryProcessorPuts.increment();
        if (isHit) {
            this.entryProcessorHits.increment();
        } else {
            this.entryProcessorMisses.increment();
        }
        if (this.delegate != null) {
            this.delegate.onInvokeUpdate(isHit);
        }
    }

    public void onInvokeRemove(boolean isHit) {
        this.entryProcessorRemovals.increment();
        if (isHit) {
            this.entryProcessorHits.increment();
        } else {
            this.entryProcessorMisses.increment();
        }
        if (this.delegate != null) {
            this.delegate.onInvokeRemove(isHit);
        }
    }

    public void onReadOnlyInvoke(boolean isHit) {
        this.entryProcessorReadOnlyInvocations.increment();
        if (isHit) {
            this.entryProcessorHits.increment();
        } else {
            this.entryProcessorMisses.increment();
        }
        if (this.delegate != null) {
            this.delegate.onReadOnlyInvoke(isHit);
        }
    }

    public void addInvokeTimeNanos(long duration) {
        this.entryProcessorInvokeTimeNanos.add(duration);
        this.recalculateInvokeMinTimeNanos(duration);
        this.recalculateInvokeMaxTimeNanos(duration);
        if (this.delegate != null) {
            this.delegate.addInvokeTimeNanos(duration);
        }
    }

    private void recalculateInvokeMinTimeNanos(long duration) {
        long minTime = this.entryProcessorMinInvocationTime.value();
        while (!(minTime <= duration && minTime != 0L || MetricUtils.compareAndSet(this.entryProcessorMinInvocationTime, minTime, duration))) {
            minTime = this.entryProcessorMinInvocationTime.value();
        }
    }

    private void recalculateInvokeMaxTimeNanos(long duration) {
        long maxTime = this.entryProcessorMaxInvocationTime.value();
        while (maxTime < duration && !MetricUtils.compareAndSet(this.entryProcessorMaxInvocationTime, maxTime, duration)) {
            maxTime = this.entryProcessorMaxInvocationTime.value();
        }
    }

    public void onWrite() {
        this.writes.increment();
        if (this.delegate != null) {
            this.delegate.onWrite();
        }
    }

    public void onRemove() {
        this.rmCnt.increment();
        if (this.delegate != null) {
            this.delegate.onRemove();
        }
    }

    public void onEvict() {
        this.evictCnt.increment();
        if (this.delegate != null) {
            this.delegate.onEvict();
        }
    }

    public void onTxCommit(long duration) {
        this.txCommits.increment();
        this.commitTimeTotal.add(duration);
        this.commitTime.value(duration);
        if (this.delegate != null) {
            this.delegate.onTxCommit(duration);
        }
    }

    public void onTxRollback(long duration) {
        this.txRollbacks.increment();
        this.rollbackTimeTotal.add(duration);
        this.rollbackTime.value(duration);
        if (this.delegate != null) {
            this.delegate.onTxRollback(duration);
        }
    }

    public void addGetTimeNanos(long duration) {
        this.getTimeTotal.add(duration);
        this.getTime.value(duration);
        if (this.delegate != null) {
            this.delegate.addGetTimeNanos(duration);
        }
    }

    public void addPutTimeNanos(long duration) {
        this.putTimeTotal.add(duration);
        this.putTime.value(duration);
        if (this.delegate != null) {
            this.delegate.addPutTimeNanos(duration);
        }
    }

    public void addRemoveTimeNanos(long duration) {
        this.rmvTimeTotal.add(duration);
        this.rmvTime.value(duration);
        if (this.delegate != null) {
            this.delegate.addRemoveTimeNanos(duration);
        }
    }

    public void addRemoveAndGetTimeNanos(long duration) {
        this.rmvTimeTotal.add(duration);
        this.getTimeTotal.add(duration);
        if (this.delegate != null) {
            this.delegate.addRemoveAndGetTimeNanos(duration);
        }
    }

    public void addPutAndGetTimeNanos(long duration) {
        this.putTimeTotal.add(duration);
        this.getTimeTotal.add(duration);
        if (this.delegate != null) {
            this.delegate.addPutAndGetTimeNanos(duration);
        }
    }

    @Override
    public String getKeyType() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null ? ccfg.getKeyType().getName() : null;
    }

    @Override
    public String getValueType() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null ? ccfg.getValueType().getName() : null;
    }

    @Override
    public boolean isReadThrough() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isReadThrough();
    }

    @Override
    public boolean isWriteThrough() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isWriteThrough();
    }

    private boolean isValidForOperation(boolean read) {
        if (this.cctx.isLocal()) {
            return true;
        }
        try {
            GridDhtPartitionsExchangeFuture fut = this.cctx.shared().exchange().lastFinishedFuture();
            return fut != null && fut.validateCache(this.cctx, false, read, null, null) == null;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public boolean isValidForReading() {
        return this.isValidForOperation(true);
    }

    @Override
    public boolean isValidForWriting() {
        return this.isValidForOperation(false);
    }

    @Override
    public boolean isStoreByValue() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isStoreByValue();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.cctx.statisticsEnabled();
    }

    @Override
    public boolean isManagementEnabled() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isManagementEnabled();
    }

    public EntriesStatMetrics getEntriesStat() {
        int owningPartCnt = 0;
        int movingPartCnt = 0;
        long offHeapEntriesCnt = 0L;
        long offHeapPrimaryEntriesCnt = 0L;
        long offHeapBackupEntriesCnt = 0L;
        long heapEntriesCnt = 0L;
        int size = 0;
        long sizeLong = 0L;
        try {
            AffinityTopologyVersion topVer = this.cctx.affinity().affinityTopologyVersion();
            if (AffinityTopologyVersion.NONE.equals(topVer)) {
                return this.unknownEntriesStat();
            }
            GridCacheAdapter<?, ?> cache = this.cctx.cache();
            if (cache != null) {
                offHeapEntriesCnt = cache.offHeapEntriesCount();
                size = cache.localSize(null);
                sizeLong = cache.localSizeLong(null);
            }
            if (this.cctx.isLocal()) {
                if (cache != null) {
                    offHeapPrimaryEntriesCnt = offHeapEntriesCnt;
                    heapEntriesCnt = cache.sizeLong();
                }
            } else {
                ImmutableIntSet primaries = ImmutableIntSet.wrap(this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer));
                ImmutableIntSet backups = ImmutableIntSet.wrap(this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer));
                if (this.cctx.isNear() && cache != null) {
                    heapEntriesCnt = cache.nearSize();
                }
                for (GridDhtLocalPartition part : this.cctx.topology().currentLocalPartitions()) {
                    GridDhtPartitionState partState = part.state();
                    if (partState == GridDhtPartitionState.OWNING) {
                        ++owningPartCnt;
                    }
                    if (partState == GridDhtPartitionState.MOVING) {
                        ++movingPartCnt;
                    }
                    if (cache == null) continue;
                    long cacheSize = part.dataStore().cacheSize(this.cctx.cacheId());
                    if (primaries.contains(part.id())) {
                        offHeapPrimaryEntriesCnt += cacheSize;
                    } else if (backups.contains(part.id())) {
                        offHeapBackupEntriesCnt += cacheSize;
                    }
                    heapEntriesCnt += (long)part.publicSize(this.cctx.cacheId());
                }
            }
        }
        catch (Exception e) {
            return this.unknownEntriesStat();
        }
        boolean isEmpty = offHeapEntriesCnt == 0L;
        EntriesStatMetrics stat = new EntriesStatMetrics();
        stat.offHeapEntriesCount(offHeapEntriesCnt);
        stat.offHeapPrimaryEntriesCount(offHeapPrimaryEntriesCnt);
        stat.offHeapBackupEntriesCount(offHeapBackupEntriesCnt);
        stat.heapEntriesCount(heapEntriesCnt);
        stat.size(size);
        stat.cacheSize(sizeLong);
        stat.keySize(size);
        stat.isEmpty(isEmpty);
        stat.totalPartitionsCount(owningPartCnt + movingPartCnt);
        stat.rebalancingPartitionsCount(movingPartCnt);
        return stat;
    }

    private EntriesStatMetrics unknownEntriesStat() {
        EntriesStatMetrics stat = new EntriesStatMetrics();
        stat.offHeapEntriesCount(-1L);
        stat.offHeapPrimaryEntriesCount(-1L);
        stat.offHeapBackupEntriesCount(-1L);
        stat.heapEntriesCount(-1L);
        stat.size(-1);
        stat.cacheSize(-1L);
        stat.keySize(-1);
        stat.isEmpty(false);
        stat.totalPartitionsCount(-1);
        stat.rebalancingPartitionsCount(0);
        return stat;
    }

    @Override
    public int getTotalPartitionsCount() {
        return this.getEntriesStat().totalPartitionsCount();
    }

    @Override
    public int getRebalancingPartitionsCount() {
        return this.getEntriesStat().rebalancingPartitionsCount();
    }

    @Override
    public long getRebalancedKeys() {
        return this.rebalancedKeys.value();
    }

    @Override
    public long getEstimatedRebalancingKeys() {
        return this.estimatedRebalancingKeys.value();
    }

    @Override
    public long getKeysToRebalanceLeft() {
        return Math.max(0L, this.estimatedRebalancingKeys.value() - this.rebalancedKeys.value());
    }

    @Override
    public long getRebalancingKeysRate() {
        return this.rebalancingKeysRate.value();
    }

    @Override
    public long getRebalancingBytesRate() {
        return this.rebalancingBytesRate.value();
    }

    public void clearRebalanceCounters() {
        this.estimatedRebalancingKeys.reset();
        this.rebalancedKeys.reset();
        this.totalRebalancedBytes.reset();
        this.rebalancingBytesRate.reset();
        this.rebalancingKeysRate.reset();
        this.rebalanceStartTime.value(-1L);
    }

    public void startRebalance(long delay) {
        this.rebalanceStartTime.value(delay + U.currentTimeMillis());
    }

    @Override
    public long estimateRebalancingFinishTime() {
        return this.getEstimatedRebalancingFinishTime();
    }

    @Override
    public long rebalancingStartTime() {
        return this.rebalanceStartTime.value();
    }

    @Override
    public long getEstimatedRebalancingFinishTime() {
        long rate = this.rebalancingKeysRate.value();
        return rate <= 0L ? -1L : this.getKeysToRebalanceLeft() / rate * (long)REBALANCE_RATE_INTERVAL + U.currentTimeMillis();
    }

    @Override
    public long getRebalancingStartTime() {
        return this.rebalanceStartTime.value();
    }

    @Override
    public long getRebalanceClearingPartitionsLeft() {
        return this.rebalanceClearingPartitions.value();
    }

    public long evictingPartitionsLeft() {
        return this.evictingPartitions.value();
    }

    public void incrementRebalanceClearingPartitions() {
        this.rebalanceClearingPartitions.increment();
    }

    public void decrementRebalanceClearingPartitions() {
        this.rebalanceClearingPartitions.decrement();
    }

    public void incrementEvictingPartitions() {
        this.evictingPartitions.increment();
    }

    public void decrementEvictingPartitions() {
        this.evictingPartitions.decrement();
    }

    public void onRebalancingKeysCountEstimateReceived(Long keysCnt) {
        if (keysCnt == null) {
            return;
        }
        this.estimatedRebalancingKeys.add(keysCnt);
    }

    public void onRebalanceKeyReceived(long keys) {
        this.rebalancedKeys.add(keys);
        this.rebalancingKeysRate.add(keys);
    }

    public void onRebalanceBatchReceived(long batchSize) {
        this.totalRebalancedBytes.add(batchSize);
        this.rebalancingBytesRate.add(batchSize);
    }

    public long getTotalAllocatedPages() {
        return 0L;
    }

    public long getTotalEvictedPages() {
        return 0L;
    }

    public void onOffHeapRead(boolean hit) {
        this.offHeapGets.increment();
        if (hit) {
            this.offHeapHits.increment();
        } else {
            this.offHeapMisses.increment();
        }
        if (this.delegate != null) {
            this.delegate.onOffHeapRead(hit);
        }
    }

    public void onOffHeapWrite() {
        this.offHeapPuts.increment();
        if (this.delegate != null) {
            this.delegate.onOffHeapWrite();
        }
    }

    public void onOffHeapRemove() {
        this.offHeapRemoves.increment();
        if (this.delegate != null) {
            this.delegate.onOffHeapRemove();
        }
    }

    public void onOffHeapEvict() {
        this.offHeapEvicts.increment();
        if (this.delegate != null) {
            this.delegate.onOffHeapEvict();
        }
    }

    @Override
    public boolean isIndexRebuildInProgress() {
        IgniteInternalFuture<?> fut = this.cctx.shared().kernalContext().query().indexRebuildFuture(this.cctx.cacheId());
        return fut != null && !fut.isDone();
    }

    @Override
    public long getIndexRebuildKeysProcessed() {
        return this.idxRebuildKeyProcessed.value();
    }

    public void resetIndexRebuildKeyProcessed() {
        this.idxRebuildKeyProcessed.reset();
    }

    public void addIndexRebuildKeyProcessed(long val) {
        this.idxRebuildKeyProcessed.add(val);
    }

    public String toString() {
        return S.toString(CacheMetricsImpl.class, this);
    }

    public static class EntriesStatMetrics {
        private int totalPartsCnt;
        private int rebalancingPartsCnt;
        private long offHeapEntriesCnt;
        private long offHeapPrimaryEntriesCnt;
        private long offHeapBackupEntriesCnt;
        private long heapEntriesCnt;
        private int size;
        private long cacheSize;
        private int keySize;
        private boolean isEmpty;

        public int totalPartitionsCount() {
            return this.totalPartsCnt;
        }

        public void totalPartitionsCount(int totalPartsCnt) {
            this.totalPartsCnt = totalPartsCnt;
        }

        public int rebalancingPartitionsCount() {
            return this.rebalancingPartsCnt;
        }

        public void rebalancingPartitionsCount(int rebalancingPartsCnt) {
            this.rebalancingPartsCnt = rebalancingPartsCnt;
        }

        public long offHeapEntriesCount() {
            return this.offHeapEntriesCnt;
        }

        public void offHeapEntriesCount(long offHeapEntriesCnt) {
            this.offHeapEntriesCnt = offHeapEntriesCnt;
        }

        public long offHeapPrimaryEntriesCount() {
            return this.offHeapPrimaryEntriesCnt;
        }

        public void offHeapPrimaryEntriesCount(long offHeapPrimaryEntriesCnt) {
            this.offHeapPrimaryEntriesCnt = offHeapPrimaryEntriesCnt;
        }

        public long offHeapBackupEntriesCount() {
            return this.offHeapBackupEntriesCnt;
        }

        public void offHeapBackupEntriesCount(long offHeapBackupEntriesCnt) {
            this.offHeapBackupEntriesCnt = offHeapBackupEntriesCnt;
        }

        public long heapEntriesCount() {
            return this.heapEntriesCnt;
        }

        public void heapEntriesCount(long heapEntriesCnt) {
            this.heapEntriesCnt = heapEntriesCnt;
        }

        public int size() {
            return this.size;
        }

        public void size(int size) {
            this.size = size;
        }

        public int keySize() {
            return this.keySize;
        }

        public void keySize(int keySize) {
            this.keySize = keySize;
        }

        public long cacheSize() {
            return this.cacheSize;
        }

        public void cacheSize(long cacheSize) {
            this.cacheSize = cacheSize;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        public void isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
        }
    }
}

