/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.FloatIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class FloatInlineIndexKeyType
extends NullableInlineIndexKeyType<FloatIndexKey> {
    public FloatInlineIndexKeyType() {
        super(8, (short)4);
    }

    @Override
    public int compare0(long pageAddr, int off, FloatIndexKey key) {
        float val1 = Float.intBitsToFloat(PageUtils.getInt(pageAddr, off + 1));
        return Integer.signum(Float.compare(val1, ((Float)key.key()).floatValue()));
    }

    @Override
    protected int put0(long pageAddr, int off, FloatIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        PageUtils.putInt(pageAddr, off + 1, Float.floatToIntBits(((Float)key.key()).floatValue()));
        return this.keySize + 1;
    }

    @Override
    protected FloatIndexKey get0(long pageAddr, int off) {
        float key = Float.intBitsToFloat(PageUtils.getInt(pageAddr, off + 1));
        return new FloatIndexKey(key);
    }

    @Override
    protected int inlineSize0(FloatIndexKey val) {
        return this.keySize + 1;
    }
}

