/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Comparator;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IndexListInfoContainer
extends IgniteDataTransferObject {
    public static final String EMPTY_GROUP_NAME = "no_group";
    private static final long serialVersionUID = 0L;
    private String grpName;
    private String cacheName;
    private String idxName;
    @GridToStringInclude
    private Collection<String> colsNames;
    private String tblName;

    public IndexListInfoContainer() {
    }

    public IndexListInfoContainer(GridCacheContext ctx, String idxName, Collection<String> colsNames, String tblName) {
        this.cacheName = ctx.name();
        String cfgGrpName = ctx.config().getGroupName();
        this.grpName = cfgGrpName == null ? EMPTY_GROUP_NAME : cfgGrpName;
        this.idxName = idxName;
        this.colsNames = colsNames;
        this.tblName = tblName;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.cacheName);
        U.writeString(out, this.grpName);
        U.writeString(out, this.idxName);
        U.writeCollection(out, this.colsNames);
        U.writeString(out, this.tblName);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheName = U.readString(in);
        this.grpName = U.readString(in);
        this.idxName = U.readString(in);
        this.colsNames = U.readCollection(in);
        this.tblName = U.readString(in);
    }

    public void tableName(String tblName) {
        this.tblName = tblName;
    }

    public String toString() {
        String dfltImpl = S.toString(IndexListInfoContainer.class, this);
        return dfltImpl.substring(IndexListInfoContainer.class.getSimpleName().length() + 2, dfltImpl.length() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexListInfoContainer)) {
            return false;
        }
        IndexListInfoContainer other = (IndexListInfoContainer)o;
        return this.cacheName.equals(other.cacheName) && this.grpName.equals(other.groupName()) && this.idxName.equals(other.idxName) && this.tblName.equals(other.tblName) && this.colsNames.equals(other.colsNames);
    }

    public int hashCode() {
        return 7 * this.cacheName.hashCode() + 11 * this.grpName.hashCode() + 13 * this.idxName.hashCode() + 17 * this.colsNames.hashCode() + 23 * this.tblName.hashCode();
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String groupName() {
        return this.grpName;
    }

    public String indexName() {
        return this.idxName;
    }

    public String tableName() {
        return this.tblName;
    }

    public static Comparator<IndexListInfoContainer> comparator() {
        return Comparator.comparing(IndexListInfoContainer::groupName).thenComparing(IndexListInfoContainer::cacheName).thenComparing(IndexListInfoContainer::indexName);
    }
}

