/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.streamer;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectImpl;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerEntry;

class ClientDataStreamerReader {
    ClientDataStreamerReader() {
    }

    public static Collection<DataStreamerEntry> read(BinaryReaderExImpl reader) {
        int entriesCnt = reader.readInt();
        if (entriesCnt == 0) {
            return null;
        }
        ArrayList<DataStreamerEntry> entries = new ArrayList<DataStreamerEntry>(entriesCnt);
        for (int i = 0; i < entriesCnt; ++i) {
            entries.add(new DataStreamerEntry((KeyCacheObject)ClientDataStreamerReader.readCacheObject(reader, true), (CacheObject)ClientDataStreamerReader.readCacheObject(reader, false)));
        }
        return entries;
    }

    private static <T extends CacheObject> T readCacheObject(BinaryReaderExImpl reader, boolean isKey) {
        BinaryInputStream in = reader.in();
        int pos0 = in.position();
        Object obj = reader.readObjectDetached();
        if (obj == null) {
            return null;
        }
        int pos1 = in.position();
        in.position(pos0);
        byte[] objBytes = in.readByteArray(pos1 - pos0);
        return (T)(isKey ? new KeyCacheObjectImpl(obj, objBytes, -1) : new CacheObjectImpl(obj, objBytes));
    }
}

