/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;

public class ClientCachePartitionMapping {
    private final HashMap<UUID, Set<Integer>> partitionMap;

    public ClientCachePartitionMapping(int cacheId, AffinityAssignment assignment) {
        Set<ClusterNode> nodes = assignment.primaryPartitionNodes();
        this.partitionMap = new HashMap(nodes.size());
        for (ClusterNode node : nodes) {
            UUID nodeId = node.id();
            Set<Integer> parts = assignment.primaryPartitions(nodeId);
            this.partitionMap.put(nodeId, parts);
        }
    }

    public void write(BinaryRawWriter writer) {
        writer.writeInt(this.partitionMap.size());
        for (Map.Entry<UUID, Set<Integer>> nodeParts : this.partitionMap.entrySet()) {
            UUID nodeUuid = nodeParts.getKey();
            Set<Integer> parts = nodeParts.getValue();
            writer.writeUuid(nodeUuid);
            writer.writeInt(parts.size());
            for (int part : parts) {
                writer.writeInt(part);
            }
        }
    }

    public boolean isCompatible(ClientCachePartitionMapping another) {
        return this.partitionMap.equals(another.partitionMap);
    }
}

