/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;

public class GridCacheSharedTtlCleanupManager
extends GridCacheSharedManagerAdapter {
    private static final long CLEANUP_WORKER_SLEEP_INTERVAL = 500L;
    private static final int CLEANUP_WORKER_ENTRIES_PROCESS_LIMIT = 1000;
    private CleanupWorker cleanupWorker;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<Integer, GridCacheTtlManager> mgrs = new ConcurrentHashMap<Integer, GridCacheTtlManager>();

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.stopCleanupWorker();
    }

    public void register(GridCacheTtlManager mgr) {
        if (this.mgrs.isEmpty()) {
            this.startCleanupWorker();
        }
        this.mgrs.put(mgr.context().cacheId(), mgr);
    }

    public void unregister(GridCacheTtlManager mgr) {
        this.mgrs.remove(mgr.context().cacheId());
        if (this.mgrs.isEmpty()) {
            this.stopCleanupWorker();
        }
    }

    public boolean eagerTtlEnabled() {
        assert (this.cctx != null) : "Manager is not started";
        this.lock.lock();
        try {
            boolean bl = this.cleanupWorker != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startCleanupWorker() {
        this.lock.lock();
        try {
            if (this.cleanupWorker != null) {
                return;
            }
            this.cleanupWorker = new CleanupWorker();
            new IgniteThread(this.cleanupWorker).start();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopCleanupWorker() {
        this.lock.lock();
        try {
            if (null != this.cleanupWorker) {
                U.cancel(this.cleanupWorker);
                U.join(this.cleanupWorker, this.log);
                this.cleanupWorker = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static /* synthetic */ Map access$000(GridCacheSharedTtlCleanupManager x0) {
        return x0.mgrs;
    }

    private class CleanupWorker
    extends GridWorker {
        CleanupWorker() {
            super(GridCacheSharedTtlCleanupManager.this.cctx.igniteInstanceName(), "ttl-cleanup-worker", GridCacheSharedTtlCleanupManager.this.cctx.logger(GridCacheSharedTtlCleanupManager.class), GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().workersRegistry());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            err /* !! */  = null;
            try {
                this.blockingSectionBegin();
                try {
                    GridCacheSharedTtlCleanupManager.this.cctx.discovery().localJoin();
                    try {
                        GridCacheSharedTtlCleanupManager.this.cctx.exchange().affinityReadyFuture(AffinityTopologyVersion.ZERO).get();
                    }
                    catch (IgniteCheckedException ex) {
                        throw new IgniteException("Failed to wait for initialization topology [err=" + ex.getMessage() + ']', ex);
                    }
                }
                finally {
                    this.blockingSectionEnd();
                }
                if (!CleanupWorker.$assertionsDisabled && GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().recoveryMode()) {
                    throw new AssertionError();
                }
                expiredRemains = new AtomicBoolean();
lbl20:
                // 2 sources

                while (!this.isCancelled()) {
                    expiredRemains.set(false);
                    for (Map.Entry<K, V> mgr : GridCacheSharedTtlCleanupManager.access$000(GridCacheSharedTtlCleanupManager.this).entrySet()) {
                        this.updateHeartbeat();
                        processedCacheID = (Integer)mgr.getKey();
                        GridCacheSharedTtlCleanupManager.this.cctx.database().checkpointReadLock();
                        try {
                            GridCacheSharedTtlCleanupManager.access$000(GridCacheSharedTtlCleanupManager.this).computeIfPresent(processedCacheID, (BiFunction<Integer, GridCacheTtlManager, GridCacheTtlManager>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$body$0(java.util.concurrent.atomic.AtomicBoolean java.lang.Integer org.apache.ignite.internal.processors.cache.GridCacheTtlManager ), (Ljava/lang/Integer;Lorg/apache/ignite/internal/processors/cache/GridCacheTtlManager;)Lorg/apache/ignite/internal/processors/cache/GridCacheTtlManager;)((AtomicBoolean)expiredRemains));
                        }
                        finally {
                            GridCacheSharedTtlCleanupManager.this.cctx.database().checkpointReadUnlock();
                        }
                        if (!this.isCancelled()) continue;
                        if (err /* !! */  != null || this.isCancelled) ** GOTO lbl59
                        err /* !! */  = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                        ** GOTO lbl59
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl72
            }
            catch (Throwable t) {
                block29: {
                    try {
                        if (X.hasCause(t, new Class[]{NodeStoppingException.class})) {
                            this.isCancelled = true;
                            if (err /* !! */  != null || this.isCancelled) ** GOTO lbl82
                            err /* !! */  = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var7_10) {
                        if (err /* !! */  == null && !this.isCancelled) {
                            err /* !! */  = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                        }
                        if (err /* !! */  instanceof OutOfMemoryError) {
                            GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err /* !! */ ));
                            throw var7_10;
                        }
                        if (err /* !! */  == null) throw var7_10;
                        GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err /* !! */ ));
                        throw var7_10;
                    }
lbl59:
                    // 2 sources

                    if (err /* !! */  instanceof OutOfMemoryError) {
                        GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err /* !! */ ));
                        return;
                    }
                    if (err /* !! */  == null) return;
                    GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err /* !! */ ));
                    return;
lbl-1000:
                    // 1 sources

                    {
                        this.updateHeartbeat();
                        if (!expiredRemains.get()) {
                            U.sleep(500L);
                        }
                        this.onIdle();
                        ** GOTO lbl20
                    }
lbl72:
                    // 1 sources

                    if (err /* !! */  == null && !this.isCancelled) {
                        err /* !! */  = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                    }
                    if (err /* !! */  instanceof OutOfMemoryError) {
                        GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err /* !! */ ));
                        return;
                    }
                    if (err /* !! */  == null) return;
                    GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err /* !! */ ));
                    return;
lbl82:
                    // 2 sources

                    if (err /* !! */  instanceof OutOfMemoryError) {
                        GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err /* !! */ ));
                        return;
                    }
                    if (err /* !! */  == null) return;
                    GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err /* !! */ ));
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (t instanceof IgniteInterruptedCheckedException != false) throw t;
                        if (t instanceof InterruptedException != false) throw t;
                        if (!this.isCancelled) ** GOTO lbl-1000
                        if (err /* !! */  != null || this.isCancelled) break block29;
                        err /* !! */  = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                    }
                }
                if (err /* !! */  instanceof OutOfMemoryError) {
                    GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err /* !! */ ));
                    return;
                }
                if (err /* !! */  == null) return;
                GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err /* !! */ ));
                return;
lbl-1000:
                // 1 sources

                {
                    err /* !! */  = t;
                    throw t;
                }
            }
        }

        private static /* synthetic */ GridCacheTtlManager lambda$body$0(AtomicBoolean expiredRemains, Integer id, GridCacheTtlManager m) {
            if (m.expire(1000)) {
                expiredRemains.set(true);
            }
            return m;
        }
    }
}

