/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CachesRegistry;
import org.apache.ignite.internal.processors.cache.ClientCacheChangeDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.ClientCacheChangeDummyDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.ClientCacheUpdateTimeout;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.StartCacheInfo;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAssignmentFetchFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CacheGroupAffinityMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridClientPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridPartitionStateMap;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class CacheAffinitySharedManager<K, V>
extends GridCacheSharedManagerAdapter<K, V> {
    public static final int DFLT_CLIENT_CACHE_CHANGE_MESSAGE_TIMEOUT = 10000;
    private final long clientCacheMsgTimeout = IgniteSystemProperties.getLong("IGNITE_CLIENT_CACHE_CHANGE_MESSAGE_TIMEOUT", 10000L);
    private static final IgniteClosure<ClusterNode, UUID> NODE_TO_ID = new IgniteClosure<ClusterNode, UUID>(){

        @Override
        public UUID apply(ClusterNode node) {
            return node.id();
        }
    };
    private static final IgniteClosure<ClusterNode, Long> NODE_TO_ORDER = new IgniteClosure<ClusterNode, Long>(){

        @Override
        public Long apply(ClusterNode node) {
            return node.order();
        }
    };
    private ConcurrentMap<Integer, CacheGroupHolder> grpHolders = new ConcurrentHashMap<Integer, CacheGroupHolder>();
    private CacheMemoryOverheadValidator validator = new CacheMemoryOverheadValidator();
    private AffinityTopologyVersion lastAffVer;
    private CachesRegistry cachesRegistry;
    private WaitRebalanceInfo waitInfo;
    private final Object mux = new Object();
    private final ConcurrentMap<Long, GridDhtAssignmentFetchFuture> pendingAssignmentFetchFuts = new ConcurrentHashMap<Long, GridDhtAssignmentFetchFuture>();
    private final ThreadLocal<ClientCacheChangeDiscoveryMessage> clientCacheChanges = new ThreadLocal();
    private final GridLocalEventListener discoLsnr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            DiscoveryEvent e = (DiscoveryEvent)evt;
            assert (e.type() == 11 || e.type() == 12);
            ClusterNode n = e.eventNode();
            for (GridDhtAssignmentFetchFuture fut : CacheAffinitySharedManager.this.pendingAssignmentFetchFuts.values()) {
                fut.onNodeLeft(n.id());
            }
        }
    };

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.cctx.kernalContext().event().addLocalEventListener(this.discoLsnr, 11, 12);
        this.cachesRegistry = new CachesRegistry(this.cctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDiscoveryEvent(int type, @Nullable DiscoveryCustomMessage customMsg, ClusterNode node, AffinityTopologyVersion topVer, DiscoveryDataClusterState state) {
        if (type == 10 && node.isLocal()) {
            this.lastAffVer = null;
        }
        if (!(!state.transition() && state.active() || DiscoveryCustomEvent.requiresCentralizedAffinityAssignment(customMsg))) {
            return;
        }
        if (!node.isClient() && (type == 12 || type == 10 || type == 11) || DiscoveryCustomEvent.requiresCentralizedAffinityAssignment(customMsg)) {
            Object object = this.mux;
            synchronized (object) {
                assert (this.lastAffVer == null || topVer.compareTo(this.lastAffVer) > 0) : "lastAffVer=" + this.lastAffVer + ", topVer=" + topVer + ", customMsg=" + customMsg;
                this.lastAffVer = topVer;
            }
        }
    }

    public IgniteInternalFuture<?> initCachesOnLocalJoin(Map<Integer, CacheGroupDescriptor> grpDescs, Map<String, DynamicCacheDescriptor> cacheDescs) {
        return this.cachesRegistry.init(grpDescs, cacheDescs);
    }

    boolean onCustomEvent(CacheAffinityChangeMessage msg) {
        if (msg.exchangeId() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignore affinity change message [lastAffVer=" + this.lastAffVer + ", msgExchId=" + msg.exchangeId() + ", msgVer=" + msg.topologyVersion() + ']');
            }
            return false;
        }
        boolean exchangeNeeded = this.lastAffVer == null || this.lastAffVer.equals(msg.topologyVersion());
        msg.exchangeNeeded(exchangeNeeded);
        if (exchangeNeeded) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Need process affinity change message [lastAffVer=" + this.lastAffVer + ", msgExchId=" + msg.exchangeId() + ", msgVer=" + msg.topologyVersion() + ']');
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Ignore affinity change message [lastAffVer=" + this.lastAffVer + ", msgExchId=" + msg.exchangeId() + ", msgVer=" + msg.topologyVersion() + ']');
        }
        return exchangeNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCacheGroupStopped(AffinityTopologyVersion topVer) {
        CacheAffinityChangeMessage msg = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.waitInfo == null || !this.waitInfo.topVer.equals(topVer)) {
                return;
            }
            if (this.waitInfo.waitGrps.isEmpty()) {
                msg = this.affinityChangeMessage(this.waitInfo);
                this.waitInfo = null;
            }
        }
        try {
            if (msg != null) {
                this.cctx.discovery().sendCustomEvent(msg);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send affinity change message.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkRebalanceState(GridDhtPartitionTopology top, Integer checkGrpId) {
        CacheAffinityChangeMessage msg = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.waitInfo == null || !this.waitInfo.topVer.equals(this.lastAffVer)) {
                return;
            }
            Set partWait = (Set)this.waitInfo.waitGrps.get(checkGrpId);
            boolean rebalanced = true;
            if (partWait != null) {
                CacheGroupHolder grpHolder = (CacheGroupHolder)this.grpHolders.get(checkGrpId);
                if (grpHolder != null) {
                    Iterator it = partWait.iterator();
                    while (it.hasNext()) {
                        List ideal;
                        Integer part = (Integer)it.next();
                        List<ClusterNode> owners = top.owners(part, this.waitInfo.topVer);
                        if (!owners.containsAll(ideal = (List)((Map)this.waitInfo.assignments.get(checkGrpId)).get(part))) {
                            rebalanced = false;
                            break;
                        }
                        it.remove();
                    }
                }
                if (rebalanced) {
                    this.waitInfo.waitGrps.remove(checkGrpId);
                    if (this.waitInfo.waitGrps.isEmpty()) {
                        msg = this.affinityChangeMessage(this.waitInfo);
                        this.waitInfo = null;
                    }
                }
            }
            try {
                if (msg != null) {
                    this.cctx.discovery().sendCustomEvent(msg);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send affinity change message.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> waitGroups() {
        Object object = this.mux;
        synchronized (object) {
            if (this.waitInfo == null || !this.waitInfo.topVer.equals(this.lastAffVer)) {
                return Collections.emptySet();
            }
            return new HashSet<Integer>(this.waitInfo.waitGrps.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitRebalance(int grpId, int partId) {
        Object object = this.mux;
        synchronized (object) {
            return this.waitInfo != null && this.waitInfo.waitGrps.getOrDefault(grpId, Collections.emptySet()).contains(partId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rebalanceRequired() {
        Object object = this.mux;
        synchronized (object) {
            return this.waitInfo != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToWaitGroup(int grpId, int part, AffinityTopologyVersion topVer, List<ClusterNode> assignment) {
        Object object = this.mux;
        synchronized (object) {
            if (this.waitInfo == null) {
                this.waitInfo = new WaitRebalanceInfo(topVer);
            }
            this.waitInfo.add(grpId, part, assignment);
        }
    }

    @Nullable
    private CacheAffinityChangeMessage affinityChangeMessage(WaitRebalanceInfo waitInfo) {
        if (waitInfo.assignments.isEmpty()) {
            return null;
        }
        return new CacheAffinityChangeMessage(waitInfo.topVer, waitInfo.deploymentIds);
    }

    void onCacheGroupCreated(CacheGroupContext grp) {
    }

    @Nullable
    private List<DynamicCacheDescriptor> clientCachesToStart(UUID reqId, Map<String, DynamicCacheChangeRequest> startReqs) {
        ArrayList<DynamicCacheDescriptor> startDescs = new ArrayList<DynamicCacheDescriptor>(startReqs.size());
        for (DynamicCacheChangeRequest startReq : startReqs.values()) {
            DynamicCacheDescriptor desc = this.cachesRegistry.cache(CU.cacheId(startReq.cacheName()));
            if (desc == null) {
                CacheException err = new CacheException("Failed to start client cache (a cache with the given name is not started): " + startReq.cacheName());
                this.cctx.cache().completeClientCacheChangeFuture(reqId, (Exception)((Object)err));
                return null;
            }
            if (this.cctx.cacheContext(desc.cacheId()) != null) continue;
            startDescs.add(desc);
        }
        return startDescs;
    }

    @Nullable
    private Map<Integer, Boolean> processClientCacheStartRequests(boolean crd, ClientCacheChangeDummyDiscoveryMessage msg, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        CacheGroupContext grp;
        Map<String, DynamicCacheChangeRequest> startReqs = msg.startRequests();
        List<DynamicCacheDescriptor> startDescs = this.clientCachesToStart(msg.requestId(), startReqs);
        if (startDescs == null || startDescs.isEmpty()) {
            this.cctx.cache().completeClientCacheChangeFuture(msg.requestId(), null);
            return null;
        }
        HashMap<Integer, GridDhtAssignmentFetchFuture> fetchFuts = U.newHashMap(startDescs.size());
        HashMap<Integer, Boolean> startedInfos = U.newHashMap(startDescs.size());
        List<StartCacheInfo> startCacheInfos = startDescs.stream().map(desc -> {
            DynamicCacheChangeRequest changeReq = (DynamicCacheChangeRequest)startReqs.get(desc.cacheName());
            startedInfos.put(desc.cacheId(), changeReq.nearCacheConfiguration() != null);
            return new StartCacheInfo(desc.cacheConfiguration(), (DynamicCacheDescriptor)desc, changeReq.nearCacheConfiguration(), topVer, changeReq.disabledAfterStart(), true);
        }).collect(Collectors.toList());
        Set<String> startedCaches = startCacheInfos.stream().map(info -> info.getCacheDescriptor().cacheName()).collect(Collectors.toSet());
        try {
            this.cctx.cache().prepareStartCaches(startCacheInfos);
        }
        catch (IgniteCheckedException e) {
            this.cctx.cache().closeCaches(startedCaches, false);
            this.cctx.cache().completeClientCacheChangeFuture(msg.requestId(), e);
            return null;
        }
        Set groupDescs = startDescs.stream().map(DynamicCacheDescriptor::groupDescriptor).collect(Collectors.toSet());
        for (CacheGroupDescriptor grpDesc : groupDescs) {
            try {
                boolean topVerLessOrNotInitialized;
                grp = this.cctx.cache().cacheGroup(grpDesc.groupId());
                assert (grp != null) : grpDesc.groupId();
                assert (!grp.affinityNode() || grp.isLocal()) : grp.cacheOrGroupName();
                if (grp.isLocal()) continue;
                CacheGroupHolder grpHolder = (CacheGroupHolder)this.grpHolders.get(grp.groupId());
                assert (!crd || grpHolder != null && grpHolder.affinity().idealAssignmentRaw() != null);
                if (grpHolder == null) {
                    grpHolder = this.getOrCreateGroupHolder(topVer, grpDesc);
                }
                if (grpHolder.nonAffNode() && !this.cctx.localNode().isClient()) {
                    GridDhtPartitionsExchangeFuture excFut = this.context().exchange().lastFinishedFuture();
                    grp.topology().updateTopologyVersion(excFut, discoCache, -1L, false);
                    grp.topology().beforeExchange(excFut, true, false);
                    grpHolder = new CacheGroupAffNodeHolder(grp, grpHolder.affinity());
                    this.grpHolders.put(grp.groupId(), grpHolder);
                    GridClientPartitionTopology clientTop = this.cctx.exchange().clearClientTopology(grp.groupId());
                    if (clientTop != null) {
                        grp.topology().update(grpHolder.affinity().lastVersion(), clientTop.partitionMap(true), clientTop.fullUpdateCounters(), Collections.emptySet(), null, null, null, clientTop.lostPartitions());
                        excFut.validate(grp);
                    }
                    assert (grpHolder.affinity().lastVersion().equals(grp.affinity().lastVersion()));
                    continue;
                }
                if (crd || fetchFuts.containsKey(grp.groupId())) continue;
                boolean bl = topVerLessOrNotInitialized = !grp.topology().initialized() || grp.topology().readyTopologyVersion().compareTo(topVer) < 0;
                if (grp.affinity().lastVersion().compareTo(topVer) >= 0 && !topVerLessOrNotInitialized) continue;
                GridDhtAssignmentFetchFuture fetchFut = new GridDhtAssignmentFetchFuture(this.cctx, grp.groupId(), topVer, discoCache);
                fetchFut.init(true);
                fetchFuts.put(grp.groupId(), fetchFut);
            }
            catch (IgniteCheckedException e) {
                this.cctx.cache().closeCaches(startedCaches, false);
                this.cctx.cache().completeClientCacheChangeFuture(msg.requestId(), e);
                return null;
            }
        }
        for (GridDhtAssignmentFetchFuture fetchFut : fetchFuts.values()) {
            try {
                GridDhtPartitionFullMap partMap;
                grp = this.cctx.cache().cacheGroup(fetchFut.groupId());
                assert (grp != null);
                GridDhtAffinityAssignmentResponse res = this.fetchAffinity(topVer, null, discoCache, grp.affinity(), fetchFut);
                if (res != null) {
                    partMap = res.partitionMap();
                    assert (partMap != null) : res;
                } else {
                    partMap = new GridDhtPartitionFullMap(this.cctx.localNodeId(), this.cctx.localNode().order(), 1L);
                }
                GridDhtPartitionsExchangeFuture exchFut = this.context().exchange().lastFinishedFuture();
                grp.topology().updateTopologyVersion(exchFut, discoCache, -1L, false);
                GridClientPartitionTopology clientTop = this.cctx.exchange().clearClientTopology(grp.groupId());
                Set<Integer> lostParts = clientTop == null ? null : clientTop.lostPartitions();
                grp.topology().update(topVer, partMap, null, Collections.emptySet(), null, null, null, lostParts);
                if (clientTop == null) {
                    grp.topology().detectLostPartitions(topVer, exchFut);
                }
                exchFut.validate(grp);
            }
            catch (IgniteCheckedException e) {
                this.cctx.cache().closeCaches(startedCaches, false);
                this.cctx.cache().completeClientCacheChangeFuture(msg.requestId(), e);
                return null;
            }
        }
        for (DynamicCacheDescriptor desc2 : startDescs) {
            if (desc2.cacheConfiguration().getCacheMode() == CacheMode.LOCAL) continue;
            grp = this.cctx.cache().cacheGroup(desc2.groupId());
            assert (grp != null);
            grp.topology().onExchangeDone(null, grp.affinity().cachedAffinity(topVer), true);
        }
        this.cctx.cache().initCacheProxies(topVer, null);
        startReqs.keySet().forEach(req -> this.cctx.cache().completeProxyInitialize((String)req));
        this.cctx.cache().completeClientCacheChangeFuture(msg.requestId(), null);
        return startedInfos;
    }

    private Set<Integer> processCacheCloseRequests(ClientCacheChangeDummyDiscoveryMessage msg, AffinityTopologyVersion topVer) {
        Set<String> cachesToClose = msg.cachesToClose();
        Set<Integer> closed = this.cctx.cache().closeCaches(cachesToClose, true);
        for (CacheGroupHolder hld : this.grpHolders.values()) {
            if (hld.nonAffNode() || this.cctx.cache().cacheGroup(hld.groupId()) != null) continue;
            int grpId = hld.groupId();
            CacheGroupHolder grpHolder = (CacheGroupHolder)this.grpHolders.remove(grpId);
            assert (grpHolder != null && !grpHolder.nonAffNode()) : grpHolder;
            try {
                grpHolder = this.createHolder(this.cctx, this.cachesRegistry.group(grpId), topVer, grpHolder.affinity());
                this.grpHolders.put(grpId, grpHolder);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to initialize cache: " + e, e);
            }
        }
        this.cctx.cache().completeClientCacheChangeFuture(msg.requestId(), null);
        return closed;
    }

    void processClientCachesRequests(ClientCacheChangeDummyDiscoveryMessage msg) {
        AffinityTopologyVersion topVer = this.cctx.exchange().readyAffinityVersion();
        DiscoCache discoCache = this.cctx.discovery().discoCache(topVer);
        ClusterNode node = discoCache.oldestAliveServerNode();
        boolean crd = node != null && node.isLocal();
        Map<Integer, Boolean> startedCaches = null;
        Set<Integer> closedCaches = null;
        if (msg.startRequests() != null) {
            startedCaches = this.processClientCacheStartRequests(crd, msg, topVer, discoCache);
        }
        if (msg.cachesToClose() != null) {
            closedCaches = this.processCacheCloseRequests(msg, topVer);
        }
        if (startedCaches != null || closedCaches != null) {
            this.scheduleClientChangeMessage(startedCaches, closedCaches);
        }
    }

    void sendClientCacheChangesMessage(ClientCacheUpdateTimeout timeoutObj) {
        ClientCacheChangeDiscoveryMessage msg = this.clientCacheChanges.get();
        if (msg != null && msg.updateTimeoutObject() == timeoutObj) {
            assert (!msg.empty()) : msg;
            this.clientCacheChanges.remove();
            msg.checkCachesExist(this.cachesRegistry.allCaches().keySet());
            try {
                if (!msg.empty()) {
                    this.cctx.discovery().sendCustomEvent(msg);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send discovery event: " + e, e);
            }
        }
    }

    private void scheduleClientChangeMessage(Map<Integer, Boolean> startedCaches, Set<Integer> closedCaches) {
        long timeout;
        ClientCacheChangeDiscoveryMessage msg = this.clientCacheChanges.get();
        if (msg == null) {
            msg = new ClientCacheChangeDiscoveryMessage(startedCaches, closedCaches);
            this.clientCacheChanges.set(msg);
        } else {
            msg.merge(startedCaches, closedCaches);
            if (msg.empty()) {
                this.cctx.time().removeTimeoutObject(msg.updateTimeoutObject());
                this.clientCacheChanges.remove();
                return;
            }
        }
        if (msg.updateTimeoutObject() != null) {
            this.cctx.time().removeTimeoutObject(msg.updateTimeoutObject());
        }
        if ((timeout = this.clientCacheMsgTimeout) <= 0L) {
            timeout = 10000L;
        }
        ClientCacheUpdateTimeout timeoutObj = new ClientCacheUpdateTimeout(this.cctx, timeout);
        msg.updateTimeoutObject(timeoutObj);
        this.cctx.time().addTimeoutObject(timeoutObj);
    }

    public void onCustomMessageNoAffinityChange(GridDhtPartitionsExchangeFuture fut, final @Nullable ExchangeActions exchActions) {
        final ExchangeDiscoveryEvents evts = fut.context().events();
        this.forAllCacheGroups(new IgniteInClosureX<GridAffinityAssignmentCache>(){

            @Override
            public void applyx(GridAffinityAssignmentCache aff) {
                if (exchActions != null && exchActions.cacheGroupStopping(aff.groupId())) {
                    return;
                }
                aff.clientEventTopologyChange(evts.lastEvent(), evts.topologyVersion());
                CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
            }
        });
    }

    public void stopCacheOnReconnect(GridCacheContext cctx) {
        this.cachesRegistry.unregisterCache(cctx.cacheId());
    }

    public void stopCacheGroupOnReconnect(CacheGroupContext grpCtx) {
        this.cachesRegistry.unregisterGroup(grpCtx.groupId());
    }

    public void removeGroupHolders() {
        Iterator it = this.grpHolders.keySet().iterator();
        while (it.hasNext()) {
            int grpId = (Integer)it.next();
            it.remove();
            this.cctx.io().removeHandler(true, grpId, GridDhtAffinityAssignmentResponse.class);
        }
        assert (this.grpHolders.isEmpty());
    }

    public void forceCloseCaches(GridDhtPartitionsExchangeFuture fut, boolean crd, ExchangeActions exchActions) {
        assert (exchActions != null && !exchActions.empty() && exchActions.cacheStartRequests().isEmpty()) : exchActions;
        IgniteInternalFuture<?> res = this.cachesRegistry.update(exchActions);
        assert (res.isDone()) : "There should be no caches to start: " + exchActions;
        this.processCacheStopRequests(fut, crd, exchActions, true);
        this.cctx.cache().forceCloseCaches(exchActions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> onCacheChangeRequest(GridDhtPartitionsExchangeFuture fut, boolean crd, ExchangeActions exchActions) throws IgniteCheckedException {
        ClientCacheChangeDiscoveryMessage msg;
        assert (exchActions != null && !exchActions.empty()) : exchActions;
        IgniteInternalFuture<?> res = this.cachesRegistry.update(exchActions);
        for (ExchangeActions.CacheActionData d : exchActions.cacheStartRequests()) {
            this.cctx.coordinators().validateCacheConfiguration(d.descriptor().cacheConfiguration());
        }
        this.onCustomMessageNoAffinityChange(fut, exchActions);
        fut.timeBag().finishGlobalStage("Update caches registry");
        this.processCacheStartRequests(fut, crd, exchActions);
        Set<Integer> stoppedGrps = this.processCacheStopRequests(fut, crd, exchActions, false);
        if (stoppedGrps != null) {
            AffinityTopologyVersion notifyTopVer = null;
            Object object = this.mux;
            synchronized (object) {
                if (this.waitInfo != null) {
                    for (Integer grpId : stoppedGrps) {
                        boolean rmv = this.waitInfo.waitGrps.remove(grpId) != null;
                        if (!rmv) continue;
                        notifyTopVer = this.waitInfo.topVer;
                        this.waitInfo.assignments.remove(grpId);
                    }
                }
            }
            if (notifyTopVer != null) {
                final AffinityTopologyVersion topVer = notifyTopVer;
                this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                    @Override
                    public void run() {
                        CacheAffinitySharedManager.this.onCacheGroupStopped(topVer);
                    }
                });
            }
        }
        if ((msg = this.clientCacheChanges.get()) != null) {
            msg.checkCachesExist(this.cachesRegistry.allCaches().keySet());
            if (msg.empty()) {
                this.clientCacheChanges.remove();
            }
        }
        return res;
    }

    private void processCacheStartRequests(GridDhtPartitionsExchangeFuture fut, boolean crd, ExchangeActions exchActions) throws IgniteCheckedException {
        assert (exchActions != null && !exchActions.empty()) : exchActions;
        ExchangeDiscoveryEvents evts = fut.context().events();
        LinkedHashMap<StartCacheInfo, DynamicCacheChangeRequest> startCacheInfos = new LinkedHashMap<StartCacheInfo, DynamicCacheChangeRequest>();
        for (ExchangeActions.CacheActionData cacheActionData : exchActions.cacheStartRequests()) {
            boolean startCache;
            DynamicCacheDescriptor dynamicCacheDescriptor = cacheActionData.descriptor();
            DynamicCacheChangeRequest req = cacheActionData.request();
            NearCacheConfiguration nearCfg = null;
            if (req.locallyConfigured() || this.cctx.localNodeId().equals(req.initiatingNodeId()) && !exchActions.activate()) {
                startCache = true;
                nearCfg = req.nearCacheConfiguration();
            } else {
                assert (this.cctx.cacheContext(dynamicCacheDescriptor.cacheId()) == null) : "Starting cache has not null context: " + dynamicCacheDescriptor.cacheName();
                IgniteCacheProxyImpl<?, ?> cacheProxy = this.cctx.cache().jcacheProxy(req.cacheName(), false);
                if (cacheProxy != null) {
                    assert (cacheProxy.isRestarting()) : "Cache has non restarting proxy " + cacheProxy;
                    startCache = true;
                } else {
                    startCache = CU.affinityNode(this.cctx.localNode(), dynamicCacheDescriptor.groupDescriptor().config().getNodeFilter());
                }
            }
            if (startCache) {
                startCacheInfos.put(new StartCacheInfo(req.startCacheConfiguration(), dynamicCacheDescriptor, nearCfg, evts.topologyVersion(), req.disabledAfterStart()), req);
                continue;
            }
            this.cctx.kernalContext().query().initQueryStructuresForNotStartedCache(dynamicCacheDescriptor);
        }
        Map<StartCacheInfo, IgniteCheckedException> failedCaches = this.cctx.cache().prepareStartCachesIfPossible(startCacheInfos.keySet());
        for (Map.Entry<StartCacheInfo, IgniteCheckedException> entry : failedCaches.entrySet()) {
            if (this.cctx.localNode().isClient()) {
                U.error(this.log, "Failed to initialize cache. Will try to rollback cache start routine. [cacheName=" + entry.getKey().getStartedConfiguration().getName() + ']', entry.getValue());
                this.cctx.cache().closeCaches(Collections.singleton(entry.getKey().getStartedConfiguration().getName()), false);
                this.cctx.cache().completeCacheStartFuture((DynamicCacheChangeRequest)startCacheInfos.get(entry.getKey()), false, entry.getValue());
                continue;
            }
            throw entry.getValue();
        }
        Set<StartCacheInfo> set = failedCaches.keySet();
        List list = startCacheInfos.keySet().stream().filter(set::contains).collect(Collectors.toList());
        for (StartCacheInfo info : list) {
            if (!fut.cacheAddedOnExchange(info.getCacheDescriptor().cacheId(), info.getCacheDescriptor().receivedFrom()) || !fut.events().discoveryCache().cacheGroupAffinityNodes(info.getCacheDescriptor().groupId()).isEmpty()) continue;
            U.quietAndWarn(this.log, "No server nodes found for cache client: " + info.getCacheDescriptor().cacheName());
        }
        fut.timeBag().finishGlobalStage("Start caches");
        this.initAffinityOnCacheGroupsStart(fut, exchActions, crd);
        fut.timeBag().finishGlobalStage("Affinity initialization on cache group start");
    }

    private void initAffinityOnCacheGroupsStart(GridDhtPartitionsExchangeFuture fut, ExchangeActions exchangeActions, boolean crd) throws IgniteCheckedException {
        List startedGroups = exchangeActions.cacheStartRequests().stream().map(action -> action.descriptor().groupDescriptor()).distinct().collect(Collectors.toList());
        U.doInParallel(this.cctx.kernalContext().getSystemExecutorService(), startedGroups, grpDesc -> {
            this.initStartedGroup(fut, (CacheGroupDescriptor)grpDesc, crd);
            fut.timeBag().finishLocalStage("Affinity initialization on cache group start [grp=" + grpDesc.cacheOrGroupName() + "]");
            this.validator.validateCacheGroup((CacheGroupDescriptor)grpDesc);
            return null;
        });
    }

    private Set<Integer> processCacheStopRequests(GridDhtPartitionsExchangeFuture fut, boolean crd, ExchangeActions exchActions, boolean forceClose) {
        assert (exchActions != null && !exchActions.empty()) : exchActions;
        for (ExchangeActions.CacheActionData cacheActionData : exchActions.cacheStopRequests()) {
            this.cctx.cache().blockGateway(cacheActionData.request().cacheName(), true, cacheActionData.request().restart());
        }
        for (ExchangeActions.CacheGroupActionData cacheGroupActionData : exchActions.cacheGroupsToStop()) {
            this.cctx.exchange().clearClientTopology(cacheGroupActionData.descriptor().groupId());
        }
        HashSet<Integer> stoppedGrps = null;
        for (ExchangeActions.CacheGroupActionData data : exchActions.cacheGroupsToStop()) {
            if (data.descriptor().config().getCacheMode() == CacheMode.LOCAL) continue;
            CacheGroupHolder cacheGrp = (CacheGroupHolder)this.grpHolders.remove(data.descriptor().groupId());
            assert (!crd || cacheGrp != null || forceClose) : data.descriptor();
            if (cacheGrp == null) continue;
            if (stoppedGrps == null) {
                stoppedGrps = new HashSet<Integer>();
            }
            stoppedGrps.add(cacheGrp.groupId());
            this.cctx.io().removeHandler(true, cacheGrp.groupId(), GridDhtAffinityAssignmentResponse.class);
        }
        return stoppedGrps;
    }

    public void clearGroupHoldersAndRegistry() {
        this.grpHolders.clear();
        this.cachesRegistry.unregisterAll();
    }

    public void onExchangeChangeAffinityMessage(final GridDhtPartitionsExchangeFuture exchFut, CacheAffinityChangeMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Process exchange affinity change message [exchVer=" + exchFut.initialVersion() + ", msg=" + msg + ']');
        }
        assert (exchFut.exchangeId().equals(msg.exchangeId())) : msg;
        final AffinityTopologyVersion topVer = exchFut.initialVersion();
        final Map<Integer, Map<Integer, List<UUID>>> assignment = msg.assignmentChange();
        assert (assignment != null);
        this.forAllCacheGroups(new IgniteInClosureX<GridAffinityAssignmentCache>(){

            @Override
            public void applyx(GridAffinityAssignmentCache aff) {
                List<List<ClusterNode>> newAssignment;
                List<List<ClusterNode>> idealAssignment = aff.idealAssignmentRaw();
                assert (idealAssignment != null);
                Map cacheAssignment = (Map)assignment.get(aff.groupId());
                if (cacheAssignment != null) {
                    newAssignment = new ArrayList<List<ClusterNode>>(idealAssignment);
                    for (Map.Entry e : cacheAssignment.entrySet()) {
                        newAssignment.set((Integer)e.getKey(), CacheAffinitySharedManager.this.toNodes(topVer, (List)e.getValue()));
                    }
                } else {
                    newAssignment = idealAssignment;
                }
                aff.initialize(topVer, newAssignment);
                exchFut.timeBag().finishLocalStage("Affinity recalculate by change affinity message [grp=" + aff.cacheOrGroupName() + "]");
            }
        });
    }

    public void onChangeAffinityMessage(final GridDhtPartitionsExchangeFuture exchFut, CacheAffinityChangeMessage msg) {
        assert (msg.topologyVersion() != null && msg.exchangeId() == null) : msg;
        assert (msg.partitionsMessage() == null) : msg;
        assert (msg.assignmentChange() == null) : msg;
        final AffinityTopologyVersion topVer = exchFut.initialVersion();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Process affinity change message [exchVer=" + topVer + ", msgVer=" + msg.topologyVersion() + ']');
        }
        final Map<Integer, IgniteUuid> deploymentIds = msg.cacheDeploymentIds();
        this.forAllCacheGroups(new IgniteInClosureX<GridAffinityAssignmentCache>(){

            @Override
            public void applyx(GridAffinityAssignmentCache aff) {
                AffinityTopologyVersion affTopVer = aff.lastVersion();
                assert (affTopVer.topologyVersion() > 0L) : affTopVer;
                CacheGroupDescriptor desc = CacheAffinitySharedManager.this.cachesRegistry.group(aff.groupId());
                assert (desc != null) : aff.cacheOrGroupName();
                IgniteUuid deploymentId = desc.deploymentId();
                if (!deploymentId.equals(deploymentIds.get(aff.groupId()))) {
                    aff.clientEventTopologyChange(exchFut.firstEvent(), topVer);
                    return;
                }
                if (!aff.partitionPrimariesDifferentToIdeal(affTopVer).isEmpty()) {
                    aff.initialize(topVer, aff.idealAssignmentRaw());
                } else {
                    if (!aff.assignments(aff.lastVersion()).equals(aff.idealAssignmentRaw())) {
                        throw new AssertionError((Object)("Not an ideal distribution duplication attempt on LAA [grp=" + aff.cacheOrGroupName() + ", lastAffinity=" + aff.lastVersion() + ", cacheAffinity=" + aff.cachedVersions() + "]"));
                    }
                    aff.clientEventTopologyChange(exchFut.firstEvent(), topVer);
                }
                CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
                exchFut.timeBag().finishLocalStage("Affinity change by custom message [grp=" + aff.cacheOrGroupName() + "]");
            }
        });
    }

    public void onClientEvent(final GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        boolean locJoin = fut.firstEvent().eventNode().isLocal();
        if (!locJoin) {
            this.forAllCacheGroups(new IgniteInClosureX<GridAffinityAssignmentCache>(){

                @Override
                public void applyx(GridAffinityAssignmentCache aff) throws IgniteCheckedException {
                    AffinityTopologyVersion topVer = fut.initialVersion();
                    aff.clientEventTopologyChange(fut.firstEvent(), topVer);
                    CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
                }
            });
        } else {
            this.fetchAffinityOnJoin(fut);
        }
    }

    public void addDhtAssignmentFetchFuture(GridDhtAssignmentFetchFuture fut) {
        GridDhtAssignmentFetchFuture old = this.pendingAssignmentFetchFuts.putIfAbsent(fut.id(), fut);
        assert (old == null) : "More than one thread is trying to fetch partition assignments [fut=" + fut + ", allFuts=" + this.pendingAssignmentFetchFuts + ']';
    }

    public void removeDhtAssignmentFetchFuture(GridDhtAssignmentFetchFuture fut) {
        boolean rmv = this.pendingAssignmentFetchFuts.remove(fut.id(), fut);
        assert (rmv) : "Failed to remove assignment fetch future: " + fut.id();
    }

    private void processAffinityAssignmentResponse(UUID nodeId, GridDhtAffinityAssignmentResponse res) {
        GridDhtAssignmentFetchFuture fut;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing affinity assignment response [node=" + nodeId + ", res=" + res + ']');
        }
        if ((fut = (GridDhtAssignmentFetchFuture)this.pendingAssignmentFetchFuts.get(res.futureId())) != null) {
            fut.onResponse(nodeId, res);
        }
    }

    private void forAllRegisteredCacheGroups(IgniteInClosureX<CacheGroupDescriptor> c) {
        Collection affinityCaches = this.cachesRegistry.allGroups().values().stream().filter(desc -> desc.config().getCacheMode() != CacheMode.LOCAL).collect(Collectors.toList());
        try {
            U.doInParallel(this.cctx.kernalContext().getSystemExecutorService(), affinityCaches, t -> {
                c.applyx((CacheGroupDescriptor)t);
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to execute affinity operation on cache groups", e);
        }
    }

    private void forAllCacheGroups(IgniteInClosureX<GridAffinityAssignmentCache> c) {
        Collection affinityCaches = this.grpHolders.values().stream().map(CacheGroupHolder::affinity).collect(Collectors.toList());
        try {
            U.doInParallel(this.cctx.kernalContext().getSystemExecutorService(), affinityCaches, t -> {
                c.applyx((GridAffinityAssignmentCache)t);
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to execute affinity operation on cache groups", e);
        }
    }

    private void initStartedGroup(GridDhtPartitionsExchangeFuture fut, CacheGroupDescriptor grpDesc, boolean crd) throws IgniteCheckedException {
        assert (grpDesc != null && grpDesc.groupId() != 0) : grpDesc;
        if (grpDesc.config().getCacheMode() == CacheMode.LOCAL) {
            return;
        }
        int grpId = grpDesc.groupId();
        CacheGroupHolder grpHolder = (CacheGroupHolder)this.grpHolders.get(grpId);
        CacheGroupContext grp = this.cctx.kernalContext().cache().cacheGroup(grpId);
        if (grpHolder != null && grpHolder.nonAffNode() && grp != null) {
            assert (grpHolder.affinity().idealAssignmentRaw() != null);
            grpHolder = new CacheGroupAffNodeHolder(grp, grpHolder.affinity());
            this.grpHolders.put(grpId, grpHolder);
        } else if (grpHolder == null) {
            grpHolder = this.getOrCreateGroupHolder(fut.initialVersion(), grpDesc);
            this.calculateAndInit(fut.events(), grpHolder.affinity(), fut.initialVersion());
        } else if (!crd && grp != null && grp.localStartVersion().equals(fut.initialVersion())) {
            this.initAffinity(this.cachesRegistry.group(grp.groupId()), grp.affinity(), fut);
        }
    }

    public IgniteInternalFuture<?> initStartedCaches(final boolean crd, final GridDhtPartitionsExchangeFuture fut, Collection<DynamicCacheDescriptor> descs) throws IgniteCheckedException {
        IgniteInternalFuture<?> res = this.cachesRegistry.addUnregistered(descs);
        for (DynamicCacheDescriptor d : descs) {
            this.cctx.coordinators().validateCacheConfiguration(d.cacheConfiguration());
        }
        if (fut.context().mergeExchanges()) {
            return res;
        }
        this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

            @Override
            public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                CacheGroupHolder cache = CacheAffinitySharedManager.this.getOrCreateGroupHolder(fut.initialVersion(), desc);
                if (cache.affinity().lastVersion().equals(AffinityTopologyVersion.NONE)) {
                    CacheAffinitySharedManager.this.initAffinity(desc, cache.affinity(), fut);
                    CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
                    fut.timeBag().finishLocalStage("Affinity initialization (new cache) [grp=" + desc.cacheOrGroupName() + ", crd=" + crd + "]");
                }
            }
        });
        return res;
    }

    private void initAffinity(CacheGroupDescriptor desc, GridAffinityAssignmentCache aff, GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        assert (desc != null) : aff.cacheOrGroupName();
        ExchangeDiscoveryEvents evts = fut.context().events();
        if (this.canCalculateAffinity(desc, aff, fut)) {
            this.calculateAndInit(evts, aff, evts.topologyVersion());
        } else {
            GridDhtAssignmentFetchFuture fetchFut = new GridDhtAssignmentFetchFuture(this.cctx, desc.groupId(), evts.topologyVersion(), evts.discoveryCache());
            fetchFut.init(false);
            this.fetchAffinity(evts.topologyVersion(), evts, evts.discoveryCache(), aff, fetchFut);
        }
    }

    private boolean canCalculateAffinity(CacheGroupDescriptor desc, GridAffinityAssignmentCache aff, GridDhtPartitionsExchangeFuture fut) {
        assert (desc != null) : aff.cacheOrGroupName();
        if (!aff.centralizedAffinityFunction()) {
            return true;
        }
        List<ClusterNode> affNodes = fut.events().discoveryCache().cacheGroupAffinityNodes(aff.groupId());
        return fut.cacheGroupAddedOnExchange(aff.groupId(), desc.receivedFrom()) || !fut.exchangeId().nodeId().equals(this.cctx.localNodeId()) || affNodes.isEmpty() || affNodes.size() == 1 && affNodes.contains(this.cctx.localNode());
    }

    public GridAffinityAssignmentCache affinity(Integer grpId) {
        CacheGroupHolder grpHolder = (CacheGroupHolder)this.grpHolders.get(grpId);
        assert (grpHolder != null) : this.debugGroupName(grpId);
        return grpHolder.affinity();
    }

    public void applyAffinityFromFullMessage(final GridDhtPartitionsExchangeFuture fut, final Map<Integer, CacheGroupAffinityMessage> idealAffDiff) {
        final ConcurrentHashMap nodesByOrder = new ConcurrentHashMap();
        this.forAllCacheGroups(new IgniteInClosureX<GridAffinityAssignmentCache>(){

            @Override
            public void applyx(GridAffinityAssignmentCache aff) {
                List<List<ClusterNode>> newAssignment;
                CacheGroupAffinityMessage affMsg;
                ExchangeDiscoveryEvents evts = fut.context().events();
                List<List<ClusterNode>> idealAssignment = aff.calculate(evts.topologyVersion(), evts, evts.discoveryCache()).assignment();
                CacheGroupAffinityMessage cacheGroupAffinityMessage = affMsg = idealAffDiff != null ? (CacheGroupAffinityMessage)idealAffDiff.get(aff.groupId()) : null;
                if (affMsg != null) {
                    Map<Integer, GridLongList> diff = affMsg.assignmentsDiff();
                    assert (!F.isEmpty(diff));
                    newAssignment = new ArrayList<List<ClusterNode>>(idealAssignment);
                    for (Map.Entry<Integer, GridLongList> e : diff.entrySet()) {
                        GridLongList assign = e.getValue();
                        newAssignment.set(e.getKey(), CacheGroupAffinityMessage.toNodes(assign, nodesByOrder, evts.discoveryCache()));
                    }
                } else {
                    newAssignment = idealAssignment;
                }
                aff.initialize(evts.topologyVersion(), newAssignment);
                fut.timeBag().finishLocalStage("Affinity applying from full message [grp=" + aff.cacheOrGroupName() + "]");
            }
        });
    }

    public Set<Integer> onLocalJoin(final GridDhtPartitionsExchangeFuture fut, final Map<Integer, CacheGroupAffinityMessage> receivedAff, final AffinityTopologyVersion resTopVer) {
        final Set<Integer> affReq = fut.context().groupsAffinityRequestOnJoin();
        final ConcurrentHashMap nodesByOrder = new ConcurrentHashMap();
        final GridConcurrentHashSet<Integer> noAffinityGroups = new GridConcurrentHashSet<Integer>();
        this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

            @Override
            public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                ExchangeDiscoveryEvents evts = fut.context().events();
                CacheGroupHolder holder = CacheAffinitySharedManager.this.getOrCreateGroupHolder(fut.initialVersion(), desc);
                GridAffinityAssignmentCache aff = holder.affinity();
                CacheGroupContext grp = CacheAffinitySharedManager.this.cctx.cache().cacheGroup(holder.groupId());
                if (affReq != null && affReq.contains(aff.groupId())) {
                    assert (resTopVer.compareTo(aff.lastVersion()) >= 0) : aff.lastVersion();
                    CacheGroupAffinityMessage affMsg = (CacheGroupAffinityMessage)receivedAff.get(aff.groupId());
                    if (affMsg == null) {
                        noAffinityGroups.add(aff.groupId());
                        CacheAffinitySharedManager.this.calculateAndInit(evts, aff, evts.topologyVersion());
                        return;
                    }
                    List<List<ClusterNode>> assignments = affMsg.createAssignments(nodesByOrder, evts.discoveryCache());
                    assert (resTopVer.equals(evts.topologyVersion())) : "resTopVer=" + resTopVer + ", evts.topVer=" + evts.topologyVersion();
                    List<List<ClusterNode>> idealAssign = affMsg.createIdealAssignments(nodesByOrder, evts.discoveryCache());
                    if (idealAssign != null) {
                        aff.idealAssignment(evts.topologyVersion(), idealAssign);
                    } else {
                        assert (!aff.centralizedAffinityFunction()) : aff;
                        aff.calculate(evts.topologyVersion(), evts, evts.discoveryCache());
                    }
                    aff.initialize(evts.topologyVersion(), assignments);
                } else if (grp != null && fut.cacheGroupAddedOnExchange(aff.groupId(), grp.receivedFrom())) {
                    CacheAffinitySharedManager.this.calculateAndInit(evts, aff, evts.topologyVersion());
                }
                if (grp != null) {
                    grp.topology().initPartitionsWhenAffinityReady(resTopVer, fut);
                }
                fut.timeBag().finishLocalStage("Affinity initialization (local join) [grp=" + aff.cacheOrGroupName() + "]");
            }
        });
        return noAffinityGroups;
    }

    public void onServerJoinWithExchangeMergeProtocol(GridDhtPartitionsExchangeFuture fut, boolean crd) {
        ExchangeDiscoveryEvents evts = fut.context().events();
        assert (fut.context().mergeExchanges());
        assert (evts.hasServerJoin() && !evts.hasServerLeft());
        this.initAffinityOnNodeJoin(fut, crd);
    }

    public Map<Integer, CacheGroupAffinityMessage> onServerLeftWithExchangeMergeProtocol(GridDhtPartitionsExchangeFuture fut) {
        ExchangeDiscoveryEvents evts = fut.context().events();
        assert (fut.context().mergeExchanges());
        assert (evts.hasServerLeft());
        return this.onReassignmentEnforced(fut);
    }

    public void onExchangeFreeSwitch(final GridDhtPartitionsExchangeFuture fut) {
        assert (fut.events().hasServerLeft() && !fut.firstEvent().eventNode().isClient()) : fut.firstEvent();
        assert (!fut.context().mergeExchanges());
        final ExchangeDiscoveryEvents evts = fut.context().events();
        this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

            @Override
            public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                AffinityTopologyVersion topVer = evts.topologyVersion();
                CacheGroupHolder cache = CacheAffinitySharedManager.this.getOrCreateGroupHolder(topVer, desc);
                CacheAffinitySharedManager.this.calculateAndInit(evts, cache.affinity(), topVer);
                fut.timeBag().finishLocalStage("Affinity initialization (exchange-free switch on fully-rebalanced topology) [grp=" + desc.cacheOrGroupName() + "]");
            }
        });
    }

    @Nullable
    private List<ClusterNode> selectCurrentAliveOwners(Set<ClusterNode> aliveNodes, List<ClusterNode> curOwners) {
        List<ClusterNode> aliveCurOwners = curOwners.stream().filter(aliveNodes::contains).collect(Collectors.toList());
        return !aliveCurOwners.isEmpty() ? aliveCurOwners : null;
    }

    public Map<Integer, CacheGroupAffinityMessage> onCustomEventWithEnforcedAffinityReassignment(GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        assert (DiscoveryCustomEvent.requiresCentralizedAffinityAssignment(fut.firstEvent()));
        Map<Integer, CacheGroupAffinityMessage> result = this.onReassignmentEnforced(fut);
        return result;
    }

    public Map<Integer, CacheGroupAffinityMessage> onReassignmentEnforced(final GridDhtPartitionsExchangeFuture fut) {
        final ExchangeDiscoveryEvents evts = fut.context().events();
        this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

            @Override
            public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                AffinityTopologyVersion topVer = evts.topologyVersion();
                CacheGroupHolder grpHolder = CacheAffinitySharedManager.this.getOrCreateGroupHolder(topVer, desc);
                if (grpHolder.affinity().lastVersion().equals(topVer)) {
                    return;
                }
                List<List<ClusterNode>> assign = grpHolder.affinity().calculate(topVer, evts, evts.discoveryCache()).assignment();
                if (!grpHolder.rebalanceEnabled || fut.cacheGroupAddedOnExchange(desc.groupId(), desc.receivedFrom())) {
                    grpHolder.affinity().initialize(topVer, assign);
                }
                fut.timeBag().finishLocalStage("Affinity initialization (enforced) [grp=" + desc.cacheOrGroupName() + "]");
            }
        });
        Map<Integer, Map<Integer, List<Long>>> diff = this.initAffinityBasedOnPartitionsAvailability(evts.topologyVersion(), fut, NODE_TO_ORDER, true);
        return CacheGroupAffinityMessage.createAffinityDiffMessages(diff);
    }

    public void onServerJoin(final GridDhtPartitionsExchangeFuture fut, final boolean crd) throws IgniteCheckedException {
        assert (!fut.firstEvent().eventNode().isClient());
        boolean locJoin = fut.firstEvent().eventNode().isLocal();
        if (locJoin) {
            this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

                @Override
                public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                    AffinityTopologyVersion topVer = fut.initialVersion();
                    CacheGroupHolder grpHolder = CacheAffinitySharedManager.this.getOrCreateGroupHolder(topVer, desc);
                    if (crd) {
                        CacheAffinitySharedManager.this.calculateAndInit(fut.events(), grpHolder.affinity(), topVer);
                        CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
                        fut.timeBag().finishLocalStage("First node affinity initialization (node join) [grp=" + desc.cacheOrGroupName() + "]");
                    }
                }
            });
            if (!crd) {
                this.fetchAffinityOnJoin(fut);
                fut.timeBag().finishLocalStage("Affinity fetch");
            }
        } else {
            this.initAffinityOnNodeJoin(fut, crd);
        }
    }

    public void onBaselineTopologyChanged(GridDhtPartitionsExchangeFuture fut, boolean crd) {
        assert (!fut.firstEvent().eventNode().isClient());
        this.initAffinityOnNodeJoin(fut, crd);
    }

    private String groupNames(Collection<Integer> grpIds) {
        StringBuilder names = new StringBuilder();
        for (Integer grpId : grpIds) {
            String name = this.cachesRegistry.group(grpId).cacheOrGroupName();
            if (names.length() != 0) {
                names.append(", ");
            }
            names.append(name);
        }
        return names.toString();
    }

    private String debugGroupName(int grpId) {
        CacheGroupDescriptor desc = this.cachesRegistry.group(grpId);
        if (desc != null) {
            return desc.cacheOrGroupName();
        }
        return "Unknown group: " + grpId;
    }

    private void calculateAndInit(ExchangeDiscoveryEvents evts, GridAffinityAssignmentCache aff, AffinityTopologyVersion topVer) {
        List<List<ClusterNode>> assignment = aff.calculate(topVer, evts, evts.discoveryCache()).assignment();
        aff.initialize(topVer, assignment);
    }

    private void fetchAffinityOnJoin(final GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        final AffinityTopologyVersion topVer = fut.initialVersion();
        final List fetchFuts = Collections.synchronizedList(new ArrayList());
        this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

            @Override
            public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                CacheGroupHolder holder = CacheAffinitySharedManager.this.getOrCreateGroupHolder(topVer, desc);
                if (fut.cacheGroupAddedOnExchange(desc.groupId(), desc.receivedFrom())) {
                    if (!fut.context().mergeExchanges()) {
                        CacheAffinitySharedManager.this.calculateAndInit(fut.events(), holder.affinity(), topVer);
                    }
                } else if (fut.context().fetchAffinityOnJoin()) {
                    GridDhtAssignmentFetchFuture fetchFut = new GridDhtAssignmentFetchFuture(CacheAffinitySharedManager.this.cctx, desc.groupId(), topVer, fut.events().discoveryCache());
                    fetchFut.init(false);
                    fetchFuts.add(fetchFut);
                } else if (!fut.events().discoveryCache().serverNodes().isEmpty()) {
                    fut.context().addGroupAffinityRequestOnJoin(desc.groupId());
                } else {
                    CacheAffinitySharedManager.this.calculateAndInit(fut.events(), holder.affinity(), topVer);
                }
                CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
            }
        });
        for (int i = 0; i < fetchFuts.size(); ++i) {
            GridDhtAssignmentFetchFuture fetchFut = (GridDhtAssignmentFetchFuture)fetchFuts.get(i);
            int grpId = fetchFut.groupId();
            this.fetchAffinity(topVer, fut.events(), fut.events().discoveryCache(), this.groupAffinity(grpId), fetchFut);
            this.cctx.exchange().exchangerUpdateHeartbeat();
        }
    }

    private GridDhtAffinityAssignmentResponse fetchAffinity(AffinityTopologyVersion topVer, @Nullable ExchangeDiscoveryEvents events, DiscoCache discoCache, GridAffinityAssignmentCache affCache, GridDhtAssignmentFetchFuture fetchFut) throws IgniteCheckedException {
        assert (affCache != null);
        GridDhtAffinityAssignmentResponse res = (GridDhtAffinityAssignmentResponse)fetchFut.get();
        if (res == null) {
            List<List<ClusterNode>> aff = affCache.calculate(topVer, events, discoCache).assignment();
            affCache.initialize(topVer, aff);
        } else {
            List<List<ClusterNode>> idealAff = res.idealAffinityAssignment(discoCache);
            if (idealAff != null) {
                affCache.idealAssignment(topVer, idealAff);
            } else {
                assert (!affCache.centralizedAffinityFunction());
                affCache.calculate(topVer, events, discoCache);
            }
            List<List<ClusterNode>> aff = res.affinityAssignment(discoCache);
            assert (aff != null) : res;
            affCache.initialize(topVer, aff);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onCentralizedAffinityChange(final GridDhtPartitionsExchangeFuture fut, final boolean crd) throws IgniteCheckedException {
        assert (fut.events().hasServerLeft() && !fut.firstEvent().eventNode().isClient() || DiscoveryCustomEvent.requiresCentralizedAffinityAssignment(fut.firstEvent())) : fut.firstEvent();
        this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

            @Override
            public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                CacheGroupHolder cache = CacheAffinitySharedManager.this.getOrCreateGroupHolder(fut.initialVersion(), desc);
                cache.aff.calculate(fut.initialVersion(), fut.events(), fut.events().discoveryCache());
                CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
                fut.timeBag().finishLocalStage("Affinity centralized initialization (crd) [grp=" + desc.cacheOrGroupName() + ", crd=" + crd + "]");
                CacheAffinitySharedManager.this.validator.validateCacheGroup(desc);
            }
        });
        Object object = this.mux;
        synchronized (object) {
            this.waitInfo = null;
        }
        return true;
    }

    public IgniteInternalFuture<?> initCoordinatorCaches(final GridDhtPartitionsExchangeFuture fut, final boolean newAff) throws IgniteCheckedException {
        boolean locJoin = fut.firstEvent().eventNode().isLocal();
        if (!locJoin) {
            return null;
        }
        final List<IgniteInternalFuture> futs = Collections.synchronizedList(new ArrayList());
        final AffinityTopologyVersion topVer = fut.initialVersion();
        this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

            @Override
            public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                CacheGroupHolder grpHolder = CacheAffinitySharedManager.this.getOrCreateGroupHolder(topVer, desc);
                if (grpHolder.affinity().idealAssignmentRaw() != null) {
                    return;
                }
                int grpId = desc.groupId();
                CacheGroupContext grp = CacheAffinitySharedManager.this.cctx.cache().cacheGroup(grpId);
                if (grp == null) {
                    grpHolder = CacheAffinitySharedManager.this.createHolder(CacheAffinitySharedManager.this.cctx, desc, topVer, null);
                    final GridAffinityAssignmentCache aff = grpHolder.affinity();
                    if (newAff) {
                        if (!aff.lastVersion().equals(topVer)) {
                            CacheAffinitySharedManager.this.calculateAndInit(fut.events(), aff, topVer);
                        }
                        grpHolder.topology(fut.context().events().discoveryCache()).beforeExchange(fut, true, false);
                    } else {
                        List<GridDhtPartitionsExchangeFuture> exchFuts = CacheAffinitySharedManager.this.cctx.exchange().exchangeFutures();
                        int idx = exchFuts.indexOf(fut);
                        assert (idx >= 0 && idx < exchFuts.size() - 1) : "Invalid exchange futures state [cur=" + idx + ", total=" + exchFuts.size() + ']';
                        GridDhtPartitionsExchangeFuture futureToFetchAffinity = null;
                        for (int i = idx + 1; i < exchFuts.size(); ++i) {
                            GridDhtPartitionsExchangeFuture prev = exchFuts.get(i);
                            assert (prev.isDone() && prev.topologyVersion().compareTo(topVer) < 0);
                            if (prev.isMerged()) continue;
                            futureToFetchAffinity = prev;
                            break;
                        }
                        if (futureToFetchAffinity == null) {
                            throw new IgniteCheckedException("Failed to find completed exchange future to fetch affinity.");
                        }
                        if (CacheAffinitySharedManager.this.log.isDebugEnabled()) {
                            CacheAffinitySharedManager.this.log.debug("Need initialize affinity on coordinator [cacheGrp=" + desc.cacheOrGroupName() + "prevAff=" + futureToFetchAffinity.topologyVersion() + ']');
                        }
                        GridDhtAssignmentFetchFuture fetchFut = new GridDhtAssignmentFetchFuture(CacheAffinitySharedManager.this.cctx, desc.groupId(), futureToFetchAffinity.topologyVersion(), futureToFetchAffinity.events().discoveryCache());
                        fetchFut.init(false);
                        final GridFutureAdapter affFut = new GridFutureAdapter();
                        final GridDhtPartitionsExchangeFuture futureToFetchAffinity0 = futureToFetchAffinity;
                        fetchFut.listen(new IgniteInClosureX<IgniteInternalFuture<GridDhtAffinityAssignmentResponse>>(){

                            @Override
                            public void applyx(IgniteInternalFuture<GridDhtAffinityAssignmentResponse> fetchFut) throws IgniteCheckedException {
                                CacheAffinitySharedManager.this.fetchAffinity(futureToFetchAffinity0.topologyVersion(), futureToFetchAffinity0.events(), futureToFetchAffinity0.events().discoveryCache(), aff, (GridDhtAssignmentFetchFuture)fetchFut);
                                aff.calculate(topVer, fut.events(), fut.events().discoveryCache());
                                affFut.onDone(topVer);
                                CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
                            }
                        });
                        futs.add(affFut);
                    }
                } else {
                    grpHolder = new CacheGroupAffNodeHolder(grp);
                    if (newAff) {
                        GridAffinityAssignmentCache aff = grpHolder.affinity();
                        if (!aff.lastVersion().equals(topVer)) {
                            CacheAffinitySharedManager.this.calculateAndInit(fut.events(), aff, topVer);
                        }
                        grpHolder.topology(fut.context().events().discoveryCache()).beforeExchange(fut, true, false);
                    }
                }
                CacheAffinitySharedManager.this.grpHolders.put(grpHolder.groupId(), grpHolder);
                CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
                fut.timeBag().finishLocalStage("Coordinator affinity cache init [grp=" + desc.cacheOrGroupName() + "]");
            }
        });
        if (!futs.isEmpty()) {
            GridCompoundFuture affFut = new GridCompoundFuture();
            for (IgniteInternalFuture f : futs) {
                affFut.add(f);
            }
            affFut.markInitialized();
            return affFut;
        }
        return null;
    }

    private CacheGroupHolder getOrCreateGroupHolder(AffinityTopologyVersion topVer, CacheGroupDescriptor desc) throws IgniteCheckedException {
        CacheGroupHolder cacheGrp = (CacheGroupHolder)this.grpHolders.get(desc.groupId());
        if (cacheGrp != null) {
            return cacheGrp;
        }
        return this.createGroupHolder(topVer, desc, this.cctx.cache().cacheGroup(desc.groupId()) != null);
    }

    private CacheGroupHolder createGroupHolder(AffinityTopologyVersion topVer, CacheGroupDescriptor desc, boolean affNode) throws IgniteCheckedException {
        assert (topVer != null);
        assert (desc != null);
        CacheGroupContext grp = this.cctx.cache().cacheGroup(desc.groupId());
        this.cctx.io().addCacheGroupHandler(desc.groupId(), GridDhtAffinityAssignmentResponse.class, this::processAffinityAssignmentResponse);
        assert (affNode && grp != null || !affNode && grp == null);
        CacheGroupAffNodeHolder cacheGrp = affNode ? new CacheGroupAffNodeHolder(grp) : this.createHolder(this.cctx, desc, topVer, null);
        CacheGroupHolder old = this.grpHolders.put(desc.groupId(), cacheGrp);
        assert (old == null) : old;
        return cacheGrp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAffinityOnNodeJoin(final GridDhtPartitionsExchangeFuture fut, final boolean crd) {
        final ExchangeDiscoveryEvents evts = fut.context().events();
        final WaitRebalanceInfo waitRebalanceInfo = new WaitRebalanceInfo(evts.lastServerEventVersion());
        this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

            @Override
            public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                CacheGroupHolder grpHolder = CacheAffinitySharedManager.this.getOrCreateGroupHolder(evts.topologyVersion(), desc);
                CacheGroupHolder cache = CacheAffinitySharedManager.this.getOrCreateGroupHolder(evts.topologyVersion(), desc);
                if (cache.affinity().lastVersion().equals(evts.topologyVersion())) {
                    return;
                }
                Span affCalcSpan = CacheAffinitySharedManager.this.cctx.kernalContext().tracing().create(SpanType.AFFINITY_CALCULATION, fut.span()).addTag("cache.group", desc::cacheOrGroupName);
                boolean latePrimary = cache.rebalanceEnabled;
                boolean grpAdded = evts.nodeJoined(desc.receivedFrom());
                CacheAffinitySharedManager.this.initAffinityOnNodeJoin(evts, grpAdded, grpHolder, crd ? waitRebalanceInfo : null, latePrimary);
                if (crd && grpAdded) {
                    AffinityAssignment aff = grpHolder.aff.cachedAffinity(grpHolder.aff.lastVersion());
                    assert (evts.topologyVersion().equals(aff.topologyVersion())) : "Unexpected version [grp=" + CacheGroupHolder.access$1200(grpHolder).cacheOrGroupName() + ", evts=" + evts.topologyVersion() + ", aff=" + CacheGroupHolder.access$1200(grpHolder).lastVersion() + ']';
                    Map map = CacheAffinitySharedManager.this.affinityFullMap(aff);
                    for (GridDhtPartitionMap map0 : map.values()) {
                        grpHolder.topology(fut.context().events().discoveryCache()).update(fut.exchangeId(), map0, true);
                    }
                }
                CacheAffinitySharedManager.this.cctx.exchange().exchangerUpdateHeartbeat();
                affCalcSpan.end();
                fut.timeBag().finishLocalStage("Affinity initialization (node join) [grp=" + desc.cacheOrGroupName() + ", crd=" + crd + "]");
            }
        });
        if (crd && this.log.isDebugEnabled()) {
            this.log.debug("Computed new affinity after node join [topVer=" + evts.lastServerEventVersion() + ", waitGrps=" + this.groupNames(waitRebalanceInfo.waitGrps.keySet()) + ']');
        }
        Object object = this.mux;
        synchronized (object) {
            this.waitInfo = !waitRebalanceInfo.empty() ? waitRebalanceInfo : null;
        }
    }

    private Map<UUID, GridDhtPartitionMap> affinityFullMap(AffinityAssignment aff) {
        HashMap<UUID, GridDhtPartitionMap> map = new HashMap<UUID, GridDhtPartitionMap>();
        for (int p = 0; p < aff.assignment().size(); ++p) {
            Collection<UUID> ids = aff.getIds(p);
            for (UUID nodeId : ids) {
                GridDhtPartitionMap partMap = (GridDhtPartitionMap)map.get(nodeId);
                if (partMap == null) {
                    partMap = new GridDhtPartitionMap(nodeId, 1L, aff.topologyVersion(), new GridPartitionStateMap(), false);
                    map.put(nodeId, partMap);
                }
                partMap.put(p, GridDhtPartitionState.OWNING);
            }
        }
        return map;
    }

    private void initAffinityOnNodeJoin(ExchangeDiscoveryEvents evts, boolean addedOnExchnage, CacheGroupHolder grpHolder, @Nullable WaitRebalanceInfo rebalanceInfo, boolean latePrimary) {
        GridAffinityAssignmentCache aff = grpHolder.affinity();
        if (addedOnExchnage) {
            if (!aff.lastVersion().equals(evts.topologyVersion())) {
                this.calculateAndInit(evts, aff, evts.topologyVersion());
            }
            return;
        }
        AffinityTopologyVersion affTopVer = aff.lastVersion();
        assert (affTopVer.topologyVersion() > 0L) : "Affinity is not initialized [grp=" + aff.cacheOrGroupName() + ", topVer=" + affTopVer + ", node=" + this.cctx.localNodeId() + ']';
        List<List<ClusterNode>> curAff = aff.assignments(affTopVer);
        assert (aff.idealAssignment() != null) : "Previous assignment is not available.";
        List<List<ClusterNode>> idealAssignment = aff.calculate(evts.topologyVersion(), evts, evts.discoveryCache()).assignment();
        List<List<ClusterNode>> newAssignment = null;
        if (latePrimary) {
            for (int p = 0; p < idealAssignment.size(); ++p) {
                List<ClusterNode> owners;
                ClusterNode newPrimary;
                List<ClusterNode> newNodes = idealAssignment.get(p);
                List<ClusterNode> curNodes = curAff.get(p);
                ClusterNode curPrimary = !curNodes.isEmpty() ? curNodes.get(0) : null;
                ClusterNode clusterNode = newPrimary = !newNodes.isEmpty() ? newNodes.get(0) : null;
                if (curPrimary != null && newPrimary != null && !curPrimary.equals(newPrimary)) {
                    assert (this.cctx.discovery().node(evts.topologyVersion(), curPrimary.id()) != null) : curPrimary;
                    List<ClusterNode> nodes0 = this.latePrimaryAssignment(aff, p, curPrimary, newNodes, rebalanceInfo);
                    if (newAssignment == null) {
                        newAssignment = new ArrayList<List<ClusterNode>>(idealAssignment);
                    }
                    newAssignment.set(p, nodes0);
                }
                GridDhtPartitionTopology top = grpHolder.topology(evts.discoveryCache());
                if (rebalanceInfo == null || (owners = top.owners(p, evts.topologyVersion())).isEmpty() || owners.containsAll((Collection)idealAssignment.get(p)) || top.lostPartitions().contains(p)) continue;
                rebalanceInfo.add(aff.groupId(), p, newNodes);
            }
        }
        if (newAssignment == null) {
            newAssignment = idealAssignment;
        }
        aff.initialize(evts.topologyVersion(), newAssignment);
    }

    private List<ClusterNode> latePrimaryAssignment(GridAffinityAssignmentCache aff, int part, ClusterNode curPrimary, List<ClusterNode> newNodes, @Nullable WaitRebalanceInfo rebalance) {
        assert (curPrimary != null);
        assert (!F.isEmpty(newNodes));
        assert (!curPrimary.equals(newNodes.get(0)));
        ArrayList<ClusterNode> nodes0 = new ArrayList<ClusterNode>(newNodes.size() + 1);
        nodes0.add(curPrimary);
        for (int i = 0; i < newNodes.size(); ++i) {
            ClusterNode node = newNodes.get(i);
            if (node.equals(curPrimary)) continue;
            nodes0.add(node);
        }
        if (rebalance != null) {
            rebalance.add(aff.groupId(), part, newNodes);
        }
        return nodes0;
    }

    public IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> initAffinityOnNodeLeft(final GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        assert (!fut.context().mergeExchanges());
        IgniteInternalFuture<?> initFut = this.initCoordinatorCaches(fut, false);
        if (initFut != null && !initFut.isDone()) {
            final GridFutureAdapter<Map<Integer, Map<Integer, List<UUID>>>> resFut = new GridFutureAdapter<Map<Integer, Map<Integer, List<UUID>>>>();
            initFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> initFut) {
                    try {
                        resFut.onDone(CacheAffinitySharedManager.this.initAffinityBasedOnPartitionsAvailability(fut.initialVersion(), fut, NODE_TO_ID, false));
                    }
                    catch (Exception e) {
                        resFut.onDone(e);
                    }
                }
            });
            return resFut;
        }
        return new GridFinishedFuture<Map<Integer, Map<Integer, List<UUID>>>>(this.initAffinityBasedOnPartitionsAvailability(fut.initialVersion(), fut, NODE_TO_ID, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<Integer, Map<Integer, List<T>>> initAffinityBasedOnPartitionsAvailability(final AffinityTopologyVersion topVer, final GridDhtPartitionsExchangeFuture fut, final IgniteClosure<ClusterNode, T> c, final boolean initAff) {
        final boolean enforcedCentralizedAssignment = DiscoveryCustomEvent.requiresCentralizedAffinityAssignment(fut.firstEvent());
        final WaitRebalanceInfo waitRebalanceInfo = enforcedCentralizedAssignment ? new WaitRebalanceInfo(fut.exchangeId().topologyVersion()) : new WaitRebalanceInfo(fut.context().events().lastServerEventVersion());
        final List<ClusterNode> evtNodes = fut.context().events().discoveryCache().serverNodes();
        final ConcurrentHashMap<Integer, Map<Integer, List<T>>> assignment = new ConcurrentHashMap<Integer, Map<Integer, List<T>>>();
        this.forAllRegisteredCacheGroups(new IgniteInClosureX<CacheGroupDescriptor>(){

            @Override
            public void applyx(CacheGroupDescriptor desc) throws IgniteCheckedException {
                CacheGroupHolder grpHolder = CacheAffinitySharedManager.this.getOrCreateGroupHolder(topVer, desc);
                if (!grpHolder.rebalanceEnabled || fut.cacheGroupAddedOnExchange(desc.groupId(), desc.receivedFrom()) && !enforcedCentralizedAssignment) {
                    return;
                }
                AffinityTopologyVersion affTopVer = grpHolder.affinity().lastVersion();
                assert (affTopVer.topologyVersion() > 0L && !affTopVer.equals(topVer) || enforcedCentralizedAssignment) : "Invalid affinity version [last=" + affTopVer + ", futVer=" + topVer + ", grp=" + desc.cacheOrGroupName() + ']';
                List<List<ClusterNode>> curAssignment = grpHolder.affinity().assignments(affTopVer);
                List<List<ClusterNode>> newAssignment = grpHolder.affinity().idealAssignmentRaw();
                assert (newAssignment != null);
                ArrayList<List<ClusterNode>> newAssignment0 = initAff ? new ArrayList<List<ClusterNode>>(newAssignment) : null;
                GridDhtPartitionTopology top = grpHolder.topology(fut.context().events().discoveryCache());
                HashMap cacheAssignment = null;
                for (int p = 0; p < newAssignment.size(); ++p) {
                    List<ClusterNode> newNodes = newAssignment.get(p);
                    List<ClusterNode> curNodes = curAssignment.get(p);
                    assert (evtNodes.containsAll(newNodes)) : "Invalid new assignment [grp=" + CacheGroupHolder.access$1200(grpHolder).cacheOrGroupName() + ", nodes=" + newNodes + ", topVer=" + fut.context().events().discoveryCache().version() + ", evts=" + fut.context().events().events() + "]";
                    ClusterNode curPrimary = !curNodes.isEmpty() ? curNodes.get(0) : null;
                    ClusterNode newPrimary = !newNodes.isEmpty() ? newNodes.get(0) : null;
                    List<ClusterNode> newNodes0 = null;
                    assert (newPrimary == null || evtNodes.contains(newPrimary)) : "Invalid new primary [grp=" + desc.cacheOrGroupName() + ", node=" + newPrimary + ", topVer=" + topVer + ']';
                    List<ClusterNode> owners = top.owners(p, topVer);
                    if (!owners.isEmpty() && !owners.contains(curPrimary)) {
                        curPrimary = owners.get(0);
                    }
                    if (curPrimary != null && newPrimary == null) {
                        newNodes0 = new ArrayList<ClusterNode>(curNodes.size());
                        for (ClusterNode node : curNodes) {
                            if (!evtNodes.contains(node)) continue;
                            newNodes0.add(node);
                        }
                    } else if (curPrimary != null && !curPrimary.equals(newPrimary)) {
                        GridDhtPartitionState state = top.partitionState(newPrimary.id(), p);
                        if (evtNodes.contains(curPrimary)) {
                            if (state != GridDhtPartitionState.OWNING) {
                                newNodes0 = CacheAffinitySharedManager.this.latePrimaryAssignment(grpHolder.affinity(), p, curPrimary, newNodes, waitRebalanceInfo);
                            }
                        } else if (state != GridDhtPartitionState.OWNING) {
                            for (int i = 1; i < curNodes.size(); ++i) {
                                ClusterNode curNode = curNodes.get(i);
                                if (top.partitionState(curNode.id(), p) != GridDhtPartitionState.OWNING || !evtNodes.contains(curNode)) continue;
                                newNodes0 = CacheAffinitySharedManager.this.latePrimaryAssignment(grpHolder.affinity(), p, curNode, newNodes, waitRebalanceInfo);
                                break;
                            }
                            if (newNodes0 == null) {
                                for (ClusterNode owner : owners) {
                                    if (!evtNodes.contains(owner)) continue;
                                    newNodes0 = CacheAffinitySharedManager.this.latePrimaryAssignment(grpHolder.affinity(), p, owner, newNodes, waitRebalanceInfo);
                                    break;
                                }
                            }
                        }
                    }
                    if (!(owners.isEmpty() || owners.containsAll(newNodes) || top.lostPartitions().contains(p))) {
                        waitRebalanceInfo.add(grpHolder.groupId(), p, newNodes);
                    }
                    if (newNodes0 == null) continue;
                    assert (evtNodes.containsAll(newNodes0)) : "Invalid late assignment [grp=" + CacheGroupHolder.access$1200(grpHolder).cacheOrGroupName() + ", nodes=" + newNodes + ", topVer=" + fut.context().events().discoveryCache().version() + ", evts=" + fut.context().events().events() + "]";
                    if (newAssignment0 != null) {
                        newAssignment0.set(p, newNodes0);
                    }
                    if (cacheAssignment == null) {
                        cacheAssignment = new HashMap();
                    }
                    ArrayList n = new ArrayList(newNodes0.size());
                    for (int i = 0; i < newNodes0.size(); ++i) {
                        n.add(c.apply(newNodes0.get(i)));
                    }
                    cacheAssignment.put(p, n);
                }
                if (cacheAssignment != null) {
                    assignment.put(grpHolder.groupId(), cacheAssignment);
                }
                if (initAff) {
                    grpHolder.affinity().initialize(topVer, newAssignment0);
                }
                fut.timeBag().finishLocalStage("Affinity recalculation (partitions availability) [grp=" + desc.cacheOrGroupName() + "]");
            }
        });
        if (this.log.isDebugEnabled()) {
            this.log.debug("Computed new affinity after node left [topVer=" + topVer + ", waitGrps=" + this.groupNames(waitRebalanceInfo.waitGrps.keySet()) + ']');
        }
        Object object = this.mux;
        synchronized (object) {
            this.waitInfo = !waitRebalanceInfo.empty() ? waitRebalanceInfo : null;
        }
        return assignment;
    }

    public Map<Integer, CacheGroupDescriptor> cacheGroups() {
        return this.cachesRegistry.allGroups();
    }

    public Map<Integer, DynamicCacheDescriptor> caches() {
        return this.cachesRegistry.allCaches();
    }

    @Nullable
    public GridAffinityAssignmentCache groupAffinity(int grpId) {
        CacheGroupHolder grpHolder = (CacheGroupHolder)this.grpHolders.get(grpId);
        return grpHolder != null ? grpHolder.affinity() : null;
    }

    public void dumpDebugInfo() {
        if (!this.pendingAssignmentFetchFuts.isEmpty()) {
            U.warn(this.log, "Pending assignment fetch futures:");
            for (GridDhtAssignmentFetchFuture fut : this.pendingAssignmentFetchFuts.values()) {
                U.warn(this.log, ">>> " + fut);
            }
        }
    }

    private static List<UUID> toIds0(List<ClusterNode> nodes) {
        ArrayList<UUID> partIds = new ArrayList<UUID>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            partIds.add(nodes.get(i).id());
        }
        return partIds;
    }

    private List<ClusterNode> toNodes(AffinityTopologyVersion topVer, List<UUID> ids) {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            UUID id = ids.get(i);
            ClusterNode node = this.cctx.discovery().node(topVer, id);
            assert (node != null) : "Failed to get node [id=" + id + ", topVer=" + topVer + ", locNode=" + this.cctx.localNode() + ", allNodes=" + this.cctx.discovery().nodes(topVer) + ']';
            nodes.add(node);
        }
        return nodes;
    }

    private CacheGroupNoAffOrFilteredHolder createHolder(GridCacheSharedContext cctx, CacheGroupDescriptor grpDesc, AffinityTopologyVersion topVer, @Nullable GridAffinityAssignmentCache initAff) throws IgniteCheckedException {
        assert (grpDesc != null);
        assert (!cctx.kernalContext().clientNode() || !CU.affinityNode(cctx.localNode(), grpDesc.config().getNodeFilter()));
        CacheConfiguration<?, ?> ccfg = grpDesc.config();
        assert (ccfg != null) : grpDesc;
        assert (ccfg.getCacheMode() != CacheMode.LOCAL) : ccfg.getName();
        assert (!cctx.discovery().cacheGroupAffinityNodes(grpDesc.groupId(), topVer).contains(cctx.localNode())) : grpDesc.cacheOrGroupName();
        AffinityFunction affFunc = cctx.cache().clone(ccfg.getAffinity());
        cctx.kernalContext().resource().injectGeneric(affFunc);
        cctx.kernalContext().resource().injectCacheName(affFunc, ccfg.getName());
        U.startLifecycleAware(F.asList(affFunc));
        GridAffinityAssignmentCache aff = new GridAffinityAssignmentCache(cctx.kernalContext(), grpDesc.cacheOrGroupName(), grpDesc.groupId(), affFunc, ccfg.getNodeFilter(), ccfg.getBackups(), ccfg.getCacheMode() == CacheMode.LOCAL);
        return new CacheGroupNoAffOrFilteredHolder(ccfg.getRebalanceMode() != CacheRebalanceMode.NONE, cctx, aff, initAff);
    }

    class CacheMemoryOverheadValidator {
        private static final double MEMORY_OVERHEAD_THRESHOLD = 0.15;

        CacheMemoryOverheadValidator() {
        }

        void validateCacheGroup(CacheGroupDescriptor grpDesc) {
            DataStorageConfiguration dsCfg = CacheAffinitySharedManager.this.cctx.gridConfig().getDataStorageConfiguration();
            CacheConfiguration<?, ?> grpCfg = grpDesc.config();
            if (!CU.isPersistentCache(grpCfg, dsCfg) || CU.isSystemCache(grpDesc.cacheOrGroupName())) {
                return;
            }
            CacheGroupHolder grpHolder = (CacheGroupHolder)CacheAffinitySharedManager.this.grpHolders.get(grpDesc.groupId());
            if (grpHolder != null) {
                int partsNum = 0;
                UUID locNodeId = CacheAffinitySharedManager.this.cctx.localNodeId();
                List<List<ClusterNode>> assignment = grpHolder.aff.idealAssignment().assignment();
                for (List<ClusterNode> nodes : assignment) {
                    if (!nodes.stream().anyMatch(n -> n.id().equals(locNodeId))) continue;
                    ++partsNum;
                }
                if (partsNum == 0) {
                    return;
                }
                DataRegionConfiguration drCfg = this.findDataRegion(dsCfg, grpCfg.getDataRegionName());
                if (drCfg == null) {
                    return;
                }
                if (1.0 * (double)partsNum * (double)dsCfg.getPageSize() / (double)drCfg.getMaxSize() > 0.15) {
                    CacheAffinitySharedManager.this.log.warning(this.buildWarningMessage(grpDesc, drCfg, dsCfg.getPageSize(), partsNum));
                }
            }
        }

        private String buildWarningMessage(CacheGroupDescriptor grpDesc, DataRegionConfiguration drCfg, int pageSize, int partsNum) {
            String res = "Cache group '%s' brings high overhead for its metainformation in data region '%s'. Metainformation required for its partitions (%d partitions, %d bytes per partition, %d MBs total) will consume more than 15%% of data region memory (%d MBs). It may lead to critical errors on the node and cluster instability. Please reduce number of partitions, add more memory to the data region or add more server nodes for this cache group.";
            return String.format(res, grpDesc.cacheOrGroupName(), drCfg.getName(), partsNum, pageSize, U.sizeInMegabytes(partsNum * pageSize), U.sizeInMegabytes(drCfg.getMaxSize()));
        }

        @Nullable
        private DataRegionConfiguration findDataRegion(DataStorageConfiguration dsCfg, String drName) {
            if (dsCfg.getDataRegionConfigurations() == null || drName == null) {
                return dsCfg.getDefaultDataRegionConfiguration();
            }
            if (dsCfg.getDefaultDataRegionConfiguration().getName().equals(drName)) {
                return dsCfg.getDefaultDataRegionConfiguration();
            }
            Optional<DataRegionConfiguration> cfgOpt = Arrays.stream(dsCfg.getDataRegionConfigurations()).filter(drCfg -> drCfg.getName().equals(drName)).findFirst();
            return cfgOpt.isPresent() ? cfgOpt.get() : null;
        }
    }

    class WaitRebalanceInfo {
        private final AffinityTopologyVersion topVer;
        private final Map<Integer, Set<Integer>> waitGrps = new ConcurrentHashMap<Integer, Set<Integer>>();
        private final Map<Integer, Map<Integer, List<ClusterNode>>> assignments = new ConcurrentHashMap<Integer, Map<Integer, List<ClusterNode>>>();
        private final Map<Integer, IgniteUuid> deploymentIds = new ConcurrentHashMap<Integer, IgniteUuid>();

        WaitRebalanceInfo(AffinityTopologyVersion topVer) {
            this.topVer = topVer;
        }

        boolean empty() {
            boolean isEmpty = this.waitGrps.isEmpty();
            if (!isEmpty) {
                assert (this.waitGrps.size() == this.assignments.size());
                return false;
            }
            return isEmpty;
        }

        void add(Integer grpId, Integer part, List<ClusterNode> assignment) {
            this.deploymentIds.putIfAbsent(grpId, CacheAffinitySharedManager.this.cachesRegistry.group(grpId).deploymentId());
            this.waitGrps.computeIfAbsent(grpId, k -> new HashSet()).add(part);
            this.assignments.computeIfAbsent(grpId, k -> new HashMap()).put(part, assignment);
        }

        public String toString() {
            return "WaitRebalanceInfo [topVer=" + this.topVer + ", grps=" + this.waitGrps.keySet() + ']';
        }
    }

    private class CacheGroupNoAffOrFilteredHolder
    extends CacheGroupHolder {
        private final GridCacheSharedContext cctx;

        CacheGroupNoAffOrFilteredHolder(boolean rebalanceEnabled, GridCacheSharedContext cctx, @Nullable GridAffinityAssignmentCache aff, GridAffinityAssignmentCache initAff) {
            super(rebalanceEnabled, aff, initAff);
            this.cctx = cctx;
        }

        CacheGroupNoAffOrFilteredHolder create(GridCacheSharedContext cctx, CacheGroupDescriptor grpDesc, AffinityTopologyVersion topVer) throws IgniteCheckedException {
            return this.create(cctx, grpDesc, topVer, null);
        }

        CacheGroupNoAffOrFilteredHolder create(GridCacheSharedContext cctx, CacheGroupDescriptor grpDesc, AffinityTopologyVersion topVer, @Nullable GridAffinityAssignmentCache initAff) throws IgniteCheckedException {
            assert (grpDesc != null);
            assert (!cctx.kernalContext().clientNode() || !CU.affinityNode(cctx.localNode(), grpDesc.config().getNodeFilter()));
            CacheConfiguration<?, ?> ccfg = grpDesc.config();
            assert (ccfg != null) : grpDesc;
            assert (ccfg.getCacheMode() != CacheMode.LOCAL) : ccfg.getName();
            assert (!cctx.discovery().cacheGroupAffinityNodes(grpDesc.groupId(), topVer).contains(cctx.localNode())) : grpDesc.cacheOrGroupName();
            AffinityFunction affFunc = cctx.cache().clone(ccfg.getAffinity());
            cctx.kernalContext().resource().injectGeneric(affFunc);
            cctx.kernalContext().resource().injectCacheName(affFunc, ccfg.getName());
            U.startLifecycleAware(F.asList(affFunc));
            GridAffinityAssignmentCache aff = new GridAffinityAssignmentCache(cctx.kernalContext(), grpDesc.cacheOrGroupName(), grpDesc.groupId(), affFunc, ccfg.getNodeFilter(), ccfg.getBackups(), ccfg.getCacheMode() == CacheMode.LOCAL);
            return new CacheGroupNoAffOrFilteredHolder(ccfg.getRebalanceMode() != CacheRebalanceMode.NONE, cctx, aff, initAff);
        }

        @Override
        public boolean nonAffNode() {
            return true;
        }

        @Override
        public GridDhtPartitionTopology topology(DiscoCache discoCache) {
            return this.cctx.exchange().clientTopology(this.groupId(), discoCache);
        }
    }

    private class CacheGroupAffNodeHolder
    extends CacheGroupHolder {
        private final CacheGroupContext grp;

        CacheGroupAffNodeHolder(CacheGroupContext grp) {
            this(grp, null);
        }

        CacheGroupAffNodeHolder(@Nullable CacheGroupContext grp, GridAffinityAssignmentCache initAff) {
            super(grp.rebalanceEnabled(), grp.affinity(), initAff);
            assert (!grp.isLocal()) : grp;
            this.grp = grp;
        }

        @Override
        public boolean nonAffNode() {
            return false;
        }

        @Override
        public GridDhtPartitionTopology topology(DiscoCache discoCache) {
            return this.grp.topology();
        }
    }

    abstract class CacheGroupHolder {
        private final GridAffinityAssignmentCache aff;
        private final boolean rebalanceEnabled;

        CacheGroupHolder(boolean rebalanceEnabled, @Nullable GridAffinityAssignmentCache aff, GridAffinityAssignmentCache initAff) {
            this.aff = aff;
            if (initAff != null) {
                aff.init(initAff);
            }
            this.rebalanceEnabled = rebalanceEnabled;
        }

        abstract boolean nonAffNode();

        int groupId() {
            return this.aff.groupId();
        }

        int partitions() {
            return this.aff.partitions();
        }

        abstract GridDhtPartitionTopology topology(DiscoCache var1);

        GridAffinityAssignmentCache affinity() {
            return this.aff;
        }
    }
}

