/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.keys.BooleanIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.ByteIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.BytesIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.CacheJavaObjectIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DecimalIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DoubleIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.FloatIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IntegerIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.LongIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.PlainJavaObjectIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.ShortIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.SignedBytesIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.StringIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.UuidIndexKey;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;

public class IndexKeyFactory {
    private static final Map<Integer, Function<Object, IndexKey>> registry = new ConcurrentHashMap<Integer, Function<Object, IndexKey>>();
    private static final Map<Integer, BiFunction<Long, Long, IndexKey>> dateTimeRegistry = new ConcurrentHashMap<Integer, BiFunction<Long, Long, IndexKey>>();

    public static void register(int keyType, Function<Object, IndexKey> wrapper) {
        registry.put(keyType, wrapper);
    }

    public static void registerDateValueFactory(int keyType, BiFunction<Long, Long, IndexKey> factory) {
        dateTimeRegistry.put(keyType, factory);
    }

    public static IndexKey wrapDateValue(int keyType, long dateVal, long nanos) {
        return dateTimeRegistry.get(keyType).apply(dateVal, nanos);
    }

    public static IndexKey wrap(Object o, int keyType, CacheObjectValueContext coctx, IndexKeyTypeSettings keyTypeSettings) {
        if (o == null || keyType == 0) {
            return NullIndexKey.INSTANCE;
        }
        switch (keyType) {
            case 1: {
                return new BooleanIndexKey((Boolean)o);
            }
            case 2: {
                return new ByteIndexKey((Byte)o);
            }
            case 3: {
                return new ShortIndexKey((Short)o);
            }
            case 4: {
                return new IntegerIndexKey((Integer)o);
            }
            case 5: {
                return new LongIndexKey((Long)o);
            }
            case 6: {
                return new DecimalIndexKey((BigDecimal)o);
            }
            case 7: {
                return new DoubleIndexKey((Double)o);
            }
            case 8: {
                return new FloatIndexKey(((Float)o).floatValue());
            }
            case 12: {
                return keyTypeSettings.binaryUnsigned() ? new BytesIndexKey((byte[])o) : new SignedBytesIndexKey((byte[])o);
            }
            case 13: {
                return new StringIndexKey((String)o);
            }
            case 20: {
                return new UuidIndexKey((UUID)o);
            }
            case 19: {
                if (BinaryObjectImpl.class == o.getClass()) {
                    return new CacheJavaObjectIndexKey((CacheObject)o, coctx);
                }
                return new PlainJavaObjectIndexKey(o, null);
            }
        }
        if (registry.containsKey(keyType)) {
            return registry.get(keyType).apply(o);
        }
        throw new IgniteException("Failed to wrap value[type=" + keyType + ", value=" + o + "]");
    }
}

