/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.management.CacheMXBean;
import javax.cache.management.CacheStatisticsMXBean;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CachingProvider;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalGateway;
import org.apache.ignite.internal.GridKernalState;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.mxbean.IgniteStandardMXBean;
import org.apache.ignite.internal.processors.cache.GatewayProtectedCacheProxy;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.jetbrains.annotations.Nullable;

public class CacheManager
implements javax.cache.CacheManager {
    public static final boolean DFLT_JCACHE_DEFAULT_ISOLATED = true;
    private static final String CACHE_STATISTICS = "CacheStatistics";
    private static final String CACHE_CONFIGURATION = "CacheConfiguration";
    private static final AtomicInteger igniteCnt = new AtomicInteger();
    private final URI uri;
    private final CachingProvider cachingProvider;
    private final ClassLoader clsLdr;
    private Properties props = new Properties();
    private final IgniteKernal ignite;
    private final GridKernalGateway kernalGateway;

    public CacheManager(URI uri, CachingProvider cachingProvider, ClassLoader clsLdr, Properties props) {
        this.uri = uri;
        this.cachingProvider = cachingProvider;
        this.clsLdr = clsLdr;
        this.props = props == null ? new Properties() : props;
        try {
            if (uri.equals(cachingProvider.getDefaultURI())) {
                IgniteConfiguration cfg = new IgniteConfiguration();
                if (IgniteSystemProperties.getBoolean("IGNITE_CACHE_CLIENT", true)) {
                    TcpDiscoverySpi discoSpi = new TcpDiscoverySpi();
                    discoSpi.setIpFinder(new TcpDiscoveryVmIpFinder(true));
                    cfg.setDiscoverySpi(discoSpi);
                }
                cfg.setIgniteInstanceName("CacheManager_" + igniteCnt.getAndIncrement());
                cfg.setClassLoader(clsLdr);
                this.ignite = (IgniteKernal)IgnitionEx.start(cfg);
            } else {
                this.ignite = (IgniteKernal)IgnitionEx.start(uri.toURL(), clsLdr);
            }
            this.kernalGateway = this.ignite.context().gateway();
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        catch (MalformedURLException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.clsLdr;
    }

    public Properties getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C cacheCfg) throws IllegalArgumentException {
        this.kernalGateway.readLock();
        try {
            CacheConfiguration igniteCacheCfg;
            if (cacheCfg == null) {
                throw new NullPointerException();
            }
            if (cacheName == null) {
                throw new NullPointerException();
            }
            if (cacheCfg instanceof CompleteConfiguration) {
                igniteCacheCfg = new CacheConfiguration((CompleteConfiguration)cacheCfg);
            } else {
                igniteCacheCfg = new CacheConfiguration();
                igniteCacheCfg.setTypes(cacheCfg.getKeyType(), cacheCfg.getValueType());
            }
            igniteCacheCfg.setName(cacheName);
            IgniteCache res = this.ignite.createCache(igniteCacheCfg);
            if (res == null) {
                throw new CacheException();
            }
            ((GatewayProtectedCacheProxy)res).setCacheManager(this);
            if (igniteCacheCfg.isManagementEnabled()) {
                this.enableManagement(cacheName, true);
            }
            if (igniteCacheCfg.isStatisticsEnabled()) {
                this.enableStatistics(cacheName, true);
            }
            IgniteCache igniteCache = res;
            return igniteCache;
        }
        finally {
            this.kernalGateway.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valType) {
        this.kernalGateway.readLock();
        try {
            IgniteCache<K, V> cache = this.getCache0(cacheName);
            if (cache != null) {
                if (!keyType.isAssignableFrom(cache.getConfiguration(Configuration.class).getKeyType())) {
                    throw new ClassCastException();
                }
                if (!valType.isAssignableFrom(cache.getConfiguration(Configuration.class).getValueType())) {
                    throw new ClassCastException();
                }
            }
            IgniteCache<K, V> igniteCache = cache;
            return igniteCache;
        }
        finally {
            this.kernalGateway.readUnlock();
        }
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.kernalGateway.readLock();
        try {
            IgniteCache<K, V> igniteCache = this.getCache0(cacheName);
            return igniteCache;
        }
        finally {
            this.kernalGateway.readUnlock();
        }
    }

    @Nullable
    private <K, V> IgniteCache<K, V> getCache0(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException();
        }
        try {
            return this.ignite.cache(cacheName);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> getCacheNames() {
        this.kernalGateway.readLockAnyway();
        try {
            if (this.kernalGateway.getState() != GridKernalState.STARTED) {
                throw new IllegalStateException();
            }
            ArrayList<String> res = new ArrayList<String>();
            for (IgniteCache igniteCache : this.ignite.context().cache().publicCaches()) {
                res.add(igniteCache.getName());
            }
            Collection collection = Collections.unmodifiableCollection(res);
            return collection;
        }
        finally {
            this.kernalGateway.readUnlock();
        }
    }

    public void destroyCache(String cacheName) {
        IgniteCache cache;
        this.kernalGateway.readLock();
        try {
            cache = this.getCache0(cacheName);
            if (cache != null) {
                this.unregisterCacheObject(cacheName, CACHE_CONFIGURATION);
                this.unregisterCacheObject(cacheName, CACHE_STATISTICS);
            }
        }
        finally {
            this.kernalGateway.readUnlock();
        }
        if (cache != null) {
            cache.destroy();
        }
    }

    private ObjectName getObjectName(String cacheName, String objName) {
        String mBeanName = "javax.cache:type=" + objName + ",CacheManager=" + this.uri.toString().replaceAll(",|:|=|\n", ".") + ",Cache=" + cacheName.replaceAll(",|:|=|\n", ".");
        try {
            return new ObjectName(mBeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Failed to create MBean name: " + mBeanName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableManagement(String cacheName, boolean enabled) {
        if (IgniteUtils.IGNITE_MBEANS_DISABLED) {
            return;
        }
        this.kernalGateway.readLock();
        try {
            IgniteCache cache = this.getCache0(cacheName);
            if (cache == null) {
                throw new CacheException("Cache not found: " + cacheName);
            }
            if (enabled) {
                this.registerCacheObject(cache.mxBean(), cacheName, CACHE_CONFIGURATION);
            } else {
                this.unregisterCacheObject(cacheName, CACHE_CONFIGURATION);
            }
            cache.getConfiguration(CacheConfiguration.class).setManagementEnabled(enabled);
        }
        finally {
            this.kernalGateway.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableStatistics(String cacheName, boolean enabled) {
        if (IgniteUtils.IGNITE_MBEANS_DISABLED) {
            return;
        }
        this.kernalGateway.readLock();
        try {
            IgniteCache cache = this.getCache0(cacheName);
            if (cache == null) {
                throw new CacheException("Cache not found: " + cacheName);
            }
            if (enabled) {
                this.registerCacheObject(cache.mxBean(), cacheName, CACHE_STATISTICS);
            } else {
                this.unregisterCacheObject(cacheName, CACHE_STATISTICS);
            }
            this.ignite.context().cache().cache(cacheName).context().statisticsEnabled(enabled);
        }
        finally {
            this.kernalGateway.readUnlock();
        }
    }

    private void registerCacheObject(Object mxbean, String name, String beanType) {
        MBeanServer mBeanSrv = this.ignite.configuration().getMBeanServer();
        ObjectName registeredObjName = this.getObjectName(name, beanType);
        try {
            if (mBeanSrv.queryNames(registeredObjName, null).isEmpty()) {
                IgniteStandardMXBean bean = beanType.equals(CACHE_CONFIGURATION) ? new IgniteStandardMXBean((CacheMXBean)mxbean, CacheMXBean.class) : new IgniteStandardMXBean((CacheStatisticsMXBean)mxbean, CacheStatisticsMXBean.class);
                mBeanSrv.registerMBean(bean, registeredObjName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failed to register MBean: " + registeredObjName, (Throwable)e);
        }
    }

    private void unregisterCacheObject(String name, String beanType) {
        if (IgniteUtils.IGNITE_MBEANS_DISABLED) {
            return;
        }
        MBeanServer mBeanSrv = this.ignite.configuration().getMBeanServer();
        Set<ObjectName> registeredObjNames = mBeanSrv.queryNames(this.getObjectName(name, beanType), null);
        for (ObjectName registeredObjectName : registeredObjNames) {
            try {
                mBeanSrv.unregisterMBean(registeredObjectName);
            }
            catch (Exception e) {
                throw new CacheException("Error unregistering object instance " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void close() {
        try {
            this.ignite.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.cachingProvider.removeClosedManager(this);
        }
    }

    public boolean isClosed() {
        this.kernalGateway.readLockAnyway();
        try {
            boolean bl = this.kernalGateway.getState() != GridKernalState.STARTED;
            return bl;
        }
        finally {
            this.kernalGateway.readUnlock();
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(this.ignite.getClass())) {
            return clazz.cast(this.ignite);
        }
        throw new IllegalArgumentException();
    }
}

