/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.performancestatistics;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.performancestatistics.PerformanceStatisticsSubCommand;
import org.apache.ignite.internal.visor.performancestatistics.VisorPerformanceStatisticsTask;
import org.apache.ignite.internal.visor.performancestatistics.VisorPerformanceStatisticsTaskArg;

public class PerformanceStatisticsCommand
extends AbstractCommand<Object> {
    private VisorPerformanceStatisticsTaskArg taskArgs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            String res = (String)TaskExecutor.executeTaskByNameOnNode(client, VisorPerformanceStatisticsTask.class.getName(), this.taskArgs, null, clientCfg);
            log.info(res);
            String string = res;
            return string;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public Object arg() {
        return this.taskArgs;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        PerformanceStatisticsSubCommand cmd = PerformanceStatisticsSubCommand.of(argIter.nextArg("Expected performance statistics action."));
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct performance statistics action.");
        }
        this.taskArgs = new VisorPerformanceStatisticsTaskArg(cmd.visorOperation());
    }

    @Override
    public void printUsage(Logger log) {
        Command.usage(log, "Start collecting performance statistics in the cluster:", CommandList.PERFORMANCE_STATISTICS, PerformanceStatisticsSubCommand.START.toString());
        Command.usage(log, "Stop collecting performance statistics in the cluster:", CommandList.PERFORMANCE_STATISTICS, PerformanceStatisticsSubCommand.STOP.toString());
        Command.usage(log, "Rotate collecting performance statistics in the cluster:", CommandList.PERFORMANCE_STATISTICS, PerformanceStatisticsSubCommand.ROTATE.toString());
        Command.usage(log, "Get status of collecting performance statistics in the cluster:", CommandList.PERFORMANCE_STATISTICS, PerformanceStatisticsSubCommand.STATUS.toString());
    }

    @Override
    public String name() {
        return CommandList.PERFORMANCE_STATISTICS.toCommandName();
    }
}

