/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Comparator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientBeforeNodeStart;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public interface Command<T> {
    public static GridClient startClient(GridClientConfiguration clientCfg) throws Exception {
        GridClient client = GridClientFactory.start((GridClientConfiguration)clientCfg);
        if (!client.connected()) {
            GridClientException lastErr = client.checkLastError();
            try {
                client.close();
            }
            catch (Throwable e) {
                lastErr.addSuppressed(e);
            }
            throw lastErr;
        }
        return client;
    }

    public static GridClientBeforeNodeStart startClientBeforeNodeStart(GridClientConfiguration clientCfg) throws Exception {
        GridClientBeforeNodeStart client = GridClientFactory.startBeforeNodeStart((GridClientConfiguration)clientCfg);
        if (!client.connected()) {
            GridClientException lastErr = client.checkLastError();
            try {
                client.close();
            }
            catch (Throwable e) {
                lastErr.addSuppressed(e);
            }
            throw lastErr;
        }
        return client;
    }

    public static void usage(Logger logger, String desc, CommandList cmd, String ... args) {
        Command.usage(logger, desc, cmd, null, args);
    }

    public static void usage(Logger logger, String desc, CommandList cmd, @Nullable Map<String, String> paramsDesc, String ... args) {
        logger.info("");
        logger.info("  " + desc);
        logger.info("    " + CommandLogger.join(" ", new Object[]{"control.(sh|bat)", cmd, CommandLogger.join(" ", args)}));
        if (!F.isEmpty(paramsDesc)) {
            logger.info("");
            logger.info("    Parameters:");
            Command.usageParams(paramsDesc, "      ", logger);
        }
    }

    public static void usageParams(Map<String, String> paramsDesc, String indent, Logger logger) {
        int maxParamLen = paramsDesc.keySet().stream().max(Comparator.comparingInt(String::length)).get().length();
        for (Map.Entry<String, String> param : paramsDesc.entrySet()) {
            logger.info(indent + Command.extendToLen(param.getKey(), maxParamLen) + "  - " + param.getValue());
        }
    }

    public static String extendToLen(String s, int targetLen) {
        if (!1.$assertionsDisabled && targetLen < 0) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && s.length() > targetLen) {
            throw new AssertionError();
        }
        if (s.length() == targetLen) {
            return s;
        }
        SB sb = new SB(targetLen);
        sb.a(s);
        for (int i = 0; i < targetLen - s.length(); ++i) {
            sb.a(" ");
        }
        return sb.toString();
    }

    public Object execute(GridClientConfiguration var1, Logger var2) throws Exception;

    default public Object execute(GridClientConfiguration clientCfg, Logger logger, boolean verbose) throws Exception {
        return this.execute(clientCfg, logger);
    }

    default public void prepareConfirmation(GridClientConfiguration clientCfg) throws Exception {
    }

    default public String confirmationPrompt() {
        return null;
    }

    default public void parseArguments(CommandArgIterator argIterator) {
    }

    public T arg();

    public void printUsage(Logger var1);

    public String name();

    default public boolean experimental() {
        return false;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

