/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlPlaceholder;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public class GridSqlSelect
extends GridSqlQuery {
    public static final int FROM_CHILD = 2;
    public static final int WHERE_CHILD = 3;
    private static final int COLS_CHILD = 4;
    private List<GridSqlAst> cols = new ArrayList<GridSqlAst>();
    private int visibleCols;
    private boolean distinct;
    private int[] grpCols;
    private GridSqlAst from;
    private GridSqlAst where;
    private int havingCol = -1;
    private boolean isForUpdate;
    private boolean canBeLazy;

    public static int childIndexForColumn(int colIdx) {
        return colIdx + 4;
    }

    @Override
    public int size() {
        return 4 + this.cols.size();
    }

    @Override
    public <E extends GridSqlAst> E child(int childIdx) {
        if (childIdx < 2) {
            return super.child(childIdx);
        }
        switch (childIdx) {
            case 2: {
                return GridSqlSelect.maskNull(this.from, GridSqlPlaceholder.EMPTY);
            }
            case 3: {
                return GridSqlSelect.maskNull(this.where, GridSqlConst.TRUE);
            }
        }
        return (E)this.cols.get(childIdx - 4);
    }

    @Override
    public <E extends GridSqlAst> void child(int childIdx, E child) {
        if (childIdx < 2) {
            super.child(childIdx, child);
            return;
        }
        switch (childIdx) {
            case 2: {
                this.from = child;
                break;
            }
            case 3: {
                this.where = child;
                break;
            }
            default: {
                this.cols.set(childIdx - 4, child);
            }
        }
    }

    @Override
    public int visibleColumns() {
        return this.visibleCols;
    }

    public int allColumns() {
        return this.cols.size();
    }

    @Override
    protected GridSqlAst column(int col) {
        return this.cols.get(col);
    }

    @Override
    public String getSQL() {
        char delim = QueryUtils.delimeter();
        StatementBuilder buff = new StatementBuilder(this.explain() ? "EXPLAIN SELECT" : "SELECT");
        if (this.distinct) {
            buff.append(" DISTINCT");
        }
        for (GridSqlAst expression : this.columns(true)) {
            buff.appendExceptFirst(",");
            buff.append(delim);
            buff.append(expression.getSQL());
        }
        if (this.from != null) {
            buff.append(delim).append("FROM ").append(this.from.getSQL());
        }
        if (this.where != null) {
            buff.append(delim).append("WHERE ").append(StringUtils.unEnclose((String)this.where.getSQL()));
        }
        if (this.grpCols != null) {
            buff.append(delim).append("GROUP BY ");
            buff.resetCount();
            for (Object grpCol : (Object)this.grpCols) {
                buff.appendExceptFirst(", ");
                GridSqlSelect.addAlias(buff, this.cols.get((int)grpCol));
            }
        }
        if (this.havingCol >= 0) {
            buff.append(delim).append("HAVING ");
            GridSqlSelect.addAlias(buff, this.cols.get(this.havingCol));
        }
        this.getSortLimitSQL(buff);
        if (this.isForUpdate) {
            buff.append(delim).append("FOR UPDATE");
        }
        return buff.toString();
    }

    @Override
    public boolean skipMergeTable() {
        boolean simple;
        boolean bl = simple = !this.distinct && this.from instanceof GridSqlTable && this.where == null && this.grpCols == null && this.havingCol < 0 && this.sort.isEmpty() && this.limit() == null && this.offset() == null;
        if (simple) {
            for (GridSqlAst expression : this.columns(true)) {
                if (expression instanceof GridSqlAlias) {
                    expression = expression.child();
                }
                if (expression instanceof GridSqlColumn) continue;
                return false;
            }
        }
        return simple;
    }

    private static void addAlias(StatementBuilder buff, GridSqlAst exp) {
        exp = GridSqlAlias.unwrap(exp);
        buff.append(StringUtils.unEnclose((String)exp.getSQL()));
    }

    public List<GridSqlAst> columns(boolean visibleOnly) {
        assert (this.visibleCols <= this.cols.size());
        return visibleOnly && this.visibleCols != this.cols.size() ? this.cols.subList(0, this.visibleCols) : this.cols;
    }

    public GridSqlSelect clearColumns() {
        this.visibleCols = 0;
        this.cols = new ArrayList<GridSqlAst>();
        return this;
    }

    public GridSqlSelect addColumn(GridSqlAst expression, boolean visible) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (visible) {
            if (this.visibleCols != this.cols.size()) {
                throw new IllegalStateException("Already started adding invisible columns.");
            }
            ++this.visibleCols;
        }
        this.cols.add(expression);
        return this;
    }

    public GridSqlSelect setColumn(int colIdx, GridSqlAst expression) {
        if (expression == null) {
            throw new NullPointerException();
        }
        this.cols.set(colIdx, expression);
        return this;
    }

    public int[] groupColumns() {
        return this.grpCols;
    }

    public GridSqlSelect groupColumns(int[] grpCols) {
        this.grpCols = grpCols;
        return this;
    }

    public GridSqlAst from() {
        return this.from;
    }

    public GridSqlSelect from(GridSqlAst from) {
        this.from = from;
        return this;
    }

    public boolean distinct() {
        return this.distinct;
    }

    public void distinct(boolean distinct) {
        this.distinct = distinct;
    }

    public GridSqlAst where() {
        return this.where;
    }

    public GridSqlSelect where(GridSqlAst where) {
        this.where = where;
        return this;
    }

    public GridSqlSelect whereAnd(GridSqlAst cond) {
        if (cond == null) {
            throw new NullPointerException();
        }
        GridSqlAst old = this.where();
        this.where(old == null ? cond : new GridSqlOperation(GridSqlOperationType.AND, old, cond));
        return this;
    }

    public GridSqlAst having() {
        return this.havingCol >= 0 ? this.column(this.havingCol) : null;
    }

    public GridSqlSelect havingColumn(int col) {
        assert (col >= -1) : col;
        this.havingCol = col;
        return this;
    }

    public boolean isForUpdate() {
        return this.isForUpdate;
    }

    public void forUpdate(boolean forUpdate) {
        this.isForUpdate = forUpdate;
    }

    public int havingColumn() {
        return this.havingCol;
    }

    public void collectFromAliases(Set<GridSqlAlias> aliases) {
        GridSqlAst from = this.from();
        if (from == null) {
            return;
        }
        while (from instanceof GridSqlJoin) {
            GridSqlElement right = ((GridSqlJoin)from).rightTable();
            aliases.add((GridSqlAlias)right);
            from = ((GridSqlJoin)from).leftTable();
        }
        aliases.add((GridSqlAlias)from);
    }

    public GridSqlSelect copySelectForUpdate() {
        assert (this.isForUpdate && !this.distinct && this.havingCol < 0 && this.grpCols == null);
        GridSqlSelect copy = new GridSqlSelect();
        copy.from(this.from()).where(this.where());
        int vis = this.visibleColumns();
        for (int i = 0; i < this.columns(false).size(); ++i) {
            copy.addColumn(this.column(i), i < vis);
        }
        if (!this.sort().isEmpty()) {
            for (GridSqlSortColumn sortCol : this.sort()) {
                copy.addSort(sortCol);
            }
        }
        return copy;
    }

    public void canBeLazy(boolean canBeLazy) {
        this.canBeLazy = canBeLazy;
    }

    public boolean canBeLazy() {
        return this.canBeLazy;
    }
}

