/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneDirectory;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.h2.util.JdbcUtils;
import org.jetbrains.annotations.Nullable;

public class GridLuceneIndex
implements AutoCloseable {
    public static final String VAL_STR_FIELD_NAME = "_gg_val_str__";
    public static final String VER_FIELD_NAME = "_gg_ver__";
    public static final String EXPIRATION_TIME_FIELD_NAME = "_gg_expires__";
    private final String cacheName;
    private final GridQueryTypeDescriptor type;
    private final IndexWriter writer;
    private final String[] idxdFields;
    private final AtomicLong updateCntr = new GridAtomicLong();
    private final GridLuceneDirectory dir;
    private final GridKernalContext ctx;

    public GridLuceneIndex(GridKernalContext ctx, @Nullable String cacheName, GridQueryTypeDescriptor type) throws IgniteCheckedException {
        this.ctx = ctx;
        this.cacheName = cacheName;
        this.type = type;
        this.dir = new GridLuceneDirectory(new GridUnsafeMemory(0L));
        try {
            this.writer = new IndexWriter((Directory)this.dir, new IndexWriterConfig((Analyzer)new StandardAnalyzer()));
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        GridQueryIndexDescriptor idx = type.textIndex();
        if (idx != null) {
            Collection fields = idx.fields();
            this.idxdFields = new String[fields.size() + 1];
            fields.toArray(this.idxdFields);
        } else {
            assert (type.valueTextIndex() || type.valueClass() == String.class);
            this.idxdFields = new String[1];
        }
        this.idxdFields[this.idxdFields.length - 1] = VAL_STR_FIELD_NAME;
    }

    private CacheObjectContext objectContext() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.cache().internalCache(this.cacheName).context().cacheObjectContext();
    }

    public void store(CacheObject k, CacheObject v, GridCacheVersion ver, long expires) throws IgniteCheckedException {
        CacheObjectContext coctx = this.objectContext();
        CacheObject key = k.isPlatformType() ? k.value((CacheObjectValueContext)coctx, false) : k;
        CacheObject val = v.isPlatformType() ? v.value((CacheObjectValueContext)coctx, false) : v;
        Document doc = new Document();
        boolean stringsFound = false;
        if (this.type.valueTextIndex() || this.type.valueClass() == String.class) {
            doc.add((IndexableField)new TextField(VAL_STR_FIELD_NAME, val.toString(), Field.Store.YES));
            stringsFound = true;
        }
        int last = this.idxdFields.length - 1;
        for (int i = 0; i < last; ++i) {
            Object fieldVal = this.type.value(this.idxdFields[i], (Object)key, (Object)val);
            if (fieldVal == null) continue;
            doc.add((IndexableField)new TextField(this.idxdFields[i], fieldVal.toString(), Field.Store.YES));
            stringsFound = true;
        }
        BytesRef keyByteRef = new BytesRef(k.valueBytes((CacheObjectValueContext)coctx));
        try {
            Term term = new Term("_KEY", keyByteRef);
            if (!stringsFound) {
                this.writer.deleteDocuments(new Term[]{term});
                return;
            }
            doc.add((IndexableField)new StringField("_KEY", keyByteRef, Field.Store.YES));
            if (this.type.valueClass() != String.class) {
                doc.add((IndexableField)new StoredField("_VAL", v.valueBytes((CacheObjectValueContext)coctx)));
            }
            doc.add((IndexableField)new StoredField(VER_FIELD_NAME, ver.toString().getBytes()));
            doc.add((IndexableField)new LongPoint(EXPIRATION_TIME_FIELD_NAME, new long[]{expires}));
            this.writer.updateDocument(term, (Iterable)doc);
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        finally {
            this.updateCntr.incrementAndGet();
        }
    }

    public void remove(CacheObject key) throws IgniteCheckedException {
        try {
            this.writer.deleteDocuments(new Term[]{new Term("_KEY", new BytesRef(key.valueBytes((CacheObjectValueContext)this.objectContext())))});
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        finally {
            this.updateCntr.incrementAndGet();
        }
    }

    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> query(String qry, IndexingQueryFilter filters, int limit) throws IgniteCheckedException {
        TopDocs docs;
        IndexSearcher searcher;
        DirectoryReader reader;
        try {
            long updates = this.updateCntr.get();
            if (updates != 0L) {
                this.writer.commit();
                this.updateCntr.addAndGet(-updates);
            }
            reader = DirectoryReader.open((IndexWriter)this.writer);
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        try {
            searcher = new IndexSearcher((IndexReader)reader);
            MultiFieldQueryParser parser = new MultiFieldQueryParser(this.idxdFields, this.writer.getAnalyzer());
            Query filter = LongPoint.newRangeQuery((String)EXPIRATION_TIME_FIELD_NAME, (long)U.currentTimeMillis(), (long)Long.MAX_VALUE);
            BooleanQuery query = new BooleanQuery.Builder().add(parser.parse(qry), BooleanClause.Occur.MUST).add(filter, BooleanClause.Occur.FILTER).build();
            docs = searcher.search((Query)query, limit > 0 ? limit : Integer.MAX_VALUE);
        }
        catch (Exception e) {
            U.closeQuiet((AutoCloseable)reader);
            throw new IgniteCheckedException((Throwable)e);
        }
        IndexingQueryCacheFilter fltr = null;
        if (filters != null) {
            fltr = filters.forCache(this.cacheName);
        }
        return new It((IndexReader)reader, searcher, docs.scoreDocs, fltr);
    }

    @Override
    public void close() {
        U.closeQuiet((AutoCloseable)this.writer);
        U.close((AutoCloseable)((Object)this.dir), (IgniteLogger)this.ctx.log(GridLuceneIndex.class));
    }

    private class It<K, V>
    extends GridCloseableIteratorAdapter<IgniteBiTuple<K, V>> {
        private static final long serialVersionUID = 0L;
        private final IndexReader reader;
        private final IndexSearcher searcher;
        private final ScoreDoc[] docs;
        private final IndexingQueryCacheFilter filters;
        private int idx;
        private IgniteBiTuple<K, V> curr;
        private CacheObjectContext coctx;

        private It(IndexReader reader, IndexSearcher searcher, ScoreDoc[] docs, IndexingQueryCacheFilter filters) throws IgniteCheckedException {
            this.reader = reader;
            this.searcher = searcher;
            this.docs = docs;
            this.filters = filters;
            this.coctx = GridLuceneIndex.this.objectContext();
            this.findNext();
        }

        private <Z> Z unmarshall(byte[] bytes, ClassLoader ldr) throws IgniteCheckedException {
            if (this.coctx == null) {
                return (Z)JdbcUtils.deserialize((byte[])bytes, null);
            }
            return (Z)this.coctx.kernalContext().cacheObjects().unmarshal((CacheObjectValueContext)this.coctx, bytes, ldr);
        }

        private void findNext() throws IgniteCheckedException {
            this.curr = null;
            while (this.idx < this.docs.length) {
                String v;
                Document doc;
                try {
                    doc = this.searcher.doc(this.docs[this.idx++].doc);
                }
                catch (IOException e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
                ClassLoader ldr = null;
                if (GridLuceneIndex.this.ctx != null && GridLuceneIndex.this.ctx.deploy().enabled()) {
                    ldr = GridLuceneIndex.this.ctx.cache().internalCache(GridLuceneIndex.this.cacheName).context().deploy().globalLoader();
                }
                Object k = this.unmarshall(doc.getBinaryValue((String)"_KEY").bytes, ldr);
                if (this.filters != null && !this.filters.apply(k)) continue;
                String string = v = GridLuceneIndex.this.type.valueClass() == String.class ? doc.get(GridLuceneIndex.VAL_STR_FIELD_NAME) : this.unmarshall(doc.getBinaryValue((String)"_VAL").bytes, ldr);
                assert (v != null);
                this.curr = new IgniteBiTuple(k, (Object)v);
                break;
            }
        }

        protected IgniteBiTuple<K, V> onNext() throws IgniteCheckedException {
            IgniteBiTuple<K, V> res = this.curr;
            this.findNext();
            return res;
        }

        protected boolean onHasNext() throws IgniteCheckedException {
            return this.curr != null;
        }

        protected void onClose() throws IgniteCheckedException {
            U.closeQuiet((AutoCloseable)this.reader);
        }
    }
}

