/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.kubernetes.configuration;

import org.apache.ignite.spi.IgniteSpiException;

public class KubernetesConnectionConfiguration {
    private String srvcName = "ignite";
    private String namespace = "default";
    private String master = "https://kubernetes.default.svc.cluster.local:443";
    private String accountToken = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private boolean includeNotReadyAddresses = false;

    public KubernetesConnectionConfiguration setServiceName(String service) {
        this.srvcName = service;
        return this;
    }

    public String getServiceName() {
        return this.srvcName;
    }

    public KubernetesConnectionConfiguration setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public KubernetesConnectionConfiguration setMasterUrl(String master) {
        this.master = master;
        return this;
    }

    public String getMaster() {
        return this.master;
    }

    public KubernetesConnectionConfiguration setAccountToken(String accountToken) {
        this.accountToken = accountToken;
        return this;
    }

    public String getAccountToken() {
        return this.accountToken;
    }

    public KubernetesConnectionConfiguration setIncludeNotReadyAddresses(boolean includeNotReadyAddresses) {
        this.includeNotReadyAddresses = includeNotReadyAddresses;
        return this;
    }

    public boolean getIncludeNotReadyAddresses() {
        return this.includeNotReadyAddresses;
    }

    public void verify() {
        if (this.paramIsNotSet(this.srvcName) || this.paramIsNotSet(this.namespace) || this.paramIsNotSet(this.master) || this.paramIsNotSet(this.accountToken)) {
            throw new IgniteSpiException("One or more configuration parameters are invalid [setServiceName=" + this.srvcName + ", setNamespace=" + this.namespace + ", setMasterUrl=" + this.master + ", setAccountToken=" + this.accountToken + "]");
        }
    }

    private boolean paramIsNotSet(String param) {
        return param == null || param.isEmpty();
    }
}

