/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.table.IndexColumn;

public class SqlTableView {
    private final GridH2Table tbl;
    private String affColName;

    public SqlTableView(GridH2Table tbl) {
        this.tbl = tbl;
        IndexColumn affCol = tbl.getAffinityKeyColumn();
        if (affCol != null && !tbl.rowDescriptor().isKeyColumn(affCol.column.getColumnId())) {
            this.affColName = affCol.columnName;
        }
    }

    @Order
    public int cacheGroupId() {
        return this.tbl.cacheInfo().groupId();
    }

    @Order(value=1)
    public String cacheGroupName() {
        return this.tbl.cacheInfo().groupName();
    }

    @Order(value=2)
    public int cacheId() {
        return this.tbl.cacheId();
    }

    @Order(value=3)
    public String cacheName() {
        return this.tbl.cacheName();
    }

    @Order(value=4)
    public String schemaName() {
        return this.tbl.getSchema().getName();
    }

    @Order(value=5)
    public String tableName() {
        return this.tbl.identifier().table();
    }

    @Order(value=6)
    public String affinityKeyColumn() {
        return this.affColName;
    }

    @Order(value=7)
    public String keyAlias() {
        return this.tbl.rowDescriptor().type().keyFieldAlias();
    }

    @Order(value=8)
    public String valueAlias() {
        return this.tbl.rowDescriptor().type().valueFieldAlias();
    }

    @Order(value=9)
    public String keyTypeName() {
        return this.tbl.rowDescriptor().type().keyTypeName();
    }

    @Order(value=10)
    public String valueTypeName() {
        return this.tbl.rowDescriptor().type().valueTypeName();
    }

    public boolean isIndexRebuildInProgress() {
        return this.tbl.rebuildFromHashInProgress();
    }
}

