/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryRetryException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2FieldsIterator;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.ReduceH2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.dml.DmlDistributedUpdateRun;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceIndexIterator;
import org.apache.ignite.internal.processors.query.h2.twostep.ReducePartitionMapResult;
import org.apache.ignite.internal.processors.query.h2.twostep.ReducePartitionMapper;
import org.apache.ignite.internal.processors.query.h2.twostep.ReducePartitionsSpecializer;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceQueryRun;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceResultPage;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceTable;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceTableEngine;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceTableWrapper;
import org.apache.ignite.internal.processors.query.h2.twostep.Reducer;
import org.apache.ignite.internal.processors.query.h2.twostep.SortedReduceIndexAdapter;
import org.apache.ignite.internal.processors.query.h2.twostep.UnsortedOneWayReducer;
import org.apache.ignite.internal.processors.query.h2.twostep.UnsortedReduceIndexAdapter;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.transactions.IgniteTxAlreadyCompletedCheckedException;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.transactions.TransactionAlreadyCompletedException;
import org.apache.ignite.transactions.TransactionException;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.IntArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridReduceQueryExecutor {
    public static final long DFLT_RETRY_TIMEOUT = 30000L;
    private static final String MERGE_INDEX_UNSORTED = "merge_scan";
    private static final String MERGE_INDEX_SORTED = "merge_sorted";
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private IgniteLogger log;
    private final AtomicLong qryIdGen = new AtomicLong();
    private final ConcurrentMap<Long, ReduceQueryRun> runs = new ConcurrentHashMap<Long, ReduceQueryRun>();
    private final ConcurrentMap<Long, DmlDistributedUpdateRun> updRuns = new ConcurrentHashMap<Long, DmlDistributedUpdateRun>();
    private volatile List<ReduceTableWrapper> fakeTbls = Collections.emptyList();
    private final Lock fakeTblsLock = new ReentrantLock();
    private final CIX2<ClusterNode, Message> locNodeHnd = new CIX2<ClusterNode, Message>(){

        public void applyx(ClusterNode locNode, Message msg) {
            assert (msg instanceof GridQueryNextPageRequest || msg instanceof GridH2QueryRequest || msg instanceof GridH2DmlRequest || msg instanceof GridQueryCancelRequest) : msg.getClass();
            GridReduceQueryExecutor.this.h2.onMessage(locNode.id(), msg);
        }
    };
    private final long dfltQueryTimeout = IgniteSystemProperties.getLong((String)"IGNITE_SQL_RETRY_TIMEOUT", (long)30000L);
    private ReducePartitionMapper mapper;

    public void start(GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridReduceQueryExecutor.class);
        this.mapper = new ReducePartitionMapper(ctx, this.log);
    }

    public void onNodeLeft(DiscoveryEvent evt) {
        UUID nodeId = evt.eventNode().id();
        block0: for (Object r : this.runs.values()) {
            for (Reducer idx : ((ReduceQueryRun)r).reducers()) {
                if (!idx.hasSource(nodeId)) continue;
                this.handleNodeLeft((ReduceQueryRun)r, nodeId);
                continue block0;
            }
        }
        for (Object r : this.updRuns.values()) {
            ((DmlDistributedUpdateRun)r).handleNodeLeft(nodeId);
        }
    }

    private void handleNodeLeft(ReduceQueryRun r, UUID nodeId) {
        r.setStateOnNodeLeave(nodeId, this.h2.readyTopologyVersion());
    }

    public void onFail(ClusterNode node, GridQueryFailResponse msg) {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_FAIL_RESP, MTC.span()));){
            ReduceQueryRun r = (ReduceQueryRun)this.runs.get(msg.queryRequestId());
            this.fail(r, node.id(), msg.error(), msg.failCode());
        }
    }

    private void fail(ReduceQueryRun r, UUID nodeId, String msg, byte failCode) {
        if (r != null) {
            String mapperFailedMsg = "Failed to execute map query on remote node [nodeId=" + nodeId + ", errMsg=" + msg + ']';
            CacheException e = failCode == 1 ? new CacheException(mapperFailedMsg, (Throwable)new QueryCancelledException()) : (failCode == 2 ? new CacheException(mapperFailedMsg, (Throwable)new QueryRetryException(msg)) : new CacheException(mapperFailedMsg));
            r.setStateOnException(nodeId, e);
        }
    }

    public void onNextPage(final ClusterNode node, GridQueryNextPageResponse msg) {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_PAGE_RESP, MTC.span()));){
            ReduceResultPage page;
            final long qryReqId = msg.queryRequestId();
            final int qry = msg.query();
            final int seg = msg.segmentId();
            final ReduceQueryRun r = (ReduceQueryRun)this.runs.get(qryReqId);
            if (r == null) {
                return;
            }
            final int pageSize = r.pageSize();
            Reducer idx = r.reducers().get(msg.query());
            try {
                page = new ReduceResultPage(this.ctx, node.id(), msg){

                    @Override
                    public void fetchNextPage() {
                        if (r.hasErrorOrRetry()) {
                            if (r.exception() != null) {
                                throw r.exception();
                            }
                            assert (r.retryCause() != null);
                            throw new CacheException(r.retryCause());
                        }
                        try {
                            GridQueryNextPageRequest msg0 = new GridQueryNextPageRequest(qryReqId, qry, seg, pageSize, (byte)GridH2QueryRequest.setDataPageScanEnabled(0, r.isDataPageScanEnabled()));
                            if (node.isLocal()) {
                                GridReduceQueryExecutor.this.h2.mapQueryExecutor().onNextPageRequest(node, msg0);
                            } else {
                                GridReduceQueryExecutor.this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg0, (byte)10);
                            }
                        }
                        catch (IgniteCheckedException e) {
                            throw new CacheException("Failed to fetch data from node: " + node.id(), (Throwable)e);
                        }
                    }
                };
            }
            catch (Exception e) {
                U.error((IgniteLogger)this.log, (Object)"Error in message.", (Throwable)e);
                MTC.span().addTag("error", e::getMessage);
                this.fail(r, node.id(), "Error in message.", (byte)0);
                if (ignored != null) {
                    if (var4_4 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
                return;
            }
            idx.addPage(page);
            if (msg.retry() != null) {
                r.setStateOnRetry(node.id(), msg.retry(), msg.retryCause());
            } else if (msg.page() == 0) {
                r.onFirstPage();
            }
        }
    }

    private GridCacheContext<?, ?> cacheContext(Integer cacheId) {
        GridCacheContext cctx = this.ctx.cache().context().cacheContext(cacheId.intValue());
        if (cctx == null) {
            throw new CacheException(String.format("Cache not found on local node (was concurrently destroyed?) [cacheId=%d]", cacheId));
        }
        return cctx;
    }

    /*
     * Loose catch block
     */
    public Iterator<List<?>> query(String schemaName, GridCacheTwoStepQuery qry, boolean keepBinary, boolean enforceJoinOrder, int timeoutMillis, GridQueryCancel cancel, Object[] params, int[] parts, boolean lazy, MvccQueryTracker mvccTracker, Boolean dataPageScanEnabled, int pageSize) {
        boolean singlePartMode;
        assert (!qry.mvccEnabled() || mvccTracker != null);
        if (pageSize <= 0) {
            pageSize = 1024;
        }
        if (!qry.hasCacheIds() && parts != null) {
            parts = null;
        }
        if (parts != null && qry.isReplicatedOnly()) {
            throw new CacheException("Partitions are not supported for replicated caches");
        }
        try {
            if (qry.mvccEnabled()) {
                MvccUtils.checkActive((GridNearTxLocal)MvccUtils.tx((GridKernalContext)this.ctx));
            }
        }
        catch (IgniteTxAlreadyCompletedCheckedException e) {
            throw new TransactionAlreadyCompletedException(e.getMessage(), (Throwable)e);
        }
        boolean bl = singlePartMode = parts != null && parts.length == 1;
        if (F.isEmpty((Object[])params)) {
            params = GridCacheSqlQuery.EMPTY_PARAMS;
        }
        List<Integer> cacheIds = qry.cacheIds();
        List<GridCacheSqlQuery> mapQueries = this.prepareMapQueries(qry, params, singlePartMode);
        boolean skipMergeTbl = !qry.explain() && qry.skipMergeTable() || singlePartMode;
        int segmentsPerIndex = qry.explain() || qry.isReplicatedOnly() ? 1 : this.mapper.findFirstPartitioned(cacheIds).config().getQueryParallelism();
        long retryTimeout = this.retryTimeout(timeoutMillis);
        long qryStartTime = U.currentTimeMillis();
        ReduceQueryRun lastRun = null;
        int attempt = 0;
        while (true) {
            block47: {
                AffinityTopologyVersion topVer;
                this.ensureQueryNotCancelled(cancel);
                if (attempt > 0) {
                    this.throttleOnRetry(lastRun, qryStartTime, retryTimeout, attempt);
                    this.ensureQueryNotCancelled(cancel);
                }
                if (this.h2.serverTopologyChanged(topVer = this.h2.readyTopologyVersion()) && this.ctx.cache().context().lockedTopologyVersion(null) != null) {
                    throw new CacheException((Throwable)new TransactionException("Server topology is changed during query execution inside a transaction. It's recommended to rollback and retry transaction."));
                }
                ReducePartitionMapResult mapping = this.createMapping(qry, parts, cacheIds, topVer);
                if (mapping != null) {
                    Collection<ClusterNode> nodes = mapping.nodes();
                    assert (!F.isEmpty(nodes));
                    H2PooledConnection conn = this.h2.connections().connection(schemaName);
                    long qryReqId = this.qryIdGen.incrementAndGet();
                    this.h2.runningQueryManager().trackRequestId(qryReqId);
                    boolean retry = false;
                    boolean release = true;
                    try {
                        ReduceQueryRun r = this.createReduceQueryRun(conn, mapQueries, nodes, pageSize, segmentsPerIndex, skipMergeTbl, qry.explain(), dataPageScanEnabled);
                        this.runs.put(qryReqId, r);
                        try {
                            Object resIter;
                            ReducePartitionsSpecializer spec;
                            cancel.add(() -> this.send(nodes, (Message)new GridQueryCancelRequest(qryReqId), null, true));
                            GridH2QueryRequest req = new GridH2QueryRequest().requestId(qryReqId).topologyVersion(topVer).pageSize(pageSize).caches(qry.cacheIds()).tables(qry.distributedJoins() ? qry.tables() : null).partitions(GridReduceQueryExecutor.convert(mapping.partitionsMap())).queries(mapQueries).parameters(params).flags(this.queryFlags(qry, enforceJoinOrder, lazy, dataPageScanEnabled)).timeout(timeoutMillis).explicitTimeout(true).schemaName(schemaName);
                            if (mvccTracker != null) {
                                req.mvccSnapshot(mvccTracker.snapshot());
                            }
                            ReducePartitionsSpecializer reducePartitionsSpecializer = spec = parts == null ? null : new ReducePartitionsSpecializer(mapping.queryPartitionsMap());
                            if (this.send(nodes, req, (IgniteBiClosure<ClusterNode, Message, Message>)spec, false)) {
                                this.awaitAllReplies(r, nodes, cancel);
                                if (r.hasErrorOrRetry()) {
                                    CacheException err = r.exception();
                                    if (err != null) {
                                        if (err.getCause() instanceof IgniteClientDisconnectedException) {
                                            throw err;
                                        }
                                        if (QueryUtils.wasCancelled((Throwable)err)) {
                                            throw new QueryCancelledException();
                                        }
                                        throw err;
                                    }
                                    retry = true;
                                    this.h2.awaitForReadyTopologyVersion(r.retryTopologyVersion());
                                }
                            } else {
                                retry = true;
                            }
                            if (retry) {
                                lastRun = (ReduceQueryRun)this.runs.remove(qryReqId);
                                assert (lastRun != null);
                            }
                            if (skipMergeTbl) {
                                resIter = new ReduceIndexIterator(this, nodes, r, qryReqId, qry.distributedJoins(), mvccTracker, this.ctx.tracing());
                                release = false;
                                U.close((AutoCloseable)conn, (IgniteLogger)this.log);
                            } else {
                                this.ensureQueryNotCancelled(cancel);
                                QueryContext qctx = new QueryContext(0, null, null, null, null, true);
                                H2Utils.setupConnection(conn, qctx, false, enforceJoinOrder);
                                if (qry.explain()) {
                                    Iterator<List<?>> iterator = this.explainPlan(conn, qry, params);
                                    return iterator;
                                }
                                GridCacheSqlQuery rdc = qry.reduceQuery();
                                PreparedStatement stmt = conn.prepareStatementNoCache(rdc.query());
                                H2Utils.bindParameters(stmt, F.asList((Object[])rdc.parameters(params)));
                                ReduceH2QueryInfo qryInfo = new ReduceH2QueryInfo(stmt, qry.originalSql(), qryReqId);
                                ResultSet res = this.h2.executeSqlQueryWithTimer(stmt, conn, rdc.query(), timeoutMillis, cancel, dataPageScanEnabled, (H2QueryInfo)qryInfo);
                                resIter = new H2FieldsIterator(res, mvccTracker, conn, r.pageSize(), this.log, this.h2, qryInfo, this.ctx.tracing());
                                conn = null;
                                mvccTracker = null;
                            }
                            GridQueryCacheObjectsIterator gridQueryCacheObjectsIterator = new GridQueryCacheObjectsIterator((Iterator)resIter, this.h2.objectContext(), keepBinary);
                            return gridQueryCacheObjectsIterator;
                        }
                        catch (RuntimeException | IgniteCheckedException e) {
                            Throwable disconnectedErr;
                            release = true;
                            if (e instanceof CacheException) {
                                if (QueryUtils.wasCancelled((Throwable)e)) {
                                    throw new CacheException("Failed to run reduce query locally.", (Throwable)new QueryCancelledException());
                                }
                                throw (CacheException)e;
                            }
                            Throwable cause = e;
                            if (e instanceof IgniteCheckedException && (disconnectedErr = ((IgniteCheckedException)e).getCause(IgniteClientDisconnectedException.class)) != null) {
                                cause = disconnectedErr;
                            }
                            throw new CacheException("Failed to run reduce query locally. " + cause.getMessage(), cause);
                        }
                        finally {
                            if (release) {
                                this.releaseRemoteResources(nodes, r, qryReqId, qry.distributedJoins(), mvccTracker);
                                if (!skipMergeTbl) {
                                    int mapQrys = mapQueries.size();
                                    for (int i = 0; i < mapQrys; ++i) {
                                        this.fakeTable(null, i).innerTable(null);
                                    }
                                }
                            }
                            break block47;
                        }
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (conn != null && (retry || release)) {
                            U.close((AutoCloseable)conn, (IgniteLogger)this.log);
                        }
                    }
                }
            }
            ++attempt;
        }
    }

    private void throttleOnRetry(@Nullable ReduceQueryRun lastRun, long startTime, long retryTimeout, int timeoutMultiplier) {
        if (retryTimeout > 0L && U.currentTimeMillis() - startTime > retryTimeout) {
            if (lastRun == null || lastRun.retryCause() == null) {
                throw new CacheException("Failed to map SQL query to topology during timeout: " + retryTimeout + "ms");
            }
            UUID retryNodeId = lastRun.retryNodeId();
            String retryCause = lastRun.retryCause();
            throw new CacheException("Failed to map SQL query to topology on data node [dataNodeId=" + retryNodeId + ", msg=" + retryCause + ']');
        }
        try {
            Thread.sleep(Math.min(10000, timeoutMultiplier * 10));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException("Query was interrupted.", (Throwable)e);
        }
    }

    private void ensureQueryNotCancelled(GridQueryCancel cancel) {
        if (Thread.currentThread().isInterrupted()) {
            throw new CacheException((Throwable)new IgniteInterruptedCheckedException("Query was interrupted."));
        }
        try {
            cancel.checkCancelled();
        }
        catch (QueryCancelledException cancelEx) {
            throw new CacheException("Failed to run reduce query locally. " + cancelEx.getMessage(), (Throwable)cancelEx);
        }
        if (this.ctx.clientDisconnected()) {
            throw new CacheException("Query was cancelled, client node disconnected.", (Throwable)new IgniteClientDisconnectedException(this.ctx.cluster().clientReconnectFuture(), "Client node disconnected."));
        }
    }

    @NotNull
    private List<GridCacheSqlQuery> prepareMapQueries(GridCacheTwoStepQuery qry, Object[] params, boolean singlePartMode) {
        List<GridCacheSqlQuery> mapQueries;
        if (singlePartMode) {
            mapQueries = this.prepareMapQueryForSinglePartition(qry, params);
        } else {
            mapQueries = new ArrayList<GridCacheSqlQuery>(qry.mapQueries().size());
            for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
                GridCacheSqlQuery copy = mapQry.copy();
                mapQueries.add(copy);
                if (!qry.explain()) continue;
                copy.query("EXPLAIN " + mapQry.query()).parameterIndexes(mapQry.parameterIndexes());
            }
        }
        return mapQueries;
    }

    @NotNull
    private ReduceQueryRun createReduceQueryRun(H2PooledConnection conn, List<GridCacheSqlQuery> mapQueries, Collection<ClusterNode> nodes, int pageSize, int segmentsPerIndex, boolean skipMergeTbl, boolean explain, Boolean dataPageScanEnabled) {
        ReduceQueryRun r = new ReduceQueryRun(mapQueries.size(), pageSize, dataPageScanEnabled);
        int tblIdx = 0;
        int replicatedQrysCnt = 0;
        for (GridCacheSqlQuery mapQry : mapQueries) {
            Reducer reducer;
            if (skipMergeTbl) {
                reducer = UnsortedOneWayReducer.createDummy(this.ctx);
            } else {
                ReduceTable tbl;
                try {
                    tbl = this.createMergeTable(conn, mapQry, explain);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
                reducer = tbl.getReducer();
                this.fakeTable(conn, tblIdx++).innerTable(tbl);
            }
            if (!mapQry.isPartitioned()) {
                ClusterNode node = (ClusterNode)F.rand(nodes);
                mapQry.node(node.id());
                ++replicatedQrysCnt;
                reducer.setSources(Collections.singletonList(node), 1);
            } else {
                reducer.setSources(nodes, segmentsPerIndex);
            }
            reducer.setPageSize(r.pageSize());
            r.reducers().add(reducer);
        }
        r.init((r.reducers().size() - replicatedQrysCnt) * nodes.size() * segmentsPerIndex + replicatedQrysCnt);
        return r;
    }

    private int queryFlags(GridCacheTwoStepQuery qry, boolean enforceJoinOrder, boolean lazy, Boolean dataPageScanEnabled) {
        if (qry.distributedJoins()) {
            enforceJoinOrder = true;
        }
        return GridH2QueryRequest.queryFlags(qry.distributedJoins(), enforceJoinOrder, lazy, qry.isReplicatedOnly(), qry.explain(), dataPageScanEnabled, qry.treatReplicatedAsPartitioned());
    }

    private ReducePartitionMapResult createMapping(GridCacheTwoStepQuery qry, @Nullable int[] parts, List<Integer> cacheIds, AffinityTopologyVersion topVer) {
        if (qry.isLocalSplit() || !qry.hasCacheIds()) {
            return new ReducePartitionMapResult(Collections.singletonList(this.ctx.discovery().localNode()), null, null);
        }
        ReducePartitionMapResult nodesParts = this.mapper.nodesForPartitions(cacheIds, topVer, parts, qry.isReplicatedOnly());
        Collection<ClusterNode> nodes = nodesParts.nodes();
        if (F.isEmpty(nodes)) {
            return null;
        }
        if (qry.explain() || qry.isReplicatedOnly()) {
            ClusterNode locNode = this.ctx.discovery().localNode();
            nodes = nodes.contains(locNode) ? Collections.singletonList(locNode) : Collections.singletonList(F.rand(nodes));
            return new ReducePartitionMapResult(nodes, nodesParts.partitionsMap(), nodesParts.queryPartitionsMap());
        }
        return nodesParts;
    }

    public UpdateResult update(String schemaName, List<Integer> cacheIds, String selectQry, Object[] params, boolean enforceJoinOrder, int pageSize, int timeoutMillis, int[] parts, boolean isReplicatedOnly, GridQueryCancel cancel) {
        int flags;
        AffinityTopologyVersion topVer = this.h2.readyTopologyVersion();
        ReducePartitionMapResult nodesParts = this.mapper.nodesForPartitions(cacheIds, topVer, parts, isReplicatedOnly);
        Collection<ClusterNode> nodes = nodesParts.nodes();
        if (F.isEmpty(nodes)) {
            throw new CacheException("Failed to determine nodes participating in the update. Explanation (Retry update once topology recovers).");
        }
        if (isReplicatedOnly) {
            ClusterNode locNode = this.ctx.discovery().localNode();
            nodes = nodes.contains(locNode) ? Collections.singletonList(locNode) : Collections.singletonList(F.rand(nodes));
        }
        for (ClusterNode n : nodes) {
            if (n.version().greaterThanEqual(2, 3, 0)) continue;
            this.log.warning("Server-side DML optimization is skipped because map node does not support it. Falling back to normal DML. [node=" + n.id() + ", v=" + n.version() + "].");
            return null;
        }
        long reqId = this.qryIdGen.incrementAndGet();
        this.h2.runningQueryManager().trackRequestId(reqId);
        DmlDistributedUpdateRun r = new DmlDistributedUpdateRun(nodes.size());
        int n = flags = enforceJoinOrder ? 2 : 0;
        if (isReplicatedOnly) {
            flags |= 0x10;
        }
        GridH2DmlRequest req = new GridH2DmlRequest().requestId(reqId).topologyVersion(topVer).caches(cacheIds).schemaName(schemaName).query(selectQry).pageSize(pageSize).parameters(params).timeout(timeoutMillis).explicitTimeout(true).flags(flags);
        this.updRuns.put(reqId, r);
        boolean release = false;
        try {
            Map<ClusterNode, IntArray> partsMap = nodesParts.queryPartitionsMap() != null ? nodesParts.queryPartitionsMap() : nodesParts.partitionsMap();
            ReducePartitionsSpecializer partsSpec = parts == null ? null : new ReducePartitionsSpecializer(partsMap);
            Collection<ClusterNode> finalNodes = nodes;
            cancel.add(() -> {
                r.future().onCancelled();
                this.send(finalNodes, (Message)new GridQueryCancelRequest(reqId), null, true);
            });
            if (this.send(nodes, req, (IgniteBiClosure<ClusterNode, Message, Message>)partsSpec, false)) {
                UpdateResult updateResult = (UpdateResult)r.future().get();
                return updateResult;
            }
            try {
                throw new CacheException("Failed to send update request to participating nodes.");
            }
            catch (RuntimeException | IgniteCheckedException e) {
                release = true;
                U.error((IgniteLogger)this.log, (Object)("Error during update [localNodeId=" + this.ctx.localNodeId() + "]"), (Throwable)e);
                throw new CacheException("Failed to run SQL update query. " + e.getMessage(), e);
            }
        }
        finally {
            if (release) {
                this.send(nodes, (Message)new GridQueryCancelRequest(reqId), null, false);
            }
            if (!this.updRuns.remove(reqId, r)) {
                U.warn((IgniteLogger)this.log, (Object)("Update run was already removed: " + reqId));
            }
        }
    }

    public void onDmlResponse(ClusterNode node, GridH2DmlResponse msg) {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_DML_QRY_RESP, MTC.span()));){
            long reqId = msg.requestId();
            DmlDistributedUpdateRun r = (DmlDistributedUpdateRun)this.updRuns.get(reqId);
            if (r == null) {
                U.warn((IgniteLogger)this.log, (Object)("Unexpected dml response (will ignore). [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", msg=" + msg.toString() + ']'));
                return;
            }
            r.handleResponse(node.id(), msg);
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Error in dml response processing. [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", msg=" + msg.toString() + ']'), (Throwable)e);
        }
    }

    void releaseRemoteResources(Collection<ClusterNode> nodes, ReduceQueryRun r, long qryReqId, boolean distributedJoins, MvccQueryTracker mvccTracker) {
        if (distributedJoins) {
            this.send(nodes, (Message)new GridQueryCancelRequest(qryReqId), null, true);
        }
        for (Reducer idx : r.reducers()) {
            if (idx.fetchedAll()) continue;
            if (!distributedJoins) {
                this.send(nodes, (Message)new GridQueryCancelRequest(qryReqId), null, true);
            }
            r.setStateOnException(this.ctx.localNodeId(), new CacheException("Query is canceled.", (Throwable)new QueryCancelledException()));
            break;
        }
        if (!this.runs.remove(qryReqId, r)) {
            U.warn((IgniteLogger)this.log, (Object)("Query run was already removed: " + qryReqId));
        } else if (mvccTracker != null) {
            mvccTracker.onDone();
        }
    }

    private void awaitAllReplies(ReduceQueryRun r, Collection<ClusterNode> nodes, GridQueryCancel cancel) throws IgniteInterruptedCheckedException, QueryCancelledException {
        while (!r.tryMapToSources(500L, TimeUnit.MILLISECONDS)) {
            cancel.checkCancelled();
            for (ClusterNode node : nodes) {
                if (this.ctx.discovery().alive(node)) continue;
                this.handleNodeLeft(r, node.id());
                assert (r.mapped());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReduceTableWrapper fakeTable(H2PooledConnection c, int idx) {
        List<ReduceTableWrapper> tbls = this.fakeTbls;
        assert (tbls.size() >= idx);
        if (tbls.size() == idx) {
            this.fakeTblsLock.lock();
            try {
                tbls = this.fakeTbls;
                if (tbls.size() == idx) {
                    ReduceTableWrapper tbl = ReduceTableEngine.create(c.connection(), idx);
                    ArrayList<ReduceTableWrapper> newTbls = new ArrayList<ReduceTableWrapper>(tbls.size() + 1);
                    newTbls.addAll(tbls);
                    newTbls.add(tbl);
                    this.fakeTbls = tbls = newTbls;
                }
            }
            finally {
                this.fakeTblsLock.unlock();
            }
        }
        return tbls.get(idx);
    }

    private Iterator<List<?>> explainPlan(H2PooledConnection c, GridCacheTwoStepQuery qry, Object[] params) throws IgniteCheckedException {
        ResultSet rs;
        ArrayList<List> lists = new ArrayList<List>(qry.mapQueries().size() + 1);
        int mapQrys = qry.mapQueries().size();
        for (int i = 0; i < mapQrys; ++i) {
            rs = this.h2.executeSqlQueryWithTimer(c, "SELECT PLAN FROM " + GridSqlQuerySplitter.mergeTableIdentifier(i), null, 0, null, null, null);
            lists.add(F.asList((Object)this.getPlan(rs)));
        }
        int tblIdx = 0;
        for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
            ReduceTable tbl = this.createMergeTable(c, mapQry, false);
            this.fakeTable(c, tblIdx++).innerTable(tbl);
        }
        GridCacheSqlQuery rdc = qry.reduceQuery();
        rs = this.h2.executeSqlQueryWithTimer(c, "EXPLAIN " + rdc.query(), F.asList((Object[])rdc.parameters(params)), 0, null, null, null);
        lists.add(F.asList((Object)this.getPlan(rs)));
        return lists.iterator();
    }

    private String getPlan(ResultSet rs) throws IgniteCheckedException {
        try {
            if (!rs.next()) {
                throw new IllegalStateException();
            }
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        finally {
            U.closeQuiet((AutoCloseable)rs);
        }
    }

    public boolean send(Collection<ClusterNode> nodes, Message msg, @Nullable IgniteBiClosure<ClusterNode, Message, Message> specialize, boolean runLocParallel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending: [msg=" + msg + ", nodes=" + nodes + ", specialize=" + specialize + "]");
        }
        return this.h2.send(GridTopic.TOPIC_QUERY, GridTopic.TOPIC_QUERY.ordinal(), nodes, msg, specialize, (IgniteInClosure2X<ClusterNode, Message>)this.locNodeHnd, (byte)10, runLocParallel);
    }

    public static int[] toArray(IntArray ints) {
        int[] res = new int[ints.size()];
        ints.toArray(res);
        return res;
    }

    private static Map<UUID, int[]> convert(Map<ClusterNode, IntArray> m) {
        if (m == null) {
            return null;
        }
        HashMap res = U.newHashMap((int)m.size());
        for (Map.Entry<ClusterNode, IntArray> entry : m.entrySet()) {
            res.put(entry.getKey().id(), GridReduceQueryExecutor.toArray(entry.getValue()));
        }
        return res;
    }

    private ReduceTable createMergeTable(H2PooledConnection conn, GridCacheSqlQuery qry, boolean explain) throws IgniteCheckedException {
        try {
            Session ses = H2Utils.session(conn);
            CreateTableData data = new CreateTableData();
            data.tableName = "T___";
            data.schema = ses.getDatabase().getSchema(ses.getCurrentSchemaName());
            data.create = true;
            if (!explain) {
                LinkedHashMap colsMap = qry.columns();
                assert (colsMap != null);
                ArrayList<Column> cols = new ArrayList<Column>(colsMap.size());
                for (Map.Entry e : colsMap.entrySet()) {
                    String alias = (String)e.getKey();
                    GridSqlType type = (GridSqlType)e.getValue();
                    assert (!F.isEmpty((String)alias));
                    Column col0 = type == GridSqlType.UNKNOWN ? new Column(alias, 13) : new Column(alias, type.type(), type.precision(), type.scale(), type.displaySize());
                    cols.add(col0);
                }
                data.columns = cols;
            } else {
                data.columns = GridReduceQueryExecutor.planColumns();
            }
            boolean sortedIndex = !F.isEmpty((Collection)qry.sortColumns());
            ReduceTable tbl = new ReduceTable(data);
            ArrayList<Index> idxs = new ArrayList<Index>(2);
            if (explain) {
                idxs.add((Index)new UnsortedReduceIndexAdapter(this.ctx, tbl, sortedIndex ? MERGE_INDEX_SORTED : MERGE_INDEX_UNSORTED));
            } else if (sortedIndex) {
                List sortCols = qry.sortColumns();
                SortedReduceIndexAdapter sortedMergeIdx = new SortedReduceIndexAdapter(this.ctx, tbl, MERGE_INDEX_SORTED, GridSqlSortColumn.toIndexColumns((Table)tbl, sortCols));
                idxs.add((Index)ReduceTable.createScanIndex(sortedMergeIdx));
                idxs.add((Index)sortedMergeIdx);
            } else {
                idxs.add((Index)new UnsortedReduceIndexAdapter(this.ctx, tbl, MERGE_INDEX_UNSORTED));
            }
            tbl.indexes(idxs);
            return tbl;
        }
        catch (Exception e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private static ArrayList<Column> planColumns() {
        ArrayList<Column> res = new ArrayList<Column>(1);
        res.add(new Column("PLAN", 13));
        return res;
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        CacheException err = new CacheException("Query was cancelled, client node disconnected.", (Throwable)new IgniteClientDisconnectedException(reconnectFut, "Client node disconnected."));
        for (Map.Entry e : this.runs.entrySet()) {
            ((ReduceQueryRun)e.getValue()).disconnected(err);
        }
        for (DmlDistributedUpdateRun r : this.updRuns.values()) {
            r.handleDisconnect(err);
        }
    }

    private long retryTimeout(long qryTimeout) {
        if (qryTimeout > 0L) {
            return qryTimeout;
        }
        return this.dfltQueryTimeout;
    }

    private List<GridCacheSqlQuery> prepareMapQueryForSinglePartition(GridCacheTwoStepQuery qry, Object[] params) {
        boolean hasSubQries = false;
        for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
            if (!mapQry.hasSubQueries()) continue;
            hasSubQries = true;
            break;
        }
        GridCacheSqlQuery originalQry = new GridCacheSqlQuery(qry.originalSql());
        if (!F.isEmpty((Object[])params)) {
            int[] paramIdxs = new int[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramIdxs[i] = i;
            }
            originalQry.parameterIndexes(paramIdxs);
        }
        originalQry.partitioned(true);
        originalQry.hasSubQueries(hasSubQries);
        return Collections.singletonList(originalQry);
    }
}

