/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryRetryException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsQueryHelper;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.MapH2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.opt.join.DistributedJoinContext;
import org.apache.ignite.internal.processors.query.h2.twostep.MapNodeResults;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResult;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResults;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservation;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.jdbc.JdbcResultSet;
import org.h2.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMapQueryExecutor {
    private IgniteLogger log;
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private QueryContextRegistry qryCtxRegistry;
    private ConcurrentMap<UUID, MapNodeResults> qryRess = new ConcurrentHashMap<UUID, MapNodeResults>();

    public void start(GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.qryCtxRegistry = h2.queryContextRegistry();
        this.log = ctx.log(GridMapQueryExecutor.class);
    }

    public void onNodeLeft(DiscoveryEvent evt) {
        UUID nodeId = evt.eventNode().id();
        this.qryCtxRegistry.clearSharedOnRemoteNodeStop(nodeId);
        MapNodeResults nodeRess = (MapNodeResults)this.qryRess.remove(nodeId);
        if (nodeRess == null) {
            return;
        }
        nodeRess.cancelAll();
    }

    public void stop() {
        for (MapNodeResults res : this.qryRess.values()) {
            res.cancelAll();
        }
    }

    public void onCancel(ClusterNode node, GridQueryCancelRequest msg) {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_QRY_CANCEL_REQ, MTC.span()));){
            long qryReqId = msg.queryRequestId();
            MapNodeResults nodeRess = this.resultsForNode(node.id());
            boolean clear = this.qryCtxRegistry.clearShared(node.id(), qryReqId);
            if (!clear) {
                nodeRess.onCancel(qryReqId);
                this.qryCtxRegistry.clearShared(node.id(), qryReqId);
            }
            nodeRess.cancelRequest(qryReqId);
        }
    }

    private MapNodeResults resultsForNode(UUID nodeId) {
        MapNodeResults old;
        MapNodeResults nodeRess = (MapNodeResults)this.qryRess.get(nodeId);
        if (nodeRess == null && (old = this.qryRess.putIfAbsent(nodeId, nodeRess = new MapNodeResults(nodeId))) != null) {
            nodeRess = old;
        }
        return nodeRess;
    }

    public void onQueryRequest(ClusterNode node, GridH2QueryRequest req) throws IgniteCheckedException {
        int[] qryParts = req.queryPartitions();
        Map<UUID, int[]> partsMap = req.partitions();
        int[] parts = qryParts == null ? (Object)(partsMap == null ? null : partsMap.get(this.ctx.localNodeId())) : qryParts;
        boolean distributedJoins = req.isFlagSet(1);
        boolean enforceJoinOrder = req.isFlagSet(2);
        boolean explain = req.isFlagSet(8);
        boolean replicated = req.isFlagSet(16);
        boolean lazy = req.isFlagSet(32);
        boolean treatReplicatedAsPartitioned = req.isFlagSet(4);
        Boolean dataPageScanEnabled = req.isDataPageScanEnabled();
        List<Integer> cacheIds = req.caches();
        int segments = explain || replicated || F.isEmpty(cacheIds) ? 1 : CU.firstPartitioned((GridCacheSharedContext)this.ctx.cache().context(), cacheIds).config().getQueryParallelism();
        Object[] params = req.parameters();
        int timeout = req.timeout() > 0 || req.explicitTimeout() ? req.timeout() : this.h2.distributedConfiguration().defaultQueryTimeout();
        int i = 1;
        while (i < segments) {
            assert (!F.isEmpty(cacheIds));
            int segment = i++;
            Span span = MTC.span();
            this.ctx.closure().callLocal((Callable)((GridPlainCallable)() -> {
                try (MTC.TraceSurroundings ignored = MTC.supportContinual((Span)span);){
                    this.onQueryRequest0(node, req.requestId(), segment, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), distributedJoins, enforceJoinOrder, false, timeout, params, lazy, req.mvccSnapshot(), dataPageScanEnabled, treatReplicatedAsPartitioned);
                    Void void_ = null;
                    return void_;
                }
            }), (byte)10);
        }
        this.onQueryRequest0(node, req.requestId(), 0, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), distributedJoins, enforceJoinOrder, replicated, timeout, params, lazy, req.mvccSnapshot(), dataPageScanEnabled, treatReplicatedAsPartitioned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryRequest0(ClusterNode node, long reqId, int segmentId, String schemaName, Collection<GridCacheSqlQuery> qrys, List<Integer> cacheIds, AffinityTopologyVersion topVer, Map<UUID, int[]> partsMap, int[] parts, int pageSize, boolean distributedJoins, boolean enforceJoinOrder, boolean replicated, int timeout, Object[] params, boolean lazy, @Nullable MvccSnapshot mvccSnapshot, Boolean dataPageScanEnabled, boolean treatReplicatedAsPartitioned) {
        boolean performanceStatsEnabled = this.ctx.performanceStatistics().enabled();
        if (performanceStatsEnabled) {
            IoStatisticsQueryHelper.startGatheringQueryStatistics();
        }
        GridCacheContext mainCctx = this.mainCacheContext(cacheIds);
        MapNodeResults nodeRess = this.resultsForNode(node.id());
        MapQueryResults qryResults = null;
        PartitionReservation reserved = null;
        QueryContext qctx = null;
        MTC.TraceSurroundings trace = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_QRY_EXEC_REQ, MTC.span()).addTag("sql.query.text", () -> qrys.stream().map(GridCacheSqlQuery::query).collect(Collectors.joining("; "))));
        try {
            if (topVer != null && (reserved = this.h2.partitionReservationManager().reservePartitions(cacheIds, topVer, parts, node.id(), reqId)).failed()) {
                this.sendRetry(node, reqId, segmentId, reserved.error());
                return;
            }
            DistributedJoinContext distributedJoinCtx = null;
            if (distributedJoins && !replicated) {
                distributedJoinCtx = new DistributedJoinContext(topVer, partsMap, node.id(), reqId, segmentId, pageSize);
            }
            qctx = new QueryContext(segmentId, this.h2.backupFilter(topVer, parts, treatReplicatedAsPartitioned), distributedJoinCtx, mvccSnapshot, reserved, true);
            qryResults = new MapQueryResults(this.h2, reqId, qrys.size(), mainCctx, lazy, qctx);
            reserved = null;
            if (distributedJoinCtx != null) {
                this.qryCtxRegistry.setShared(node.id(), reqId, qctx);
            }
            if (nodeRess.put(reqId, segmentId, qryResults) != null) {
                throw new IllegalStateException();
            }
            if (nodeRess.cancelled(reqId)) {
                this.qryCtxRegistry.clearShared(node.id(), reqId);
                nodeRess.cancelRequest(reqId);
                throw new QueryCancelledException();
            }
            int qryIdx = 0;
            boolean evt = mainCctx != null && mainCctx.events().isRecordable(96);
            for (GridCacheSqlQuery qry : qrys) {
                H2PooledConnection conn = this.h2.connections().connection(schemaName);
                H2Utils.setupConnection(conn, qctx, distributedJoins, enforceJoinOrder, lazy);
                MapQueryResult res = new MapQueryResult(this.h2, mainCctx, node.id(), qry, params, conn, this.log);
                qryResults.addResult(qryIdx, res);
                try {
                    res.lock();
                    if (qry.node() == null || segmentId == 0 && qry.node().equals(this.ctx.localNodeId())) {
                        String sql = qry.query();
                        List params0 = F.asList((Object[])qry.parameters(params));
                        PreparedStatement stmt = conn.prepareStatement(sql, H2StatementCache.queryFlags(distributedJoins, enforceJoinOrder));
                        H2Utils.bindParameters(stmt, params0);
                        MapH2QueryInfo qryInfo = new MapH2QueryInfo(stmt, qry.query(), node, reqId, segmentId);
                        ResultSet rs = this.h2.executeSqlQueryWithTimer(stmt, conn, sql, timeout, qryResults.queryCancel(qryIdx), dataPageScanEnabled, (H2QueryInfo)qryInfo);
                        if (evt) {
                            this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL.name(), mainCctx.name(), null, qry.query(), null, null, params, node.id(), null));
                        }
                        assert (rs instanceof JdbcResultSet) : rs.getClass();
                        if (qryResults.cancelled()) {
                            rs.close();
                            throw new QueryCancelledException();
                        }
                        res.openResult(rs, qryInfo);
                        GridQueryNextPageResponse msg = this.prepareNextPage(nodeRess, node, qryResults, qryIdx, segmentId, pageSize, dataPageScanEnabled);
                        if (msg != null) {
                            this.sendNextPage(node, msg);
                        }
                    } else {
                        assert (!qry.isPartitioned());
                        qryResults.closeResult(qryIdx);
                    }
                    ++qryIdx;
                }
                finally {
                    try {
                        res.unlockTables();
                    }
                    finally {
                        res.unlock();
                    }
                }
            }
            if (!lazy) {
                qryResults.releaseQueryContext();
            }
        }
        catch (Throwable e) {
            if (qryResults != null) {
                nodeRess.remove(reqId, segmentId, qryResults);
                qryResults.close();
                if (!lazy || !qryResults.isAllClosed()) {
                    qryResults.releaseQueryContext();
                }
            } else {
                this.releaseReservations(qctx);
            }
            if (e instanceof QueryCancelledException) {
                this.sendError(node, reqId, e);
            } else {
                SQLException sqlEx = (SQLException)X.cause((Throwable)e, SQLException.class);
                if (sqlEx != null && sqlEx.getErrorCode() == 57014) {
                    this.sendQueryCancel(node, reqId);
                } else {
                    GridH2RetryException retryErr = (GridH2RetryException)((Object)X.cause((Throwable)e, GridH2RetryException.class));
                    if (retryErr != null) {
                        String retryCause = String.format("Failed to execute non-collocated query (will retry) [localNodeId=%s, rmtNodeId=%s, reqId=%s, errMsg=%s]", this.ctx.localNodeId(), node.id(), reqId, retryErr.getMessage());
                        this.sendRetry(node, reqId, segmentId, retryCause);
                    } else {
                        QueryRetryException qryRetryErr = (QueryRetryException)X.cause((Throwable)e, QueryRetryException.class);
                        if (qryRetryErr != null) {
                            this.sendError(node, reqId, (Throwable)qryRetryErr);
                        } else {
                            U.error((IgniteLogger)this.log, (Object)"Failed to execute local query.", (Throwable)e);
                            this.sendError(node, reqId, e);
                            if (e instanceof Error) {
                                throw (Error)e;
                            }
                        }
                    }
                }
            }
        }
        finally {
            IoStatisticsHolder stat;
            if (reserved != null) {
                reserved.release();
            }
            if (trace != null) {
                trace.close();
            }
            if (performanceStatsEnabled && ((stat = IoStatisticsQueryHelper.finishGatheringQueryStatistics()).logicalReads() > 0L || stat.physicalReads() > 0L)) {
                this.ctx.performanceStatistics().queryReads(GridCacheQueryType.SQL_FIELDS, node.id(), reqId, stat.logicalReads(), stat.physicalReads());
            }
        }
    }

    private GridCacheContext mainCacheContext(List<Integer> cacheIds) {
        return !F.isEmpty(cacheIds) ? this.ctx.cache().context().cacheContext(cacheIds.get(0).intValue()) : null;
    }

    private void releaseReservations(QueryContext qctx) {
        if (qctx != null && qctx.distributedJoinContext() == null) {
            qctx.clearContext(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDmlRequest(ClusterNode node, GridH2DmlRequest req) {
        int[] parts = req.queryPartitions();
        List<Integer> cacheIds = req.caches();
        long reqId = req.requestId();
        AffinityTopologyVersion topVer = req.topologyVersion();
        PartitionReservation reserved = null;
        MapNodeResults nodeResults = this.resultsForNode(node.id());
        MTC.TraceSurroundings trace = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_DML_QRY_EXEC_REQ, MTC.span()).addTag("sql.query.text", req::query));
        try {
            boolean evt;
            reserved = this.h2.partitionReservationManager().reservePartitions(cacheIds, topVer, parts, node.id(), reqId);
            if (reserved.failed()) {
                U.error((IgniteLogger)this.log, (Object)("Failed to reserve partitions for DML request. [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", reqId=" + req.requestId() + ", cacheIds=" + cacheIds + ", topVer=" + topVer + ", parts=" + Arrays.toString(parts) + ']'));
                this.sendUpdateResponse(node, reqId, null, "Failed to reserve partitions for DML request. " + reserved.error());
                return;
            }
            IndexingQueryFilter filter = this.h2.backupFilter(topVer, parts);
            GridQueryCancel cancel = nodeResults.putUpdate(reqId);
            SqlFieldsQuery fldsQry = new SqlFieldsQuery(req.query());
            if (req.parameters() != null) {
                fldsQry.setArgs(req.parameters());
            }
            fldsQry.setEnforceJoinOrder(req.isFlagSet(2));
            fldsQry.setPageSize(req.pageSize());
            fldsQry.setLocal(true);
            if (req.timeout() > 0 || req.explicitTimeout()) {
                fldsQry.setTimeout(req.timeout(), TimeUnit.MILLISECONDS);
            }
            boolean local = true;
            boolean replicated = req.isFlagSet(16);
            if (!replicated && !F.isEmpty(cacheIds) && CU.firstPartitioned((GridCacheSharedContext)this.ctx.cache().context(), cacheIds).config().getQueryParallelism() > 1) {
                fldsQry.setDistributedJoins(true);
                local = false;
            }
            UpdateResult updRes = this.h2.executeUpdateOnDataNode(req.schemaName(), fldsQry, filter, cancel, local);
            GridCacheContext mainCctx = !F.isEmpty(cacheIds) ? this.ctx.cache().context().cacheContext(cacheIds.get(0).intValue()) : null;
            boolean bl = evt = local && mainCctx != null && mainCctx.events().isRecordable(96);
            if (evt) {
                this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL.name(), mainCctx.name(), null, req.query(), null, null, req.parameters(), node.id(), null));
            }
            this.sendUpdateResponse(node, reqId, updRes, null);
        }
        catch (Exception e) {
            MTC.span().addTag("error", e::getMessage);
            U.error((IgniteLogger)this.log, (Object)("Error processing dml request. [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", req=" + req + ']'), (Throwable)e);
            this.sendUpdateResponse(node, reqId, null, e.getMessage());
        }
        finally {
            if (reserved != null) {
                reserved.release();
            }
            nodeResults.removeUpdate(reqId);
            if (trace != null) {
                trace.close();
            }
        }
    }

    private void sendQueryCancel(ClusterNode node, long qryReqId) {
        this.sendError(node, qryReqId, new QueryCancelledException());
    }

    private void sendError(ClusterNode node, long qryReqId, Throwable err) {
        try {
            MTC.span().addTag("error", err::getMessage);
            GridQueryFailResponse msg = new GridQueryFailResponse(qryReqId, err);
            if (node.isLocal()) {
                if (err instanceof QueryCancelledException) {
                    String errMsg = "Failed to run cancelled map query on local node: [localNodeId=" + node.id() + ", reqId=" + qryReqId + ']';
                    if (this.log.isDebugEnabled()) {
                        U.warn((IgniteLogger)this.log, (Object)errMsg, (Throwable)err);
                    } else if (this.log.isInfoEnabled()) {
                        this.log.info(errMsg);
                    }
                } else {
                    U.error((IgniteLogger)this.log, (Object)"Failed to run map query on local node.", (Throwable)err);
                }
                this.h2.reduceQueryExecutor().onFail(node, msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (Exception e) {
            e.addSuppressed(err);
            U.error((IgniteLogger)this.log, (Object)"Failed to send error message.", (Throwable)e);
        }
    }

    private void sendUpdateResponse(ClusterNode node, long reqId, UpdateResult updResult, String error) {
        try {
            GridH2DmlResponse rsp = new GridH2DmlResponse(reqId, updResult == null ? 0L : updResult.counter(), updResult == null ? null : updResult.errorKeys(), error);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending: [localNodeId=" + this.ctx.localNodeId() + ", node=" + node.id() + ", msg=" + rsp + "]");
            }
            if (node.isLocal()) {
                this.h2.reduceQueryExecutor().onDmlResponse(node, rsp);
            } else {
                rsp.marshall(this.ctx.config().getMarshaller());
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)rsp, (byte)10);
            }
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send message.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNextPageRequest(ClusterNode node, GridQueryNextPageRequest req) {
        block38: {
            try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_NEXT_PAGE_REQ, MTC.span()));){
                long reqId = req.queryRequestId();
                MapNodeResults nodeRess = (MapNodeResults)this.qryRess.get(node.id());
                if (nodeRess == null) {
                    this.sendError(node, reqId, (Throwable)new CacheException("No node result found for request: " + req));
                    return;
                }
                if (nodeRess.cancelled(reqId)) {
                    this.sendQueryCancel(node, reqId);
                    return;
                }
                MapQueryResults qryResults = nodeRess.get(reqId, req.segmentId());
                if (qryResults == null) {
                    this.sendError(node, reqId, (Throwable)new CacheException("No query result found for request: " + req));
                    break block38;
                }
                if (qryResults.cancelled()) {
                    this.sendQueryCancel(node, reqId);
                    break block38;
                }
                try {
                    MapQueryResult res = qryResults.result(req.query());
                    assert (res != null);
                    try {
                        res.lock();
                        res.lockTables();
                        res.checkTablesVersions();
                        Boolean dataPageScanEnabled = GridH2QueryRequest.isDataPageScanEnabled(req.getFlags());
                        GridQueryNextPageResponse msg = this.prepareNextPage(nodeRess, node, qryResults, req.query(), req.segmentId(), req.pageSize(), dataPageScanEnabled);
                        if (msg != null) {
                            this.sendNextPage(node, msg);
                        }
                    }
                    finally {
                        try {
                            res.unlockTables();
                        }
                        finally {
                            res.unlock();
                        }
                    }
                }
                catch (Exception e) {
                    QueryRetryException retryEx = (QueryRetryException)X.cause((Throwable)e, QueryRetryException.class);
                    if (retryEx != null) {
                        this.sendError(node, reqId, (Throwable)retryEx);
                    } else {
                        SQLException sqlEx = (SQLException)X.cause((Throwable)e, SQLException.class);
                        if (sqlEx != null && sqlEx.getErrorCode() == 57014) {
                            this.sendQueryCancel(node, reqId);
                        } else {
                            this.sendError(node, reqId, e);
                        }
                    }
                    qryResults.cancel();
                }
            }
        }
    }

    private GridQueryNextPageResponse prepareNextPage(MapNodeResults nodeRess, ClusterNode node, MapQueryResults qr, int qry, int segmentId, int pageSize, Boolean dataPageScanEnabled) throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_PAGE_PREPARE, MTC.span()));){
            MapQueryResult res = qr.result(qry);
            assert (res != null);
            if (res.closed()) {
                GridQueryNextPageResponse gridQueryNextPageResponse = null;
                return gridQueryNextPageResponse;
            }
            int page = res.page();
            ArrayList<Value[]> rows = new ArrayList<Value[]>(Math.min(64, pageSize));
            boolean last = res.fetchNextPage(rows, pageSize, dataPageScanEnabled);
            if (last) {
                qr.closeResult(qry);
                if (qr.isAllClosed()) {
                    nodeRess.remove(qr.queryRequestId(), segmentId, qr);
                    if (qr.isLazy()) {
                        qr.releaseQueryContext();
                    }
                }
            }
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(qr.queryRequestId(), segmentId, qry, page, page == 0 ? res.rowCount() : -1, res.columnCount(), loc ? null : GridH2ValueMessageFactory.toMessages(rows, new ArrayList<Message>(res.columnCount()), res.columnCount()), loc ? rows : null, last);
            MTC.span().addTag("sql.page.rows", () -> String.valueOf(rows.size()));
            GridQueryNextPageResponse gridQueryNextPageResponse = msg;
            return gridQueryNextPageResponse;
        }
    }

    private void sendNextPage(@NotNull ClusterNode node, @NotNull GridQueryNextPageResponse msg) {
        assert (msg != null);
        try {
            if (node.isLocal()) {
                this.h2.reduceQueryExecutor().onNextPage(node, msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send message.", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    private void sendRetry(ClusterNode node, long reqId, int segmentId, String retryCause) {
        try {
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(reqId, segmentId, 0, 0, 0, 1, loc ? null : Collections.emptyList(), loc ? Collections.emptyList() : null, false);
            msg.retry(this.h2.readyTopologyVersion());
            msg.retryCause(retryCause);
            if (loc) {
                this.h2.reduceQueryExecutor().onNextPage(node, msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (Exception e) {
            U.warn((IgniteLogger)this.log, (Object)("Failed to send retry message: " + e.getMessage()));
        }
    }
}

