/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.AbstractDateIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.pagemem.PageUtils;

public class DateInlineIndexKeyType
extends NullableInlineIndexKeyType<AbstractDateIndexKey> {
    public DateInlineIndexKeyType() {
        super(10, (short)8);
    }

    @Override
    public int compare0(long pageAddr, int off, AbstractDateIndexKey key) {
        long val1 = PageUtils.getLong(pageAddr, off + 1);
        long val2 = key.dateValue();
        return Integer.signum(Long.compare(val1, val2));
    }

    @Override
    protected int put0(long pageAddr, int off, AbstractDateIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        PageUtils.putLong(pageAddr, off + 1, key.dateValue());
        return this.keySize + 1;
    }

    @Override
    protected AbstractDateIndexKey get0(long pageAddr, int off) {
        long dateVal = PageUtils.getLong(pageAddr, off + 1);
        if (dateVal > 511999999903L) {
            dateVal = 511999999903L;
        } else if (dateVal < -511999999455L) {
            dateVal = -511999999455L;
        }
        return (AbstractDateIndexKey)IndexKeyFactory.wrapDateValue(this.type(), dateVal, 0L);
    }

    @Override
    protected int inlineSize0(AbstractDateIndexKey key) {
        return this.keySize + 1;
    }
}

