/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nodestart;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterStartNodeResult;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterStartNodeResultImpl;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.nodestart.IgniteRemoteStartSpecification;
import org.apache.ignite.internal.util.nodestart.StartNodeCallable;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;

public class StartNodeCallableImpl
implements StartNodeCallable {
    private static final String DFLT_IGNITE_HOME_WIN = "%IGNITE_HOME%";
    private static final String DFLT_IGNITE_HOME_LINUX = "$IGNITE_HOME";
    private static final String WINDOWS_ENCODING = "IBM866";
    private static final String DFLT_SCRIPT_WIN = "bin\\ignite.bat -v -np";
    private static final String DFLT_SCRIPT_LINUX = "bin/ignite.sh -v";
    private static final SimpleDateFormat FILE_NAME_DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy--HH-mm-ss");
    private static final String SUCCESSFUL_START_MSG = "Successfully bound to TCP port";
    private static final long EXECUTE_WAIT_TIME = 1000L;
    private static final long NODE_START_CHECK_PERIOD = 2000L;
    private static final long NODE_START_CHECK_LIMIT = 15L;
    private final IgniteRemoteStartSpecification spec;
    private final int timeout;
    private GridTimeoutProcessor proc;
    @LoggerResource
    private transient IgniteLogger log;
    @IgniteInstanceResource
    private transient Ignite ignite;

    public StartNodeCallableImpl() {
        this.spec = null;
        this.timeout = 0;
        assert (false);
    }

    public StartNodeCallableImpl(IgniteRemoteStartSpecification spec, int timeout) {
        assert (spec != null);
        this.spec = spec;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStartNodeResult call() {
        JSch ssh = new JSch();
        Session ses = null;
        try {
            String findSuccess;
            String scriptOutputPath;
            boolean win;
            block23: {
                String scriptOutputDir;
                String rmtLogArgs;
                String scriptArgs;
                String scriptPath;
                String scriptOutputFileName;
                String cfg;
                String igniteHome;
                block22: {
                    String deleteTask;
                    String script;
                    this.proc = ((IgniteEx)this.ignite).context().timeout();
                    if (this.spec.key() != null) {
                        ssh.addIdentity(this.spec.key().getAbsolutePath());
                    }
                    ses = ssh.getSession(this.spec.username(), this.spec.host(), this.spec.port());
                    if (this.spec.password() != null) {
                        ses.setPassword(this.spec.password());
                    }
                    ses.setConfig("StrictHostKeyChecking", "no");
                    ses.connect(this.timeout);
                    win = this.isWindows(ses);
                    this.info("Windows mode: " + win, this.spec.logger(), this.log);
                    char separator = win ? (char)'\\' : '/';
                    this.spec.fixPaths(separator);
                    igniteHome = this.spec.igniteHome();
                    if (igniteHome == null) {
                        String string = igniteHome = win ? DFLT_IGNITE_HOME_WIN : DFLT_IGNITE_HOME_LINUX;
                    }
                    if ((script = this.spec.script()) == null) {
                        String string = script = win ? DFLT_SCRIPT_WIN : DFLT_SCRIPT_LINUX;
                    }
                    if ((cfg = this.spec.configuration()) == null) {
                        cfg = "";
                    }
                    String id = FILE_NAME_DATE_FORMAT.format(new Date()) + '-' + UUID.randomUUID().toString().substring(0, 8);
                    scriptOutputFileName = id + ".log";
                    int spaceIdx = script.indexOf(32);
                    scriptPath = spaceIdx > -1 ? script.substring(0, spaceIdx) : script;
                    scriptArgs = spaceIdx > -1 ? script.substring(spaceIdx + 1) : "";
                    rmtLogArgs = this.buildRemoteLogArguments(this.spec.username(), this.spec.host());
                    String dfltTmpDir = igniteHome + separator + "work" + separator + "log";
                    if (win) {
                        String tmpDir = this.env(ses, "%TMPDIR%", dfltTmpDir, WINDOWS_ENCODING);
                        if ("%TMPDIR%".equals(tmpDir)) {
                            tmpDir = dfltTmpDir;
                        }
                        scriptOutputDir = tmpDir + "\\ignite-startNodes";
                    } else {
                        String logDir = this.env(ses, "$TMPDIR", dfltTmpDir);
                        scriptOutputDir = logDir + "/ignite-startNodes";
                    }
                    this.shell(ses, "mkdir " + scriptOutputDir);
                    scriptOutputPath = scriptOutputDir + separator + scriptOutputFileName;
                    if (!win) break block22;
                    String scriptFileName = scriptOutputDir + '\\' + id + ".bat";
                    String createScript = new SB().a("echo \"").a(igniteHome).a('\\').a(scriptPath).a("\" ").a(scriptArgs).a(!cfg.isEmpty() ? " \"" : "").a(cfg).a(!cfg.isEmpty() ? "\"" : "").a(rmtLogArgs).a(" ^> ").a(scriptOutputPath).a(" ^2^>^&^1").a(" > ").a(scriptFileName).toString();
                    this.info("Create script with command: " + createScript, this.spec.logger(), this.log);
                    this.shell(ses, createScript);
                    try {
                        String createTask = new SB().a("schtasks /create /f /sc onstart").a(" /ru ").a(this.spec.username()).a(" /rp ").a(this.spec.password()).a(" /tn ").a(id).a(" /np /tr \"").a(scriptFileName).a('\"').toString();
                        this.info("Create task with command: " + createTask, this.spec.logger(), this.log);
                        this.shell(ses, createTask);
                        String runTask = "schtasks /run /i /tn " + id;
                        this.info("Run task with command: " + runTask, this.spec.logger(), this.log);
                        this.shell(ses, runTask);
                        deleteTask = "schtasks /delete /f /tn " + id;
                    }
                    catch (Throwable throwable) {
                        String deleteTask2 = "schtasks /delete /f /tn " + id;
                        this.info("Delete task with command: " + deleteTask2, this.spec.logger(), this.log);
                        this.shell(ses, deleteTask2);
                        throw throwable;
                    }
                    this.info("Delete task with command: " + deleteTask, this.spec.logger(), this.log);
                    this.shell(ses, deleteTask);
                    findSuccess = "find \"Successfully bound to TCP port\" " + scriptOutputPath;
                    break block23;
                }
                if (igniteHome.startsWith("~")) {
                    String homeDir = this.env(ses, "$HOME", "~");
                    igniteHome = igniteHome.replaceFirst("~", homeDir);
                }
                String prepareStartCmd = new SB().a("nohup echo \"Preparing to start remote node...\" > ").a(scriptOutputDir).a('/').a(scriptOutputFileName).a(" 2>& 1 &").toString();
                this.shell(ses, prepareStartCmd);
                String startNodeCmd = new SB().a("nohup ").a("\"").a(igniteHome).a('/').a(scriptPath).a("\"").a(" ").a(scriptArgs).a(!cfg.isEmpty() ? " \"" : "").a(cfg).a(!cfg.isEmpty() ? "\"" : "").a(rmtLogArgs).a(" > ").a(scriptOutputDir).a('/').a(scriptOutputFileName).a(" 2>& 1 &").toString();
                this.info("Starting remote node with SSH command: " + startNodeCmd, this.spec.logger(), this.log);
                this.shell(ses, startNodeCmd, "\\[(\\d)\\] (\\d)+");
                findSuccess = "grep \"Successfully bound to TCP port\" " + scriptOutputPath;
            }
            int i = 0;
            while ((long)i < 15L) {
                Thread.sleep(2000L);
                String res = this.exec(ses, findSuccess, win ? WINDOWS_ENCODING : null);
                this.info("Find result: " + res, this.spec.logger(), this.log);
                if (res != null && res.contains(SUCCESSFUL_START_MSG)) {
                    ClusterStartNodeResultImpl clusterStartNodeResultImpl = new ClusterStartNodeResultImpl(this.spec.host(), true, null);
                    return clusterStartNodeResultImpl;
                }
                ++i;
            }
            ClusterStartNodeResultImpl clusterStartNodeResultImpl = new ClusterStartNodeResultImpl(this.spec.host(), false, "Remote node could not start. See log for details: " + scriptOutputPath);
            return clusterStartNodeResultImpl;
        }
        catch (IgniteInterruptedCheckedException e) {
            ClusterStartNodeResultImpl clusterStartNodeResultImpl = new ClusterStartNodeResultImpl(this.spec.host(), false, e.getMessage());
            return clusterStartNodeResultImpl;
        }
        catch (Exception e) {
            ClusterStartNodeResultImpl clusterStartNodeResultImpl = new ClusterStartNodeResultImpl(this.spec.host(), false, X.getFullStackTrace((Throwable)e));
            return clusterStartNodeResultImpl;
        }
        finally {
            if (ses != null && ses.isConnected()) {
                ses.disconnect();
            }
        }
    }

    private void shell(Session ses, String cmd) throws JSchException, IOException, IgniteInterruptedCheckedException {
        this.shell(ses, cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void shell(Session ses, String cmd, String regexp) throws JSchException, IOException, IgniteInterruptedCheckedException {
        ChannelShell ch = null;
        GridTimeoutObject to = null;
        try {
            ch = (ChannelShell)ses.openChannel("shell");
            ch.connect();
            try (PrintStream out = new PrintStream(ch.getOutputStream(), true);){
                out.println(cmd);
            }
            if (regexp != null) {
                Pattern ptrn = Pattern.compile(regexp);
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(ch.getInputStream()));){
                        String line;
                        boolean first = true;
                        while ((line = reader.readLine()) != null) {
                            if (ptrn.matcher(line).find()) {
                                U.sleep((long)50L);
                                break;
                            }
                            if (!first) continue;
                            to = this.initTimer(cmd);
                            first = false;
                        }
                    }
                    if (to == null) return;
                }
                catch (InterruptedIOException r) {
                    if (to == null) return;
                    boolean r2 = this.proc.removeTimeoutObject(to);
                    assert (r2 || to.endTime() <= U.currentTimeMillis()) : "Timeout object was not removed: " + to;
                    return;
                    catch (Throwable throwable) {
                        if (to == null) throw throwable;
                        boolean r3 = this.proc.removeTimeoutObject(to);
                        if ($assertionsDisabled || r3 || to.endTime() <= U.currentTimeMillis()) throw throwable;
                        throw new AssertionError((Object)("Timeout object was not removed: " + to));
                    }
                }
                boolean r = this.proc.removeTimeoutObject(to);
                assert (r || to.endTime() <= U.currentTimeMillis()) : "Timeout object was not removed: " + to;
                return;
            }
            U.sleep((long)1000L);
            return;
        }
        finally {
            if (ch != null && ch.isConnected()) {
                ch.disconnect();
            }
        }
    }

    private boolean isWindows(Session ses) throws JSchException {
        try {
            return this.exec(ses, "cmd.exe") != null;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private String env(Session ses, String name, String dflt) throws JSchException {
        return this.env(ses, name, dflt, null);
    }

    private String env(Session ses, String name, String dflt, String encoding) throws JSchException {
        try {
            String res = this.exec(ses, "echo " + name, encoding);
            if (res == null) {
                return dflt;
            }
            return (res = res.trim()).isEmpty() ? dflt : res;
        }
        catch (IOException ignored) {
            return dflt;
        }
    }

    private String exec(Session ses, String cmd) throws JSchException, IOException {
        return this.exec(ses, cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String exec(Session ses, String cmd, String encoding) throws JSchException, IOException {
        ChannelExec ch = null;
        try {
            SB out;
            block28: {
                ch = (ChannelExec)ses.openChannel("exec");
                ch.setCommand(cmd);
                ch.connect();
                if (encoding == null) {
                    encoding = Charset.defaultCharset().name();
                }
                GridTimeoutObject to = null;
                out = null;
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(ch.getInputStream(), encoding));){
                        String line;
                        boolean first = true;
                        while ((line = reader.readLine()) != null) {
                            if (first) {
                                out = new SB();
                            } else {
                                out.a('\n');
                            }
                            out.a(line);
                            if (!first) continue;
                            to = this.initTimer(cmd);
                            first = false;
                        }
                    }
                    if (to == null) break block28;
                }
                catch (InterruptedIOException r) {
                    if (to != null) {
                        boolean r2 = this.proc.removeTimeoutObject(to);
                        assert (r2 || to.endTime() <= U.currentTimeMillis()) : "Timeout object was not removed: " + to;
                    }
                    break block28;
                    catch (Throwable throwable) {
                        if (to == null) throw throwable;
                        boolean r3 = this.proc.removeTimeoutObject(to);
                        if ($assertionsDisabled) throw throwable;
                        if (r3) throw throwable;
                        if (to.endTime() <= U.currentTimeMillis()) throw throwable;
                        throw new AssertionError((Object)("Timeout object was not removed: " + to));
                    }
                }
                boolean r = this.proc.removeTimeoutObject(to);
                assert (r || to.endTime() <= U.currentTimeMillis()) : "Timeout object was not removed: " + to;
            }
            String string = out == null ? null : out.toString();
            return string;
        }
        finally {
            if (ch != null && ch.isConnected()) {
                ch.disconnect();
            }
        }
    }

    private GridTimeoutObject initTimer(final String cmd) {
        GridTimeoutObjectAdapter to = new GridTimeoutObjectAdapter(1000L){
            private final Thread thread;
            {
                super(x0);
                this.thread = Thread.currentThread();
            }

            public void onTimeout() {
                this.thread.interrupt();
            }

            public String toString() {
                return S.toString((String)"GridTimeoutObject", (String)"cmd", (Object)cmd, (String)"thread", (Object)this.thread);
            }
        };
        boolean wasAdded = this.proc.addTimeoutObject((GridTimeoutObject)to);
        assert (wasAdded) : "Timeout object was not added: " + to;
        return to;
    }

    private String buildRemoteLogArguments(String username, String host) {
        assert (username != null);
        assert (host != null);
        SB sb = new SB();
        sb.a(" -J-D").a("IGNITE_SSH_HOST").a("=\"").a(host).a("\"").a(" -J-D").a("IGNITE_SSH_USER_NAME").a("=\"").a(username).a("\"");
        return sb.toString();
    }

    public StartNodeCallable setLogger(IgniteLogger log) {
        this.log = log;
        return this;
    }

    private void info(String msg, IgniteLogger ... loggers) {
        for (IgniteLogger logger : loggers) {
            if (logger == null || !logger.isInfoEnabled()) continue;
            logger.info(msg);
        }
    }
}

