/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.zk;

import com.google.common.collect.Sets;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.UriSpec;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;
import org.codehaus.jackson.map.annotate.JsonRootName;

public class TcpDiscoveryZookeeperIpFinder
extends TcpDiscoveryIpFinderAdapter {
    @SystemProperty(value="Zookeeper connection string", type=String.class)
    public static final String PROP_ZK_CONNECTION_STRING = "IGNITE_ZK_CONNECTION_STRING";
    private static final String BASE_PATH = "/services";
    private static final String SERVICE_NAME = "ignite";
    private static final UriSpec URI_SPEC = new UriSpec("{address}:{port}");
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final AtomicBoolean closeGuard = new AtomicBoolean();
    @LoggerResource
    private IgniteLogger log;
    private CuratorFramework curator;
    private String zkConnectionString;
    private RetryPolicy retryPolicy = new ExponentialBackoffRetry(1000, 10);
    private String basePath = "/services";
    private String serviceName = "ignite";
    private boolean allowDuplicateRegistrations;
    private ServiceDiscovery<IgniteInstanceDetails> discovery;
    private Map<InetSocketAddress, ServiceInstance<IgniteInstanceDetails>> ourInstances = new ConcurrentHashMap<InetSocketAddress, ServiceInstance<IgniteInstanceDetails>>();

    public TcpDiscoveryZookeeperIpFinder() {
        this.setShared(true);
    }

    private void init() {
        if (!this.initGuard.compareAndSet(false, true)) {
            return;
        }
        String sysPropZkConnString = IgniteSystemProperties.getString((String)PROP_ZK_CONNECTION_STRING);
        if (sysPropZkConnString != null && !sysPropZkConnString.trim().isEmpty()) {
            this.zkConnectionString = sysPropZkConnString;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Initializing ZooKeeper IP Finder.");
        }
        if (this.curator == null) {
            A.notNullOrEmpty((String)this.zkConnectionString, (String)String.format("ZooKeeper URL (or system property %s) cannot be null or empty if a CuratorFramework object is not provided explicitly", PROP_ZK_CONNECTION_STRING));
            this.curator = CuratorFrameworkFactory.newClient((String)this.zkConnectionString, (RetryPolicy)this.retryPolicy);
        }
        if (this.curator.getState() == CuratorFrameworkState.LATENT) {
            this.curator.start();
        }
        A.ensure((this.curator.getState() == CuratorFrameworkState.STARTED ? 1 : 0) != 0, (String)"CuratorFramework can't be started.");
        this.discovery = ServiceDiscoveryBuilder.builder(IgniteInstanceDetails.class).client(this.curator).basePath(this.basePath).serializer((InstanceSerializer)new JsonInstanceSerializer(IgniteInstanceDetails.class)).build();
    }

    public void onSpiContextDestroyed() {
        if (!this.closeGuard.compareAndSet(false, true)) {
            U.warn((IgniteLogger)this.log, (Object)"ZooKeeper IP Finder can't be closed more than once.");
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Destroying ZooKeeper IP Finder.");
        }
        super.onSpiContextDestroyed();
        if (this.curator != null) {
            this.curator.close();
        }
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        Collection serviceInstances;
        this.init();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting registered addresses from ZooKeeper IP Finder.");
        }
        try {
            serviceInstances = this.discovery.queryForInstances(this.serviceName);
        }
        catch (Exception e) {
            this.log.warning("Error while getting registered addresses from ZooKeeper IP Finder.", (Throwable)e);
            return Collections.emptyList();
        }
        HashSet<InetSocketAddress> answer = new HashSet<InetSocketAddress>();
        for (ServiceInstance si : serviceInstances) {
            answer.add(new InetSocketAddress(si.getAddress(), (int)si.getPort()));
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("ZooKeeper IP Finder resolved addresses: " + answer);
        }
        return answer;
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        this.init();
        if (this.log.isInfoEnabled()) {
            this.log.info("Registering addresses with ZooKeeper IP Finder: " + addrs);
        }
        HashSet registrationsToIgnore = Sets.newHashSet();
        if (!this.allowDuplicateRegistrations) {
            try {
                for (ServiceInstance sd : this.discovery.queryForInstances(this.serviceName)) {
                    registrationsToIgnore.add(new InetSocketAddress(sd.getAddress(), (int)sd.getPort()));
                }
            }
            catch (Exception e) {
                this.log.warning("Error while finding currently registered services to avoid duplicate registrations", (Throwable)e);
                throw new IgniteSpiException((Throwable)e);
            }
        }
        for (InetSocketAddress addr : addrs) {
            if (registrationsToIgnore.contains(addr)) continue;
            try {
                ServiceInstance si = ServiceInstance.builder().name(this.serviceName).uriSpec(URI_SPEC).address(addr.getAddress().getHostAddress()).port(addr.getPort()).build();
                this.ourInstances.put(addr, (ServiceInstance<IgniteInstanceDetails>)si);
                this.discovery.registerService(si);
            }
            catch (Exception e) {
                this.log.warning(String.format("Error while registering an address from ZooKeeper IP Finder [message=%s,addresses=%s]", e.getMessage(), addr), (Throwable)e);
            }
        }
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        if (this.curator.getState() != CuratorFrameworkState.STARTED) {
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Unregistering addresses with ZooKeeper IP Finder: " + addrs);
        }
        for (InetSocketAddress addr : addrs) {
            ServiceInstance<IgniteInstanceDetails> si = this.ourInstances.get(addr);
            if (si == null) {
                this.log.warning("Asked to unregister address from ZooKeeper IP Finder, but no match was found in local instance map for: " + addrs);
                continue;
            }
            try {
                this.discovery.unregisterService(si);
            }
            catch (Exception e) {
                this.log.warning("Error while unregistering an address from ZooKeeper IP Finder: " + addr, (Throwable)e);
            }
        }
    }

    public TcpDiscoveryZookeeperIpFinder setCurator(CuratorFramework curator) {
        this.curator = curator;
        return this;
    }

    public String getZkConnectionString() {
        return this.zkConnectionString;
    }

    public TcpDiscoveryZookeeperIpFinder setZkConnectionString(String zkConnectionString) {
        this.zkConnectionString = zkConnectionString;
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public TcpDiscoveryZookeeperIpFinder setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public TcpDiscoveryZookeeperIpFinder setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public TcpDiscoveryZookeeperIpFinder setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public boolean isAllowDuplicateRegistrations() {
        return this.allowDuplicateRegistrations;
    }

    public TcpDiscoveryZookeeperIpFinder setAllowDuplicateRegistrations(boolean allowDuplicateRegistrations) {
        this.allowDuplicateRegistrations = allowDuplicateRegistrations;
        return this;
    }

    public TcpDiscoveryZookeeperIpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    @JsonRootName(value="ignite_instance_details")
    private class IgniteInstanceDetails {
        private IgniteInstanceDetails() {
        }
    }
}

