/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.algos.glm.GlmMojoModelBase;
import java.util.Arrays;

public class GlmOrdinalMojoModel
extends GlmMojoModelBase {
    private int P;
    private int noff;
    private int lastClass;
    private int[] icptIndices;

    GlmOrdinalMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        this.P = this._beta.length / this._nclasses;
        this.lastClass = this._nclasses - 1;
        this.icptIndices = new int[this.lastClass];
        for (int c = 0; c < this.lastClass; ++c) {
            this.icptIndices[c] = this.P - 1 + c * this.P;
        }
        if (this.P * this._nclasses != this._beta.length) {
            throw new IllegalStateException("Incorrect coding of Beta.");
        }
        this.noff = this._catOffsets[this._cats];
    }

    @Override
    double[] glmScore0(double[] data, double[] preds) {
        int cInd;
        Arrays.fill(preds, 0.0);
        preds[0] = this.lastClass;
        for (int c = 0; c < this.lastClass; ++c) {
            int i;
            if (this._cats > 0) {
                int ival;
                if (!this._useAllFactorLevels) {
                    for (i = 0; i < this._catOffsets.length - 1; ++i) {
                        if (data[i] == 0.0) continue;
                        ival = (int)data[i] - 1;
                        if ((double)ival != data[i] - 1.0) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((ival += this._catOffsets[i]) >= this._catOffsets[i + 1]) continue;
                        int n = c + 1;
                        preds[n] = preds[n] + this._beta[ival + c * this.P];
                    }
                } else {
                    for (i = 0; i < this._catOffsets.length - 1; ++i) {
                        ival = (int)data[i];
                        if ((double)ival != data[i]) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((ival += this._catOffsets[i]) >= this._catOffsets[i + 1]) continue;
                        int n = c + 1;
                        preds[n] = preds[n] + this._beta[ival + c * this.P];
                    }
                }
            }
            for (i = 0; i < this._nums; ++i) {
                int n = c + 1;
                preds[n] = preds[n] + this._beta[i + this.noff + c * this.P] * data[i + this._cats];
            }
            int n = c + 1;
            preds[n] = preds[n] + this._beta[this.icptIndices[c]];
        }
        double previousCDF = 0.0;
        for (cInd = 0; cInd < this.lastClass; ++cInd) {
            double eta = preds[cInd + 1];
            double currCDF = 1.0 / (1.0 + Math.exp(-eta));
            preds[cInd + 1] = currCDF - previousCDF;
            previousCDF = currCDF;
            if (!(eta > 0.0)) continue;
            preds[0] = cInd;
            break;
        }
        for (cInd = (int)preds[0] + 1; cInd < this.lastClass; ++cInd) {
            double currCDF = 1.0 / (1.0 + Math.exp(-preds[cInd + 1]));
            preds[cInd + 1] = currCDF - previousCDF;
            previousCDF = currCDF;
        }
        preds[this._nclasses] = 1.0 - previousCDF;
        return preds;
    }
}

