/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.java;

import java.io.Serializable;
import java.util.Objects;
import org.spark_project.guava.base.Preconditions;

public final class Optional<T>
implements Serializable {
    private static final Optional<?> EMPTY = new Optional();
    private final T value;

    private Optional() {
        this.value = null;
    }

    private Optional(T value2) {
        Preconditions.checkNotNull(value2);
        this.value = value2;
    }

    public static <T> Optional<T> empty() {
        Optional<?> t = EMPTY;
        return t;
    }

    public static <T> Optional<T> of(T value2) {
        return new Optional<T>(value2);
    }

    public static <T> Optional<T> ofNullable(T value2) {
        if (value2 == null) {
            return Optional.empty();
        }
        return Optional.of(value2);
    }

    public T get() {
        Preconditions.checkNotNull(this.value);
        return this.value;
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public static <T> Optional<T> absent() {
        return Optional.empty();
    }

    public static <T> Optional<T> fromNullable(T value2) {
        return Optional.ofNullable(value2);
    }

    public T or(T other) {
        return this.value != null ? this.value : other;
    }

    public T orNull() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public String toString() {
        return this.value == null ? "Optional.empty" : String.format("Optional[%s]", this.value);
    }
}

