/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.intervals.DisiPriorityQueue;
import org.apache.lucene.search.intervals.DisiWrapper;
import org.apache.lucene.search.intervals.DisjunctionDISIApproximation;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.lucene.util.PriorityQueue;

class DisjunctionIntervalsSource
extends IntervalsSource {
    final List<IntervalsSource> subSources;
    private static final IntervalIterator EMPTY = new IntervalIterator(){

        public int docID() {
            throw new UnsupportedOperationException();
        }

        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int start() {
            return -1;
        }

        @Override
        public int end() {
            return -1;
        }

        @Override
        public int nextInterval() {
            return Integer.MAX_VALUE;
        }

        @Override
        public float matchCost() {
            return 0.0f;
        }
    };

    public DisjunctionIntervalsSource(List<IntervalsSource> subSources) {
        this.subSources = subSources;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIterators = new ArrayList<IntervalIterator>();
        for (IntervalsSource subSource : this.subSources) {
            IntervalIterator it = subSource.intervals(field, ctx);
            if (it == null) continue;
            subIterators.add(it);
        }
        if (subIterators.size() == 0) {
            return null;
        }
        return new DisjunctionIntervalIterator(subIterators);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisjunctionIntervalsSource that = (DisjunctionIntervalsSource)o;
        return Objects.equals(this.subSources, that.subSources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources);
    }

    @Override
    public String toString() {
        return this.subSources.stream().map(Object::toString).collect(Collectors.joining(",", "or(", ")"));
    }

    @Override
    public void extractTerms(String field, Set<Term> terms) {
        for (IntervalsSource source : this.subSources) {
            source.extractTerms(field, terms);
        }
    }

    private static class DisjunctionIntervalIterator
    extends IntervalIterator {
        final DocIdSetIterator approximation;
        final PriorityQueue<IntervalIterator> intervalQueue;
        final DisiPriorityQueue disiQueue;
        final List<IntervalIterator> iterators;
        final float matchCost;
        IntervalIterator current = DisjunctionIntervalsSource.access$000();

        DisjunctionIntervalIterator(List<IntervalIterator> iterators) {
            this.disiQueue = new DisiPriorityQueue(iterators.size());
            for (IntervalIterator it : iterators) {
                this.disiQueue.add(new DisiWrapper(it));
            }
            this.approximation = new DisjunctionDISIApproximation(this.disiQueue);
            this.iterators = iterators;
            this.intervalQueue = new PriorityQueue<IntervalIterator>(iterators.size()){

                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.end() < b.end() || a.end() == b.end() && a.start() >= b.start();
                }
            };
            float costsum = 0.0f;
            for (IntervalIterator it : iterators) {
                costsum += (float)it.cost();
            }
            this.matchCost = costsum;
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }

        @Override
        public int start() {
            return this.current.start();
        }

        @Override
        public int end() {
            return this.current.end();
        }

        private void reset() throws IOException {
            this.intervalQueue.clear();
            DisiWrapper dw = this.disiQueue.topList();
            while (dw != null) {
                dw.intervals.nextInterval();
                this.intervalQueue.add((Object)dw.intervals);
                dw = dw.next;
            }
            this.current = EMPTY;
        }

        @Override
        public int nextInterval() throws IOException {
            if (this.current == EMPTY) {
                if (this.intervalQueue.size() > 0) {
                    this.current = (IntervalIterator)((Object)this.intervalQueue.top());
                }
                return this.current.start();
            }
            int start = this.current.start();
            int end = this.current.end();
            while (this.intervalQueue.size() > 0 && this.contains((IntervalIterator)((Object)this.intervalQueue.top()), start, end)) {
                IntervalIterator it = (IntervalIterator)((Object)this.intervalQueue.pop());
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                this.intervalQueue.add((Object)it);
            }
            if (this.intervalQueue.size() == 0) {
                this.current = EMPTY;
                return Integer.MAX_VALUE;
            }
            this.current = (IntervalIterator)((Object)this.intervalQueue.top());
            return this.current.start();
        }

        private boolean contains(IntervalIterator it, int start, int end) {
            return start >= it.start() && start <= it.end() && end >= it.start() && end <= it.end();
        }

        public int docID() {
            return this.approximation.docID();
        }

        public int nextDoc() throws IOException {
            int doc = this.approximation.nextDoc();
            this.reset();
            return doc;
        }

        public int advance(int target) throws IOException {
            int doc = this.approximation.advance(target);
            this.reset();
            return doc;
        }

        public long cost() {
            return this.approximation.cost();
        }
    }
}

