/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark.impl;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.spark.IgniteContext;
import org.apache.ignite.spark.IgniteDataFrameSettings$;
import org.apache.ignite.spark.impl.QueryUtils$;
import org.apache.ignite.spark.impl.package$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;

public final class QueryHelper$ {
    public static final QueryHelper$ MODULE$;

    static {
        new QueryHelper$();
    }

    public void dropTable(String tableName, Ignite ignite) {
        GridQueryProcessor qryProcessor = ((IgniteEx)ignite).context().query();
        String qry = QueryUtils$.MODULE$.compileDropTable(tableName);
        qryProcessor.querySqlFields(new SqlFieldsQuery(qry), true).getAll();
    }

    public void createTable(StructType schema2, String tblName, Seq<String> primaryKeyFields, Option<String> createTblOpts, Ignite ignite) {
        GridQueryProcessor qryProcessor = ((IgniteEx)ignite).context().query();
        String qry = QueryUtils$.MODULE$.compileCreateTable(schema2, tblName, primaryKeyFields, createTblOpts);
        qryProcessor.querySqlFields(new SqlFieldsQuery(qry), true).getAll();
    }

    public void ensureCreateTableOptions(StructType schema2, Map<String, String> params, IgniteContext ctx) {
        if (params.contains((Object)IgniteDataFrameSettings$.MODULE$.OPTION_TABLE()) || params.contains((Object)"path")) {
            if (params.contains((Object)IgniteDataFrameSettings$.MODULE$.OPTION_SCHEMA()) && !((String)params.apply((Object)IgniteDataFrameSettings$.MODULE$.OPTION_SCHEMA())).equalsIgnoreCase("PUBLIC")) {
                throw new IgniteException(new StringBuilder().append((Object)"Creating new tables in schema ").append(params.apply((Object)IgniteDataFrameSettings$.MODULE$.OPTION_SCHEMA())).append((Object)" is not valid, tables").append((Object)" must only be created in ").append((Object)"PUBLIC").toString());
            }
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])params.get((Object)IgniteDataFrameSettings$.MODULE$.OPTION_CREATE_TABLE_PRIMARY_KEY_FIELDS()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String[] apply(String x$1) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$1)).split(',');
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IgniteException("Can't create table! Primary key fields has to be specified.");
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$2) {
                    return x$2.trim();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(schema2){
                public static final long serialVersionUID = 0L;
                private final StructType schema$1;

                public final void apply(String pkField) {
                    String string = pkField;
                    String string2 = "";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new IgniteException("PK field can't be empty.");
                    }
                    if (this.schema$1.exists((Function1)new Serializable(this, pkField){
                        public static final long serialVersionUID = 0L;
                        private final String pkField$1;

                        public final boolean apply(StructField x$3) {
                            return x$3.name().equalsIgnoreCase(this.pkField$1);
                        }
                        {
                            this.pkField$1 = pkField$1;
                        }
                    })) {
                        return;
                    }
                    throw new IgniteException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' doesn't exists in DataFrame schema."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pkField})));
                }
                {
                    this.schema$1 = schema$1;
                }
            });
            return;
        }
        throw new IgniteException("'table' must be specified.");
    }

    public void saveTable(Dataset<Row> data, String tblName, Option<String> schemaName, IgniteContext ctx, Option<Object> streamerAllowOverwrite, Option<Object> streamerSkipStore, Option<Object> streamerFlushFrequency, Option<Object> streamerPerNodeBufferSize, Option<Object> streamerPerNodeParallelOperations) {
        String insertQry = QueryUtils$.MODULE$.compileInsert(tblName, data.schema());
        data.rdd().foreachPartition((Function1)new Serializable(tblName, schemaName, ctx, streamerAllowOverwrite, streamerSkipStore, streamerFlushFrequency, streamerPerNodeBufferSize, streamerPerNodeParallelOperations, insertQry){
            public static final long serialVersionUID = 0L;
            private final String tblName$1;
            private final Option schemaName$1;
            private final IgniteContext ctx$1;
            private final Option streamerAllowOverwrite$1;
            private final Option streamerSkipStore$1;
            private final Option streamerFlushFrequency$1;
            private final Option streamerPerNodeBufferSize$1;
            private final Option streamerPerNodeParallelOperations$1;
            private final String insertQry$1;

            public final void apply(Iterator<Row> iterator) {
                QueryHelper$.MODULE$.org$apache$ignite$spark$impl$QueryHelper$$savePartition(iterator, this.insertQry$1, this.tblName$1, (Option<String>)this.schemaName$1, this.ctx$1, (Option<Object>)this.streamerAllowOverwrite$1, (Option<Object>)this.streamerSkipStore$1, (Option<Object>)this.streamerFlushFrequency$1, (Option<Object>)this.streamerPerNodeBufferSize$1, (Option<Object>)this.streamerPerNodeParallelOperations$1);
            }
            {
                this.tblName$1 = tblName$1;
                this.schemaName$1 = schemaName$1;
                this.ctx$1 = ctx$1;
                this.streamerAllowOverwrite$1 = streamerAllowOverwrite$1;
                this.streamerSkipStore$1 = streamerSkipStore$1;
                this.streamerFlushFrequency$1 = streamerFlushFrequency$1;
                this.streamerPerNodeBufferSize$1 = streamerPerNodeBufferSize$1;
                this.streamerPerNodeParallelOperations$1 = streamerPerNodeParallelOperations$1;
                this.insertQry$1 = insertQry$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void org$apache$ignite$spark$impl$QueryHelper$$savePartition(Iterator<Row> iterator, String insertQry, String tblName, Option<String> schemaName, IgniteContext ctx, Option<Object> streamerAllowOverwrite, Option<Object> streamerSkipStore, Option<Object> streamerFlushFrequency, Option<Object> streamerPerNodeBufferSize, Option<Object> streamerPerNodeParallelOperations) {
        QueryTypeDescriptorImpl tblInfo = (QueryTypeDescriptorImpl)package$.MODULE$.sqlTableInfo(ctx.ignite(), tblName, schemaName).get();
        IgniteDataStreamer streamer = ctx.ignite().dataStreamer(tblInfo.cacheName());
        streamerAllowOverwrite.foreach((Function1)new Serializable(streamer){
            public static final long serialVersionUID = 0L;
            private final IgniteDataStreamer streamer$1;

            public final void apply(boolean v) {
                this.streamer$1.allowOverwrite(v);
            }
            {
                this.streamer$1 = streamer$1;
            }
        });
        streamerSkipStore.foreach((Function1)new Serializable(streamer){
            public static final long serialVersionUID = 0L;
            private final IgniteDataStreamer streamer$1;

            public final void apply(boolean v) {
                this.streamer$1.skipStore(v);
            }
            {
                this.streamer$1 = streamer$1;
            }
        });
        streamerFlushFrequency.foreach((Function1)new Serializable(streamer){
            public static final long serialVersionUID = 0L;
            private final IgniteDataStreamer streamer$1;

            public final void apply(long v) {
                this.apply$mcVJ$sp(v);
            }

            public void apply$mcVJ$sp(long v) {
                this.streamer$1.autoFlushFrequency(v);
            }
            {
                this.streamer$1 = streamer$1;
            }
        });
        streamerPerNodeBufferSize.foreach((Function1)new Serializable(streamer){
            public static final long serialVersionUID = 0L;
            private final IgniteDataStreamer streamer$1;

            public final void apply(int v) {
                this.apply$mcVI$sp(v);
            }

            public void apply$mcVI$sp(int v) {
                this.streamer$1.perNodeBufferSize(v);
            }
            {
                this.streamer$1 = streamer$1;
            }
        });
        streamerPerNodeParallelOperations.foreach((Function1)new Serializable(streamer){
            public static final long serialVersionUID = 0L;
            private final IgniteDataStreamer streamer$1;

            public final void apply(int v) {
                this.apply$mcVI$sp(v);
            }

            public void apply$mcVI$sp(int v) {
                this.streamer$1.perNodeParallelOperations(v);
            }
            {
                this.streamer$1 = streamer$1;
            }
        });
        try {
            GridQueryProcessor qryProcessor = ((IgniteEx)ctx.ignite()).context().query();
            iterator.foreach((Function1)new Serializable(insertQry, tblInfo, streamer, qryProcessor){
                public static final long serialVersionUID = 0L;
                private final String insertQry$2;
                private final QueryTypeDescriptorImpl tblInfo$1;
                private final IgniteDataStreamer streamer$1;
                private final GridQueryProcessor qryProcessor$1;

                public final long apply(Row row) {
                    StructType schema2 = row.schema();
                    Seq args = (Seq)schema2.map((Function1)new Serializable(this, row){
                        public static final long serialVersionUID = 0L;
                        private final Row row$1;

                        public final Object apply(StructField f) {
                            return this.row$1.get(this.row$1.fieldIndex(f.name()));
                        }
                        {
                            this.row$1 = row$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return this.qryProcessor$1.streamUpdateQuery(this.tblInfo$1.cacheName(), this.tblInfo$1.schemaName(), this.streamer$1, this.insertQry$2, (Object[])args.toArray(ClassTag$.MODULE$.Object()), "spark");
                }
                {
                    this.insertQry$2 = insertQry$2;
                    this.tblInfo$1 = tblInfo$1;
                    this.streamer$1 = streamer$1;
                    this.qryProcessor$1 = qryProcessor$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var12_12;
            var12_12.close();
            throw throwable;
        }
        streamer.close();
    }

    private QueryHelper$() {
        MODULE$ = this;
    }
}

