/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.diagnostic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.diagnostic.Operation;
import org.jetbrains.annotations.Nullable;

public class VisorPageLocksTrackerArgs
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Operation op;
    private String filePath;
    @Nullable
    private Set<String> nodeIds;

    public VisorPageLocksTrackerArgs() {
    }

    public VisorPageLocksTrackerArgs(Operation op, String filePath, Set<String> nodeIds) {
        this.op = op;
        this.filePath = filePath;
        this.nodeIds = nodeIds;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.op);
        U.writeString(out, this.filePath);
        U.writeCollection(out, this.nodeIds);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.op = (Operation)((Object)in.readObject());
        this.filePath = U.readString(in);
        this.nodeIds = U.readSet(in);
    }

    public Operation operation() {
        return this.op;
    }

    public String filePath() {
        return this.filePath;
    }

    public Set<String> nodeIds() {
        return Collections.unmodifiableSet(this.nodeIds);
    }
}

