/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.aware;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.query.aware.IndexRebuildCacheInfo;
import org.apache.ignite.internal.processors.query.aware.IndexRebuildState;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.apache.ignite.internal.util.typedef.internal.CU;

public class IndexRebuildStateStorage
implements MetastorageLifecycleListener,
CheckpointListener {
    public static final String KEY_PREFIX = "rebuild-sql-indexes-";
    private final GridKernalContext ctx;
    private final Object metaStorageMux = new Object();
    private final GridBusyLock stopNodeLock = new GridBusyLock();
    private final ConcurrentMap<String, IndexRebuildState> states = new ConcurrentHashMap<String, IndexRebuildState>();

    public IndexRebuildStateStorage(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    public void start() {
        this.ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
    }

    public void onCacheKernalStart() {
        HashSet toComplete = new HashSet(this.states.keySet());
        toComplete.removeAll(this.ctx.cache().cacheDescriptors().keySet());
        for (String cacheName : toComplete) {
            this.onFinishRebuildIndexes(cacheName);
        }
    }

    public void stop() {
        this.stopNodeLock.block();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartRebuildIndexes(GridCacheContext cacheCtx) {
        if (!this.stopNodeLock.enterBusy()) {
            throw new IgniteException("Node is stopping.");
        }
        try {
            String cacheName = cacheCtx.name();
            boolean persistent = CU.isPersistentCache(cacheCtx.config(), this.ctx.config().getDataStorageConfiguration());
            this.states.compute(cacheName, (k, prev) -> {
                if (prev != null) {
                    prev.state(IndexRebuildState.State.INIT);
                    return prev;
                }
                return new IndexRebuildState(persistent);
            });
            if (persistent) {
                this.metaStorageOperation(metaStorage -> {
                    assert (metaStorage != null);
                    metaStorage.write(IndexRebuildStateStorage.metaStorageKey(cacheName), new IndexRebuildCacheInfo(cacheName));
                });
            }
        }
        finally {
            this.stopNodeLock.leaveBusy();
        }
    }

    public void onFinishRebuildIndexes(String cacheName) {
        this.states.compute(cacheName, (k, prev) -> {
            if (prev != null && prev.persistent()) {
                prev.state(IndexRebuildState.State.INIT, IndexRebuildState.State.COMPLETED);
                return prev;
            }
            return null;
        });
    }

    public boolean completed(String cacheName) {
        IndexRebuildState state = (IndexRebuildState)this.states.get(cacheName);
        return state == null || state.state() != IndexRebuildState.State.INIT;
    }

    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) {
        ((GridCacheDatabaseSharedManager)this.ctx.cache().context().database()).addCheckpointListener(this);
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) {
        if (!this.stopNodeLock.enterBusy()) {
            return;
        }
        try {
            this.metaStorageOperation(metaStorage -> {
                assert (metaStorage != null);
                metaStorage.iterate(KEY_PREFIX, (k, v) -> {
                    IndexRebuildCacheInfo cacheInfo = (IndexRebuildCacheInfo)v;
                    this.states.put(cacheInfo.cacheName(), new IndexRebuildState(true));
                }, true);
            });
        }
        finally {
            this.stopNodeLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMarkCheckpointBegin(CheckpointListener.Context ctx) {
        if (!this.stopNodeLock.enterBusy()) {
            return;
        }
        try {
            for (IndexRebuildState state : this.states.values()) {
                if (state.state(IndexRebuildState.State.COMPLETED, IndexRebuildState.State.DELETE)) assert (state.persistent());
            }
        }
        finally {
            this.stopNodeLock.leaveBusy();
        }
    }

    @Override
    public void onCheckpointBegin(CheckpointListener.Context ctx) {
    }

    @Override
    public void beforeCheckpointBegin(CheckpointListener.Context ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCheckpointEnd(CheckpointListener.Context ctx) {
        if (!this.stopNodeLock.enterBusy()) {
            return;
        }
        try {
            for (String cacheName : this.states.keySet()) {
                IndexRebuildState newVal = this.states.compute(cacheName, (k, prev) -> prev != null && prev.state() == IndexRebuildState.State.DELETE ? null : prev);
                if (newVal != null) continue;
                this.metaStorageOperation(metaStorage -> {
                    assert (metaStorage != null);
                    if (!this.states.containsKey(cacheName)) {
                        metaStorage.remove(IndexRebuildStateStorage.metaStorageKey(cacheName));
                    }
                });
            }
        }
        finally {
            this.stopNodeLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void metaStorageOperation(IgniteThrowableConsumer<MetaStorage> consumer) {
        Object object = this.metaStorageMux;
        synchronized (object) {
            IgniteCacheDatabaseSharedManager db = this.ctx.cache().context().database();
            db.checkpointReadLock();
            try {
                consumer.accept(db.metaStorage());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                db.checkpointReadUnlock();
            }
        }
    }

    private static String metaStorageKey(String cacheName) {
        return KEY_PREFIX + cacheName;
    }
}

