/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.function.BiConsumer;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.mem.IgniteOutOfMemoryException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.LoadedPagesMap;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.ReplaceCandidate;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;

public class FullPageIdTable
implements LoadedPagesMap {
    public static final float DFLT_LONG_LONG_HASH_MAP_LOAD_FACTOR = 2.5f;
    private static final float LOAD_FACTOR = IgniteSystemProperties.getFloat("IGNITE_LONG_LONG_HASH_MAP_LOAD_FACTOR", 2.5f);
    private static final int BYTES_PER_ENTRY = 24;
    private static final FullPageId EMPTY_FULL_PAGE_ID = new FullPageId(0L, 0);
    private static final long EMPTY_PAGE_ID = EMPTY_FULL_PAGE_ID.pageId();
    private static final int EMPTY_CACHE_GRP_ID = EMPTY_FULL_PAGE_ID.groupId();
    private static final long REMOVED_PAGE_ID = Long.MIN_VALUE;
    private static final int REMOVED_CACHE_GRP_ID = 0;
    private static final int EQUAL = 0;
    private static final int EMPTY = 1;
    private static final int REMOVED = -1;
    private static final int NOT_EQUAL = 2;
    private static final int OUTDATED = -3;
    private static final int TAG_OFFSET = 4;
    private static final int PAGE_ID_OFFSET = 8;
    private static final int VALUE_OFFSET = 16;
    protected int capacity;
    protected int maxSteps;
    protected long valPtr;

    public static long requiredMemory(long elementCnt) {
        assert (LOAD_FACTOR != 0.0f);
        return (long)((float)elementCnt * LOAD_FACTOR) * 24L + 8L;
    }

    public FullPageIdTable(long addr, long len, boolean clear) {
        this.valPtr = addr;
        this.maxSteps = this.capacity = (int)((len - 8L) / 24L);
        if (clear) {
            this.clear();
        }
    }

    @Override
    public final int size() {
        return GridUnsafe.getInt(this.valPtr);
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public long get(int grpId, long pageId, int reqVer, long absent, long outdated) {
        assert (this.assertKey(grpId, pageId));
        int idx = this.getKey(grpId, pageId, reqVer, false);
        if (idx == -1) {
            return absent;
        }
        if (idx == -2) {
            return outdated;
        }
        return this.valueAt(idx);
    }

    @Override
    public long refresh(int grpId, long pageId, int ver) {
        assert (this.assertKey(grpId, pageId));
        int idx = this.getKey(grpId, pageId, ver, true);
        if (idx < 0 || this.tagAt(idx) >= ver) {
            A.ensure(idx >= 0, "[idx=" + idx + ", tag=" + ver + ", cacheId=" + grpId + ", pageId=" + U.hexLong(pageId) + ']');
            A.ensure(this.tagAt(idx) < ver, "[idx=" + idx + ", tag=" + ver + ", cacheId=" + grpId + ", pageId=" + U.hexLong(pageId) + ", tagAtIdx=" + this.tagAt(idx) + ']');
        }
        this.setTagAt(idx, ver);
        return this.valueAt(idx);
    }

    @Override
    public void put(int grpId, long pageId, long val, int ver) {
        assert (this.assertKey(grpId, pageId));
        int idx = this.putKey(grpId, pageId, ver);
        this.setValueAt(idx, val);
    }

    @Override
    public boolean remove(int grpId, long pageId) {
        boolean valRmv;
        assert (this.assertKey(grpId, pageId));
        int idx = this.removeKey(grpId, pageId);
        boolean bl = valRmv = idx >= 0;
        if (valRmv) {
            this.setValueAt(idx, 0L);
        }
        return valRmv;
    }

    @Override
    public ReplaceCandidate getNearestAt(int idxStart) {
        for (int i = idxStart; i < this.capacity + idxStart; ++i) {
            int idx2 = this.normalizeIndex(i);
            if (!this.isValuePresentAt(idx2)) continue;
            long base = this.entryBase(idx2);
            int grpId = GridUnsafe.getInt(base);
            int tag = GridUnsafe.getInt(base + 4L);
            long pageId = GridUnsafe.getLong(base + 8L);
            long val = GridUnsafe.getLong(base + 16L);
            return new ReplaceCandidate(tag, val, new FullPageId(pageId, grpId));
        }
        return null;
    }

    @Override
    public GridLongList removeIf(int startIdxToClear, int endIdxToClear, LoadedPagesMap.KeyPredicate keyPred) {
        assert (endIdxToClear > startIdxToClear) : "Start and end indexes are not consistent: {" + startIdxToClear + ", " + endIdxToClear + "}";
        int sz = endIdxToClear - startIdxToClear;
        GridLongList list = new GridLongList(sz);
        for (int idx = startIdxToClear; idx < endIdxToClear; ++idx) {
            long pageId;
            long base = this.entryBase(idx);
            int grpId = GridUnsafe.getInt(base);
            if (this.isRemoved(grpId, pageId = GridUnsafe.getLong(base + 8L)) || this.isEmpty(grpId, pageId) || !keyPred.test(grpId, pageId)) continue;
            long res = this.valueAt(idx);
            this.setRemoved(idx);
            list.add(res);
        }
        return list;
    }

    private int putKey(int cacheId, long pageId, int tag) {
        int res;
        int step = 1;
        int idx = U.safeAbs(FullPageId.hashCode(cacheId, pageId)) % this.capacity;
        int foundIdx = -1;
        do {
            if ((res = this.testKeyAt(idx, cacheId, pageId, tag)) == -3) {
                foundIdx = idx;
                break;
            }
            if (res == 1) {
                if (foundIdx != -1) break;
                foundIdx = idx;
                break;
            }
            if (res == -1) {
                if (foundIdx == -1) {
                    foundIdx = idx;
                }
            } else {
                if (res == 0) {
                    return idx;
                }
                assert (res == 2);
            }
            if (++idx < this.capacity) continue;
            idx -= this.capacity;
        } while (++step <= this.maxSteps);
        if (foundIdx != -1) {
            this.setKeyAt(foundIdx, cacheId, pageId);
            this.setTagAt(foundIdx, tag);
            if (res != -3) {
                this.incrementSize();
            }
            return foundIdx;
        }
        throw new IgniteOutOfMemoryException("No room for a new key");
    }

    private int getKey(int cacheId, long pageId, int tag, boolean refresh) {
        int step = 1;
        int index = U.safeAbs(FullPageId.hashCode(cacheId, pageId)) % this.capacity;
        do {
            long res;
            if ((res = (long)this.testKeyAt(index, cacheId, pageId, tag)) == 0L) {
                return index;
            }
            if (res == 1L) {
                return -1;
            }
            if (res == -3L) {
                return !refresh ? -2 : index;
            }
            assert (res == -1L || res == 2L);
            if (++index < this.capacity) continue;
            index -= this.capacity;
        } while (++step <= this.maxSteps);
        return -1;
    }

    private boolean isRemoved(int grpId, long pageId) {
        return pageId == Long.MIN_VALUE && grpId == 0;
    }

    private boolean isRemoved(int idx) {
        long base = this.entryBase(idx);
        int grpId = GridUnsafe.getInt(base);
        long pageId = GridUnsafe.getLong(base + 8L);
        return this.isRemoved(grpId, pageId);
    }

    private void setRemoved(int idx) {
        this.setKeyAt(idx, 0, Long.MIN_VALUE);
        this.setValueAt(idx, 0L);
    }

    private boolean isEmpty(int grpId, long pageId) {
        return pageId == EMPTY_PAGE_ID && grpId == EMPTY_CACHE_GRP_ID;
    }

    private boolean isEmpty(int idx) {
        long base = this.entryBase(idx);
        int grpId = GridUnsafe.getInt(base);
        long pageId = GridUnsafe.getLong(base + 8L);
        return this.isEmpty(grpId, pageId);
    }

    private void setEmpty(int idx) {
        this.setKeyAt(idx, EMPTY_CACHE_GRP_ID, EMPTY_PAGE_ID);
        this.setValueAt(idx, 0L);
    }

    private int normalizeIndex(int i) {
        assert (i < 2 * this.capacity);
        return i < this.capacity ? i : i - this.capacity;
    }

    private int removeKey(int cacheId, long pageId) {
        int step = 1;
        int idx = U.safeAbs(FullPageId.hashCode(cacheId, pageId)) % this.capacity;
        int foundIdx = -1;
        do {
            long res;
            if ((res = (long)this.testKeyAt(idx, cacheId, pageId, -1)) == 0L || res == -3L) {
                foundIdx = idx;
                break;
            }
            if (res == 1L) {
                return -1;
            }
            assert (res == -1L || res == 2L);
            if (++idx < this.capacity) continue;
            idx -= this.capacity;
        } while (++step <= this.maxSteps);
        if (foundIdx != -1) {
            this.setRemoved(foundIdx);
            this.decrementSize();
        }
        return foundIdx;
    }

    private int testKeyAt(int index, int testCacheId, long testPageId, int testTag) {
        long base = this.entryBase(index);
        int grpId = GridUnsafe.getInt(base);
        int tag = GridUnsafe.getInt(base + 4L);
        long pageId = GridUnsafe.getLong(base + 8L);
        if (this.isRemoved(grpId, pageId)) {
            return -1;
        }
        if (pageId == testPageId && grpId == testCacheId && tag >= testTag) {
            return 0;
        }
        if (pageId == testPageId && grpId == testCacheId && tag < testTag) {
            return -3;
        }
        if (this.isEmpty(grpId, pageId)) {
            return 1;
        }
        return 2;
    }

    private boolean isValuePresentAt(int idx) {
        long pageId;
        long base = this.entryBase(idx);
        int grpId = GridUnsafe.getInt(base);
        return !this.isRemoved(grpId, pageId = GridUnsafe.getLong(base + 8L)) && !this.isEmpty(grpId, pageId);
    }

    private boolean assertKey(int grpId, long pageId) {
        assert (grpId != EMPTY_CACHE_GRP_ID && PageIdUtils.isEffectivePageId(pageId)) : "grpId=" + grpId + ", pageId=" + U.hexLong(pageId);
        return true;
    }

    private void setKeyAt(int idx, int grpId, long pageId) {
        long base = this.entryBase(idx);
        GridUnsafe.putInt(base, grpId);
        GridUnsafe.putLong(base + 8L, pageId);
    }

    public int distanceFromIdeal(int cacheId, long pageId, int tag) {
        int step = 1;
        int index = U.safeAbs(FullPageId.hashCode(cacheId, pageId)) % this.capacity;
        int scans = 0;
        boolean found = false;
        do {
            ++scans;
            long res = this.testKeyAt(index, cacheId, pageId, tag);
            if (res == 0L || res == -3L) {
                found = true;
                break;
            }
            if (res == 1L) break;
            assert (res == -1L || res == 2L);
            if (++index < this.capacity) continue;
            index -= this.capacity;
        } while (++step <= this.maxSteps);
        return found ? scans : -scans;
    }

    @Override
    public void forEach(BiConsumer<FullPageId, Long> act) {
        for (int i = 0; i < this.capacity; ++i) {
            if (!this.isValuePresentAt(i)) continue;
            long base = this.entryBase(i);
            int cacheId = GridUnsafe.getInt(base);
            long pageId = GridUnsafe.getLong(base + 8L);
            long val = GridUnsafe.getLong(base + 16L);
            act.accept(new FullPageId(pageId, cacheId), val);
        }
    }

    private long valueAt(int index) {
        return GridUnsafe.getLong(this.entryBase(index) + 16L);
    }

    private void setValueAt(int index, long value) {
        GridUnsafe.putLong(this.entryBase(index) + 16L, value);
    }

    private long entryBase(int idx) {
        return this.valPtr + 8L + (long)idx * 24L;
    }

    private int tagAt(int idx) {
        return GridUnsafe.getInt(this.entryBase(idx) + 4L);
    }

    private void setTagAt(int idx, int tag) {
        GridUnsafe.putInt(this.entryBase(idx) + 4L, tag);
    }

    public void clear() {
        GridUnsafe.setMemory(this.valPtr, (long)this.capacity * 24L + 8L, (byte)0);
    }

    private void incrementSize() {
        GridUnsafe.putInt(this.valPtr, GridUnsafe.getInt(this.valPtr) + 1);
    }

    private void decrementSize() {
        GridUnsafe.putInt(this.valPtr, GridUnsafe.getInt(this.valPtr) - 1);
    }
}

