/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import org.apache.ignite.internal.binary.streams.BinaryAbstractOutputStream;
import org.apache.ignite.internal.binary.streams.BinaryMemoryAllocator;
import org.apache.ignite.internal.binary.streams.BinaryMemoryAllocatorChunk;
import org.apache.ignite.internal.util.GridUnsafe;

public final class BinaryHeapOutputStream
extends BinaryAbstractOutputStream {
    private final BinaryMemoryAllocatorChunk chunk;
    private byte[] data;

    public BinaryHeapOutputStream(int cap) {
        this(cap, BinaryMemoryAllocator.THREAD_LOCAL.chunk());
    }

    public BinaryHeapOutputStream(int cap, BinaryMemoryAllocatorChunk chunk) {
        this.chunk = chunk;
        this.data = chunk.allocate(cap);
    }

    @Override
    public void close() {
        this.chunk.release(this.data, this.pos);
    }

    @Override
    public void ensureCapacity(int cnt) {
        if (cnt - this.data.length > 0) {
            int newCap = BinaryHeapOutputStream.capacity(this.data.length, cnt);
            this.data = this.chunk.reallocate(this.data, newCap);
        }
    }

    @Override
    public byte[] array() {
        return this.data;
    }

    @Override
    public byte[] arrayCopy() {
        byte[] res = new byte[this.pos];
        System.arraycopy(this.data, 0, res, 0, this.pos);
        return res;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    protected void writeByteAndShift(byte val) {
        this.data[this.pos++] = val;
    }

    @Override
    protected void copyAndShift(Object src, long off, int len) {
        GridUnsafe.copyMemory(src, off, this.data, GridUnsafe.BYTE_ARR_OFF + (long)this.pos, len);
        this.shift(len);
    }

    @Override
    protected void writeShortFast(short val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putShortLE(this.data, off, val);
        } else {
            GridUnsafe.putShort(this.data, off, val);
        }
    }

    @Override
    protected void writeCharFast(char val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putCharLE(this.data, off, val);
        } else {
            GridUnsafe.putChar(this.data, off, val);
        }
    }

    @Override
    protected void writeIntFast(int val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putIntLE(this.data, off, val);
        } else {
            GridUnsafe.putInt(this.data, off, val);
        }
    }

    @Override
    protected void writeLongFast(long val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putLongLE(this.data, off, val);
        } else {
            GridUnsafe.putLong(this.data, off, val);
        }
    }

    @Override
    public void unsafeWriteByte(byte val) {
        GridUnsafe.putByte(this.data, GridUnsafe.BYTE_ARR_OFF + (long)this.pos++, val);
    }

    @Override
    public void unsafeWriteShort(short val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putShortLE(this.data, off, val);
        } else {
            GridUnsafe.putShort(this.data, off, val);
        }
        this.shift(2);
    }

    @Override
    public void unsafeWriteShort(int pos, short val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putShortLE(this.data, off, val);
        } else {
            GridUnsafe.putShort(this.data, off, val);
        }
    }

    @Override
    public void unsafeWriteChar(char val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putCharLE(this.data, off, val);
        } else {
            GridUnsafe.putChar(this.data, off, val);
        }
        this.shift(2);
    }

    @Override
    public void unsafeWriteInt(int val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putIntLE(this.data, off, val);
        } else {
            GridUnsafe.putInt(this.data, off, val);
        }
        this.shift(4);
    }

    @Override
    public void unsafeWriteInt(int pos, int val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putIntLE(this.data, off, val);
        } else {
            GridUnsafe.putInt(this.data, off, val);
        }
    }

    @Override
    public void unsafeWriteLong(long val) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putLongLE(this.data, off, val);
        } else {
            GridUnsafe.putLong(this.data, off, val);
        }
        this.shift(8);
    }

    @Override
    public int capacity() {
        return this.data.length;
    }
}

