/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark.impl.optimization;

import org.apache.ignite.spark.impl.optimization.SupportedExpressions;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.DateAdd;
import org.apache.spark.sql.catalyst.expressions.DateDiff;
import org.apache.spark.sql.catalyst.expressions.DayOfMonth;
import org.apache.spark.sql.catalyst.expressions.DayOfYear;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Hour;
import org.apache.spark.sql.catalyst.expressions.Minute;
import org.apache.spark.sql.catalyst.expressions.Month;
import org.apache.spark.sql.catalyst.expressions.ParseToDate;
import org.apache.spark.sql.catalyst.expressions.Quarter;
import org.apache.spark.sql.catalyst.expressions.Second;
import org.apache.spark.sql.catalyst.expressions.WeekOfYear;
import org.apache.spark.sql.catalyst.expressions.Year;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class DateExpressions$
implements SupportedExpressions {
    public static final DateExpressions$ MODULE$;

    static {
        new DateExpressions$();
    }

    @Override
    public boolean apply(Expression expr, Function1<Expression, Object> checkChild) {
        boolean bl;
        CurrentDate currentDate;
        Option option;
        Expression expression = expr;
        if (expression instanceof CurrentDate && None$.MODULE$.equals(option = (currentDate = (CurrentDate)expression).timeZoneId())) {
            bl = true;
        } else if (expression instanceof CurrentTimestamp) {
            bl = true;
        } else if (expression instanceof DateAdd) {
            DateAdd dateAdd = (DateAdd)expression;
            Expression startDate = dateAdd.startDate();
            Expression days = dateAdd.days();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)startDate)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)days));
        } else if (expression instanceof DateDiff) {
            DateDiff dateDiff = (DateDiff)expression;
            Expression date1 = dateDiff.endDate();
            Expression date2 = dateDiff.startDate();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date1)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date2));
        } else if (expression instanceof DayOfMonth) {
            DayOfMonth dayOfMonth = (DayOfMonth)expression;
            Expression date = dayOfMonth.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date));
        } else if (expression instanceof DayOfYear) {
            DayOfYear dayOfYear = (DayOfYear)expression;
            Expression date = dayOfYear.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date));
        } else if (expression instanceof Hour) {
            Hour hour = (Hour)expression;
            Expression date = hour.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date));
        } else if (expression instanceof Minute) {
            Minute minute = (Minute)expression;
            Expression date = minute.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date));
        } else if (expression instanceof Month) {
            Month month = (Month)expression;
            Expression date = month.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date));
        } else if (expression instanceof ParseToDate) {
            ParseToDate parseToDate = (ParseToDate)expression;
            Expression left = parseToDate.left();
            Option format = parseToDate.format();
            Expression child = parseToDate.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && (format.isEmpty() || BoxesRunTime.unboxToBoolean((Object)checkChild.apply(format.get()))) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Quarter) {
            Quarter quarter = (Quarter)expression;
            Expression date = quarter.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date));
        } else if (expression instanceof Second) {
            Second second = (Second)expression;
            Expression date = second.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date));
        } else if (expression instanceof WeekOfYear) {
            WeekOfYear weekOfYear = (WeekOfYear)expression;
            Expression date = weekOfYear.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date));
        } else if (expression instanceof Year) {
            Year year = (Year)expression;
            Expression date = year.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)date));
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Option<String> toString(Expression expr, Function1<Expression, String> childToString, boolean useQualifier, boolean useAlias) {
        Expression expression = expr;
        if (expression instanceof CurrentDate) {
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CURRENT_DATE()"})).s((Seq)Nil$.MODULE$));
        }
        if (expression instanceof CurrentTimestamp) {
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CURRENT_TIMESTAMP()"})).s((Seq)Nil$.MODULE$));
        }
        if (expression instanceof DateAdd) {
            DateAdd dateAdd = (DateAdd)expression;
            Expression startDate = dateAdd.startDate();
            Expression days = dateAdd.days();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(DATEADD('DAY', ", ", ", ") AS DATE)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)days), childToString.apply((Object)startDate)})));
        }
        if (expression instanceof DateDiff) {
            DateDiff dateDiff = (DateDiff)expression;
            Expression date1 = dateDiff.endDate();
            Expression date2 = dateDiff.startDate();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(DATEDIFF('DAY', ", ", ", ") AS INT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date1), childToString.apply((Object)date2)})));
        }
        if (expression instanceof DayOfMonth) {
            DayOfMonth dayOfMonth = (DayOfMonth)expression;
            Expression date = dayOfMonth.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DAY_OF_MONTH(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date)})));
        }
        if (expression instanceof DayOfYear) {
            DayOfYear dayOfYear = (DayOfYear)expression;
            Expression date = dayOfYear.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DAY_OF_YEAR(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date)})));
        }
        if (expression instanceof Hour) {
            Hour hour = (Hour)expression;
            Expression date = hour.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HOUR(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date)})));
        }
        if (expression instanceof Minute) {
            Minute minute = (Minute)expression;
            Expression date = minute.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MINUTE(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date)})));
        }
        if (expression instanceof Month) {
            Month month = (Month)expression;
            Expression date = month.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MINUTE(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date)})));
        }
        if (expression instanceof ParseToDate) {
            Some some;
            ParseToDate parseToDate = (ParseToDate)expression;
            Expression left = parseToDate.left();
            Option formatOption = parseToDate.format();
            Option option = formatOption;
            if (option instanceof Some) {
                Some some2 = (Some)option;
                Expression format = (Expression)some2.x();
                some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PARSEDATETIME(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)format)})));
                return some;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PARSEDATETIME(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left)})));
            }
            return some;
        }
        if (expression instanceof Quarter) {
            Quarter quarter = (Quarter)expression;
            Expression date = quarter.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"QUARTER(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date)})));
        }
        if (expression instanceof Second) {
            Second second = (Second)expression;
            Expression date = second.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SECOND(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date)})));
        }
        if (expression instanceof WeekOfYear) {
            WeekOfYear weekOfYear = (WeekOfYear)expression;
            Expression date = weekOfYear.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WEEK(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date)})));
        }
        if (!(expression instanceof Year)) return None$.MODULE$;
        Year year = (Year)expression;
        Expression date = year.child();
        return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"YEAR(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)date)})));
    }

    private DateExpressions$() {
        MODULE$ = this;
    }
}

