/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.property;

import java.lang.reflect.Method;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.property.QueryPropertyAccessor;

public class QueryReadOnlyMethodsAccessor
implements QueryPropertyAccessor {
    private final Method getter;
    private final String propName;

    public QueryReadOnlyMethodsAccessor(Method getter, String propName) {
        getter.setAccessible(true);
        this.getter = getter;
        this.propName = propName;
    }

    @Override
    public Object getValue(Object obj) throws IgniteCheckedException {
        try {
            return this.getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to invoke getter method [type=" + this.getType() + ", property=" + this.propName + ']', e);
        }
    }

    @Override
    public void setValue(Object obj, Object newVal) throws IgniteCheckedException {
        throw new UnsupportedOperationException("Property is read-only [type=" + this.getType() + ", property=" + this.propName + ']');
    }

    @Override
    public String getPropertyName() {
        return this.propName;
    }

    @Override
    public Class<?> getType() {
        return this.getter.getReturnType();
    }
}

