/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.ThinClientConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerAbstractConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.platform.client.ClientAffinityTopologyVersion;
import org.apache.ignite.internal.processors.platform.client.ClientBitmaskFeature;
import org.apache.ignite.internal.processors.platform.client.ClientMessageParser;
import org.apache.ignite.internal.processors.platform.client.ClientNotification;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolVersionFeature;
import org.apache.ignite.internal.processors.platform.client.ClientRequestHandler;
import org.apache.ignite.internal.processors.platform.client.ClientResourceRegistry;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxContext;
import org.apache.ignite.internal.util.nio.GridNioSession;

public class ClientConnectionContext
extends ClientListenerAbstractConnectionContext {
    public static final ClientListenerProtocolVersion VER_1_0_0 = ClientListenerProtocolVersion.create(1, 0, 0);
    public static final ClientListenerProtocolVersion VER_1_1_0 = ClientListenerProtocolVersion.create(1, 1, 0);
    public static final ClientListenerProtocolVersion VER_1_2_0 = ClientListenerProtocolVersion.create(1, 2, 0);
    public static final ClientListenerProtocolVersion VER_1_3_0 = ClientListenerProtocolVersion.create(1, 3, 0);
    public static final ClientListenerProtocolVersion VER_1_4_0 = ClientListenerProtocolVersion.create(1, 4, 0);
    public static final ClientListenerProtocolVersion VER_1_5_0 = ClientListenerProtocolVersion.create(1, 5, 0);
    public static final ClientListenerProtocolVersion VER_1_6_0 = ClientListenerProtocolVersion.create(1, 6, 0);
    public static final ClientListenerProtocolVersion VER_1_7_0;
    public static final ClientListenerProtocolVersion DEFAULT_VER;
    public static final ClientProtocolContext DEFAULT_PROTOCOL_CONTEXT;
    private static final Collection<ClientListenerProtocolVersion> SUPPORTED_VERS;
    private ClientMessageParser parser;
    private ClientRequestHandler handler;
    private final ClientResourceRegistry resReg = new ClientResourceRegistry();
    private final int maxCursors;
    private ClientProtocolContext currentProtocolContext;
    private AtomicReference<AffinityTopologyVersion> lastAffinityTopologyVersion = new AtomicReference();
    private GridNioSession ses;
    private final AtomicLong curCnt = new AtomicLong();
    private final int maxActiveTxCnt;
    private final AtomicInteger txIdSeq = new AtomicInteger();
    private final Map<Integer, ClientTxContext> txs = new ConcurrentHashMap<Integer, ClientTxContext>();
    private final AtomicInteger txsCnt = new AtomicInteger();
    private final int maxActiveComputeTasks;
    private final AtomicInteger activeTasksCnt = new AtomicInteger();

    public ClientConnectionContext(GridKernalContext ctx, GridNioSession ses, long connId, int maxCursors, ThinClientConfiguration thinCfg) {
        super(ctx, ses, connId);
        this.maxCursors = maxCursors;
        this.maxActiveTxCnt = thinCfg.getMaxActiveTxPerConnection();
        this.maxActiveComputeTasks = thinCfg.getMaxActiveComputeTasksPerConnection();
    }

    public ClientResourceRegistry resources() {
        return this.resReg;
    }

    @Override
    public byte clientType() {
        return 2;
    }

    @Override
    public boolean isVersionSupported(ClientListenerProtocolVersion ver) {
        return SUPPORTED_VERS.contains(ver);
    }

    @Override
    public ClientListenerProtocolVersion defaultVersion() {
        return DEFAULT_VER;
    }

    public ClientProtocolContext currentProtocolContext() {
        return this.currentProtocolContext;
    }

    @Override
    public void initializeFromHandshake(GridNioSession ses, ClientListenerProtocolVersion ver, BinaryReaderExImpl reader) throws IgniteCheckedException {
        EnumSet<ClientBitmaskFeature> features = null;
        if (ClientProtocolContext.isFeatureSupported(ver, ClientProtocolVersionFeature.BITMAP_FEATURES)) {
            byte[] cliFeatures = reader.readByteArray();
            features = ClientBitmaskFeature.enumSet(cliFeatures);
        }
        this.currentProtocolContext = new ClientProtocolContext(ver, features);
        String user = null;
        String pwd = null;
        if (this.currentProtocolContext.isFeatureSupported(ClientBitmaskFeature.USER_ATTRIBUTES)) {
            this.userAttrs = reader.readMap();
        }
        if (this.currentProtocolContext.isFeatureSupported(ClientProtocolVersionFeature.AUTHORIZATION)) {
            boolean hasMore;
            try {
                hasMore = reader.available() > 0;
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Handshake error: " + e.getMessage(), e);
            }
            if (hasMore) {
                user = reader.readString();
                pwd = reader.readString();
            }
        }
        this.authenticate(ses, user, pwd);
        this.initClientDescriptor("cli");
        this.handler = new ClientRequestHandler(this, this.currentProtocolContext);
        this.parser = new ClientMessageParser(this, this.currentProtocolContext);
        this.ses = ses;
    }

    @Override
    public ClientListenerRequestHandler handler() {
        return this.handler;
    }

    @Override
    public ClientListenerMessageParser parser() {
        return this.parser;
    }

    @Override
    public void onDisconnected() {
        this.resReg.clean();
        this.cleanupTxs();
        super.onDisconnected();
    }

    public void incrementCursors() {
        long curCnt0 = this.curCnt.get();
        if (curCnt0 >= (long)this.maxCursors) {
            throw new IgniteClientException(1010, "Too many open cursors (either close other open cursors or increase the limit through ClientConnectorConfiguration.maxOpenCursorsPerConnection) [maximum=" + this.maxCursors + ", current=" + curCnt0 + ']');
        }
        this.curCnt.incrementAndGet();
    }

    public void decrementCursors() {
        this.curCnt.decrementAndGet();
    }

    public ClientAffinityTopologyVersion checkAffinityTopologyVersion() {
        AffinityTopologyVersion newVer;
        AffinityTopologyVersion oldVer;
        boolean success;
        boolean changed;
        do {
            oldVer = this.lastAffinityTopologyVersion.get();
            newVer = this.ctx.cache().context().exchange().readyAffinityVersion();
            boolean bl = changed = oldVer == null || oldVer.compareTo(newVer) < 0;
        } while (changed && !(success = this.lastAffinityTopologyVersion.compareAndSet(oldVer, newVer)));
        return new ClientAffinityTopologyVersion(newVer, changed);
    }

    public int nextTxId() {
        int txId = this.txIdSeq.incrementAndGet();
        return txId == 0 ? this.txIdSeq.incrementAndGet() : txId;
    }

    public ClientTxContext txContext(int txId) {
        return this.txs.get(txId);
    }

    public void addTxContext(ClientTxContext txCtx) {
        if (this.txsCnt.incrementAndGet() > this.maxActiveTxCnt) {
            this.txsCnt.decrementAndGet();
            throw new IgniteClientException(1020, "Active transactions per connection limit (" + this.maxActiveTxCnt + ") exceeded. To start a new transaction you need to wait for some of currently active transactions complete. To change the limit set up ThinClientConfiguration.MaxActiveTxPerConnection property.");
        }
        this.txs.put(txCtx.txId(), txCtx);
    }

    public void removeTxContext(int txId) {
        this.txs.remove(txId);
        this.txsCnt.decrementAndGet();
    }

    private void cleanupTxs() {
        for (ClientTxContext txCtx : this.txs.values()) {
            txCtx.close();
        }
        this.txs.clear();
    }

    public void notifyClient(ClientNotification notification) {
        this.ses.send(this.parser.encode(notification));
    }

    public void incrementActiveTasksCount() {
        if (this.maxActiveComputeTasks == 0) {
            throw new IgniteClientException(100, "Compute grid functionality is disabled for thin clients on server node. To enable it set up the ThinClientConfiguration.MaxActiveComputeTasksPerConnection property.");
        }
        if (this.activeTasksCnt.incrementAndGet() > this.maxActiveComputeTasks) {
            this.activeTasksCnt.decrementAndGet();
            throw new IgniteClientException(1030, "Active compute tasks per connection limit (" + this.maxActiveComputeTasks + ") exceeded. To start a new task you need to wait for some of currently active tasks complete. To change the limit set up the ThinClientConfiguration.MaxActiveComputeTasksPerConnection property.");
        }
    }

    public void decrementActiveTasksCount() {
        int cnt = this.activeTasksCnt.decrementAndGet();
        assert (cnt >= 0) : "Unexpected active tasks count: " + cnt;
    }

    static {
        DEFAULT_VER = VER_1_7_0 = ClientListenerProtocolVersion.create(1, 7, 0);
        DEFAULT_PROTOCOL_CONTEXT = new ClientProtocolContext(DEFAULT_VER, ClientBitmaskFeature.allFeaturesAsEnumSet());
        SUPPORTED_VERS = Arrays.asList(VER_1_7_0, VER_1_6_0, VER_1_5_0, VER_1_4_0, VER_1_3_0, VER_1_2_0, VER_1_1_0, VER_1_0_0);
    }
}

