/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.filehandle;

import java.util.function.Supplier;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileHandleManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileHandleManagerImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileWriteHandle;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FsyncFileHandleManagerImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;

public class FileHandleManagerFactory {
    private final boolean walFsyncWithDedicatedWorker = IgniteSystemProperties.getBoolean("IGNITE_WAL_FSYNC_WITH_DEDICATED_WORKER", false);
    private final DataStorageConfiguration dsConf;

    public FileHandleManagerFactory(DataStorageConfiguration conf) {
        this.dsConf = conf;
    }

    public FileHandleManager build(GridCacheSharedContext cctx, DataStorageMetricsImpl metrics, boolean mmap, RecordSerializer serializer, Supplier<FileWriteHandle> currHandleSupplier) {
        if (this.dsConf.getWalMode() == WALMode.FSYNC && !this.walFsyncWithDedicatedWorker) {
            return new FsyncFileHandleManagerImpl(cctx, metrics, serializer, currHandleSupplier, this.dsConf.getWalMode(), this.dsConf.getWalSegmentSize(), this.dsConf.getWalFsyncDelayNanos(), this.dsConf.getWalThreadLocalBufferSize());
        }
        return new FileHandleManagerImpl(cctx, metrics, mmap, serializer, currHandleSupplier, this.dsConf.getWalMode(), this.dsConf.getWalBufferSize(), this.dsConf.getWalSegmentSize(), this.dsConf.getWalFsyncDelayNanos());
    }
}

