/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;

public abstract class BPlusInnerIO<L>
extends BPlusIO<L> {
    private static final int SHIFT_LEFT = 58;
    private static final int SHIFT_LINK = 66;
    private final int SHIFT_RIGHT;

    protected BPlusInnerIO(int type, int ver, boolean canGetRow, int itemSize) {
        super(type, ver, false, canGetRow, itemSize);
        this.SHIFT_RIGHT = 66 + this.itemSize;
    }

    @Override
    public int getMaxCount(long pageAddr, int pageSize) {
        return (pageSize - 58 - 8) / (this.getItemSize() + 8);
    }

    public final long getLeft(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset0(idx, 58));
    }

    public final void setLeft(long pageAddr, int idx, long pageId) {
        PageUtils.putLong(pageAddr, this.offset0(idx, 58), pageId);
        assert (pageId == this.getLeft(pageAddr, idx));
    }

    public final long getRight(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset0(idx, this.SHIFT_RIGHT));
    }

    private void setRight(long pageAddr, int idx, long pageId) {
        PageUtils.putLong(pageAddr, this.offset0(idx, this.SHIFT_RIGHT), pageId);
        assert (pageId == this.getRight(pageAddr, idx));
    }

    @Override
    public final void copyItems(long srcPageAddr, long dstPageAddr, int srcIdx, int dstIdx, int cnt, boolean cpLeft) throws IgniteCheckedException {
        assert (srcIdx != dstIdx || srcPageAddr != dstPageAddr);
        cnt *= this.getItemSize() + 8;
        if (dstIdx > srcIdx) {
            PageHandler.copyMemory(srcPageAddr, (long)this.offset(srcIdx), dstPageAddr, (long)this.offset(dstIdx), (long)cnt);
            if (cpLeft) {
                PageUtils.putLong(dstPageAddr, this.offset0(dstIdx, 58), PageUtils.getLong(srcPageAddr, this.offset0(srcIdx, 58)));
            }
        } else {
            if (cpLeft) {
                PageUtils.putLong(dstPageAddr, this.offset0(dstIdx, 58), PageUtils.getLong(srcPageAddr, this.offset0(srcIdx, 58)));
            }
            PageHandler.copyMemory(srcPageAddr, (long)this.offset(srcIdx), dstPageAddr, (long)this.offset(dstIdx), (long)cnt);
        }
    }

    private int offset0(int idx, int shift) {
        return shift + (8 + this.getItemSize()) * idx;
    }

    @Override
    public final int offset(int idx) {
        return this.offset0(idx, 66);
    }

    @Override
    public byte[] insert(long pageAddr, int idx, L row, byte[] rowBytes, long rightId, boolean needRowBytes) throws IgniteCheckedException {
        rowBytes = super.insert(pageAddr, idx, row, rowBytes, rightId, needRowBytes);
        this.setRight(pageAddr, idx, rightId);
        return rowBytes;
    }

    public byte[] initNewRoot(long newRootPageAddr, long newRootId, long leftChildId, L row, byte[] rowBytes, long rightChildId, int pageSize, boolean needRowBytes, PageMetrics metrics) throws IgniteCheckedException {
        this.initNewPage(newRootPageAddr, newRootId, pageSize, metrics);
        this.setCount(newRootPageAddr, 1);
        this.setLeft(newRootPageAddr, 0, leftChildId);
        rowBytes = this.store(newRootPageAddr, 0, row, rowBytes, needRowBytes);
        this.setRight(newRootPageAddr, 0, rightChildId);
        return rowBytes;
    }
}

